/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fileClasses;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.fileClasses.JvmMultifileClassPartInfo;
import org.jetbrains.kotlin.fileClasses.JvmSimpleFileClassInfo;
import org.jetbrains.kotlin.fileClasses.ParsedJvmFileClassAnnotations;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmNames;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0007J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\fJ\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fileClasses/JvmFileClassUtil;", "", "()V", "JVM_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getJVM_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "JVM_NAME_SHORT", "", "getJVM_NAME_SHORT", "()Ljava/lang/String;", "findAnnotationEntryOnFileNoResolve", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "shortName", "getFacadeClassInternalName", "getFileClassInfoNoResolve", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "getFileClassInternalName", "getLiteralStringFromAnnotation", "annotation", "getPartFqNameForDeserialized", "descriptor", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedMemberDescriptor;", "manglePartName", "facadeName", "fileName", "parseJvmNameOnFileNoResolve", "Lorg/jetbrains/kotlin/fileClasses/ParsedJvmFileClassAnnotations;", "frontend.java"})
public final class JvmFileClassUtil {
    @NotNull
    public static final JvmFileClassUtil INSTANCE = new JvmFileClassUtil();
    @NotNull
    private static final FqName JVM_NAME = new FqName("kotlin.jvm.JvmName");
    @NotNull
    private static final String JVM_NAME_SHORT;

    private JvmFileClassUtil() {
    }

    @NotNull
    public final FqName getJVM_NAME() {
        return JVM_NAME;
    }

    @NotNull
    public final String getJVM_NAME_SHORT() {
        return JVM_NAME_SHORT;
    }

    @NotNull
    public final FqName getPartFqNameForDeserialized(@NotNull DeserializedMemberDescriptor descriptor2) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        JvmClassName jvmClassName = UtilKt.getImplClassNameForDeserialized(descriptor2);
        FqName fqName3 = fqName2 = jvmClassName != null ? jvmClassName.getFqNameForTopLevelClassMaybeWithDollars() : null;
        if (fqName2 == null) {
            throw new IllegalStateException(("No implClassName for " + descriptor2).toString());
        }
        return fqName2;
    }

    @JvmStatic
    @NotNull
    public static final String getFileClassInternalName(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JvmFileClassUtilKt.getInternalNameWithoutInnerClasses(JvmFileClassUtil.getFileClassInfoNoResolve(file).getFileClassFqName());
    }

    @JvmStatic
    @NotNull
    public static final String getFacadeClassInternalName(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JvmFileClassUtilKt.getInternalNameWithoutInnerClasses(JvmFileClassUtil.getFileClassInfoNoResolve(file).getFacadeClassFqName());
    }

    private final String manglePartName(String facadeName, String fileName) {
        return facadeName + "__" + PackagePartClassUtils.getFilePartShortName(fileName);
    }

    @JvmStatic
    @NotNull
    public static final JvmFileClassInfo getFileClassInfoNoResolve(@NotNull KtFile file) {
        JvmFileClassInfo jvmFileClassInfo;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ParsedJvmFileClassAnnotations parsedAnnotations = INSTANCE.parseJvmNameOnFileNoResolve(file);
        Object object = parsedAnnotations;
        if (object == null || (object = ((ParsedJvmFileClassAnnotations)object).getJvmPackageName()) == null) {
            object = file.getPackageFqName();
        }
        Object packageFqName = object;
        if (parsedAnnotations != null) {
            String string = parsedAnnotations.getJvmName();
            if (string == null) {
                String string2 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.name");
                string = PackagePartClassUtils.getFilePartShortName(string2);
            }
            String simpleName = string;
            FqName fqName2 = ((FqName)packageFqName).child(Name.identifier(simpleName));
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"packageFqName.child(Name.identifier(simpleName))");
            FqName facadeClassFqName = fqName2;
            if (parsedAnnotations.isMultifileClass()) {
                String string3 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.name");
                FqName fqName3 = ((FqName)packageFqName).child(Name.identifier(INSTANCE.manglePartName(simpleName, string3)));
                Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"packageFqName.child(Name\u2026(simpleName, file.name)))");
                jvmFileClassInfo = new JvmMultifileClassPartInfo(fqName3, facadeClassFqName);
            } else {
                jvmFileClassInfo = new JvmSimpleFileClassInfo(facadeClassFqName, true);
            }
        } else {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            jvmFileClassInfo = new JvmSimpleFileClassInfo(PackagePartClassUtils.getPackagePartFqName((FqName)packageFqName, string), false);
        }
        return jvmFileClassInfo;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ParsedJvmFileClassAnnotations parseJvmNameOnFileNoResolve(KtFile file) {
        jvmNameAnnotation = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file, JvmFileClassUtil.JVM_NAME_SHORT);
        v0 /* !! */  = jvmNameAnnotation;
        if (v0 /* !! */  == null) ** GOTO lbl-1000
        p0 = v0 /* !! */ ;
        $i$a$-let-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmName$1 = false;
        v1 = this.getLiteralStringFromAnnotation(p0);
        v0 /* !! */  = v1;
        if (v1 != null) {
            p0 = var5_6 /* !! */  = v0 /* !! */ ;
            $i$a$-takeIf-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmName$2 = false;
            v2 /* !! */  = Name.isValidIdentifier((String)p0) ? var5_6 /* !! */  : null;
        } else lbl-1000:
        // 2 sources

        {
            v2 /* !! */  = jvmName = null;
        }
        if ((v3 /* !! */  = (jvmPackageNameAnnotation = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file, JvmNames.INSTANCE.getJVM_PACKAGE_NAME_SHORT()))) == null) ** GOTO lbl-1000
        p0 = v3 /* !! */ ;
        $i$a$-let-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmPackageName$1 = false;
        v4 = this.getLiteralStringFromAnnotation(p0);
        v3 /* !! */  = v4;
        if (v4 != null) {
            p0 = v3 /* !! */ ;
            $i$a$-let-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmPackageName$2 = false;
            v5 = new FqName((String)p0);
        } else lbl-1000:
        // 2 sources

        {
            v5 = jvmPackageName = null;
        }
        if (jvmName == null && jvmPackageName == null) {
            return null;
        }
        isMultifileClass = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file, JvmNames.INSTANCE.getJVM_MULTIFILE_CLASS_SHORT()) != null;
        return new ParsedJvmFileClassAnnotations((String)jvmName, jvmPackageName, isMultifileClass);
    }

    @JvmStatic
    @Nullable
    public static final KtAnnotationEntry findAnnotationEntryOnFileNoResolve(@NotNull KtFile file, @NotNull String shortName) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
        Object object = file.getFileAnnotationList();
        if (object != null && (object = object.getAnnotationEntries()) != null) {
            Object v2;
            block3: {
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl = false;
                    KtConstructorCalleeExpression ktConstructorCalleeExpression = it.getCalleeExpression();
                    if (!Intrinsics.areEqual((Object)(ktConstructorCalleeExpression != null && (ktConstructorCalleeExpression = ktConstructorCalleeExpression.getConstructorReferenceExpression()) != null ? ktConstructorCalleeExpression.getReferencedName() : null), (Object)shortName)) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            ktAnnotationEntry = v2;
        } else {
            ktAnnotationEntry = null;
        }
        return ktAnnotationEntry;
    }

    @Nullable
    public final String getLiteralStringFromAnnotation(@NotNull KtAnnotationEntry annotation) {
        ValueArgument valueArgument;
        block8: {
            block7: {
                KtStringTemplateExpression ktStringTemplateExpression;
                Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
                List list = annotation.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"annotation.valueArguments");
                valueArgument = (ValueArgument)CollectionsKt.firstOrNull((List)list);
                if (valueArgument == null) break block7;
                ValueArgument $this$getLiteralStringFromAnnotation_u24lambda_u2d4 = valueArgument;
                boolean bl = false;
                if ($this$getLiteralStringFromAnnotation_u24lambda_u2d4 instanceof KtValueArgument) {
                    ktStringTemplateExpression = ((KtValueArgument)$this$getLiteralStringFromAnnotation_u24lambda_u2d4).getStringTemplateExpression();
                } else {
                    KtExpression $this$safeAs$iv = $this$getLiteralStringFromAnnotation_u24lambda_u2d4.getArgumentExpression();
                    boolean $i$f$safeAs = false;
                    KtExpression ktExpression = $this$safeAs$iv;
                    if (!(ktExpression instanceof KtStringTemplateExpression)) {
                        ktExpression = null;
                    }
                    ktStringTemplateExpression = (KtStringTemplateExpression)ktExpression;
                }
                valueArgument = ktStringTemplateExpression;
                if (ktStringTemplateExpression != null) break block8;
            }
            return null;
        }
        ValueArgument stringTemplateExpression = valueArgument;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = stringTemplateExpression.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"stringTemplateExpression.entries");
        Object object = ArraysKt.singleOrNull((Object[])ktStringTemplateEntryArray);
        KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = object instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)object : null;
        if (ktLiteralStringTemplateEntry == null) {
            return null;
        }
        KtLiteralStringTemplateEntry singleEntry = ktLiteralStringTemplateEntry;
        return singleEntry.getText();
    }

    static {
        String string = JVM_NAME.shortName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JVM_NAME.shortName().asString()");
        JVM_NAME_SHORT = string;
    }
}

