/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import com.intellij.openapi.project.Project;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.js.JsProtoBuf;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.ProtocolStringList;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.AnnotationSerializer;
import org.jetbrains.kotlin.serialization.ApproximatingStringTable;
import org.jetbrains.kotlin.serialization.DescriptorAwareStringTable;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.SerializerExtension;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.JsSerializerProtocol;
import org.jetbrains.kotlin.serialization.js.KotlinDeserializedFileMetadata;
import org.jetbrains.kotlin.serialization.js.KotlinFileMetadata;
import org.jetbrains.kotlin.serialization.js.KotlinFileRegistry;
import org.jetbrains.kotlin.serialization.js.KotlinJavaScriptLibraryParts;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptPackageFragment;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptPackageFragmentProviderKt;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtilKt;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializerExtension;
import org.jetbrains.kotlin.serialization.js.KotlinPsiFileMetadata;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.serialization.js.PackagesWithHeaderMetadata;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0002J.\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007JD\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\t2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001d\u001a\u00020*J \u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010!\u001a\u00020\"2\u0006\u0010/\u001a\u000200H\u0002J \u00101\u001a\u0002022\u0006\u0010\b\u001a\u00020\t2\b\u00103\u001a\u0004\u0018\u00010\u00072\u0006\u0010&\u001a\u00020'J4\u00104\u001a\u0002052\u0006\u0010!\u001a\u00020\"2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\t072\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializationUtil;", "", "()V", "CLASS_METADATA_FILE_EXTENSION", "", "getPackagesFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getSubPackagesFqNames", "", "packageFragmentProvider", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "fqName", "result", "", "readDescriptors", "metadata", "Lorg/jetbrains/kotlin/serialization/js/PackagesWithHeaderMetadata;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "configuration", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "readModuleAsProto", "Lorg/jetbrains/kotlin/serialization/js/KotlinJavaScriptLibraryParts;", "", "metadataVersion", "Lorg/jetbrains/kotlin/utils/JsMetadataVersion;", "serializeDescriptors", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "scope", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "serializeFiles", "Lorg/jetbrains/kotlin/metadata/js/JsProtoBuf$Files;", "fileRegistry", "Lorg/jetbrains/kotlin/serialization/js/KotlinFileRegistry;", "serializer", "Lorg/jetbrains/kotlin/serialization/AnnotationSerializer;", "serializeHeader", "Lorg/jetbrains/kotlin/metadata/js/JsProtoBuf$Header;", "packageFqName", "serializeMetadata", "Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializationUtil$SerializedMetadata;", "jsDescriptor", "Lorg/jetbrains/kotlin/serialization/js/JsModuleDescriptor;", "SerializedMetadata", "js.serializer"})
public final class KotlinJavascriptSerializationUtil {
    @NotNull
    public static final KotlinJavascriptSerializationUtil INSTANCE = new KotlinJavascriptSerializationUtil();
    @NotNull
    public static final String CLASS_METADATA_FILE_EXTENSION = "kjsm";

    private KotlinJavascriptSerializationUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PackageFragmentProvider readDescriptors(@NotNull PackagesWithHeaderMetadata metadata, @NotNull StorageManager storageManager, @NotNull ModuleDescriptor module, @NotNull DeserializationConfiguration configuration, @NotNull LookupTracker lookupTracker) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)lookupTracker, (String)"lookupTracker");
        Iterable $this$map$iv = metadata.getPackages();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            byte[] byArray = (byte[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ProtoBuf.PackageFragment.parseFrom((byte[])it, JsSerializerProtocol.INSTANCE.getExtensionRegistry()));
        }
        List scopeProto = (List)destination$iv$iv;
        JsProtoBuf.Header headerProto = JsProtoBuf.Header.parseFrom(CodedInputStream.newInstance(metadata.getHeader()), JsSerializerProtocol.INSTANCE.getExtensionRegistry());
        Intrinsics.checkNotNullExpressionValue((Object)headerProto, (String)"headerProto");
        return KotlinJavascriptPackageFragmentProviderKt.createKotlinJavascriptPackageFragmentProvider(storageManager, module, headerProto, scopeProto, metadata.getMetadataVersion(), configuration, lookupTracker);
    }

    @NotNull
    public final SerializedMetadata serializeMetadata(@NotNull BindingContext bindingContext, @NotNull JsModuleDescriptor<? extends ModuleDescriptor> jsDescriptor, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull JsMetadataVersion metadataVersion, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter(jsDescriptor, (String)"jsDescriptor");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Map<FqName, byte[]> serializedFragments = KotlinJavascriptSerializationUtilKt.missingMetadata(MapsKt.emptyMap(), bindingContext, jsDescriptor.getData(), languageVersionSettings, metadataVersion, project);
        return new SerializedMetadata(serializedFragments, jsDescriptor, languageVersionSettings, metadataVersion);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProtoBuf.PackageFragment serializeDescriptors(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module, @NotNull Collection<? extends DeclarationDescriptor> scope2, @NotNull FqName fqName2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Project project, @NotNull BinaryVersion metadataVersion) {
        void $this$filterNotTo$iv$iv;
        void $this$sortedBy$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
        ProtoBuf.PackageFragment.Builder builder = ProtoBuf.PackageFragment.newBuilder();
        Function1 skip2 = (Function1)new Function1<DeclarationDescriptor, Boolean>(module){
            final /* synthetic */ ModuleDescriptor $module;
            {
                this.$module = $module;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull DeclarationDescriptor descriptor2) {
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getModule(descriptor2), (Object)this.$module)) {
                    return true;
                }
                if (descriptor2 instanceof MemberDescriptor && ((MemberDescriptor)descriptor2).isExpect()) {
                    return !(descriptor2 instanceof ClassDescriptor) || !OptionalAnnotationUtil.shouldGenerateExpectClass((ClassDescriptor)((ClassDescriptor)descriptor2));
                }
                return false;
            }
        };
        KotlinFileRegistry fileRegistry = new KotlinFileRegistry();
        KotlinJavascriptSerializerExtension extension = new KotlinJavascriptSerializerExtension(fileRegistry, languageVersionSettings, metadataVersion);
        Iterable $this$filterIsInstance$iv = scope2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ClassDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List classDescriptors2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ClassDescriptor it = (ClassDescriptor)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)DescriptorUtilsKt.getFqNameSafe(it).asString());
                it = (ClassDescriptor)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)DescriptorUtilsKt.getFqNameSafe(it).asString())));
            }
        });
        DescriptorSerializer serializer = DescriptorSerializer.Companion.createTopLevel$default((DescriptorSerializer.Companion)DescriptorSerializer.Companion, (SerializerExtension)((SerializerExtension)extension), null, (int)2, null);
        KotlinJavascriptSerializationUtil.serializeDescriptors$serializeClasses((Function1<? super DeclarationDescriptor, Boolean>)skip2, extension, project, builder, classDescriptors2, serializer);
        ApproximatingStringTable stringTable = extension.getStringTable();
        Iterable $this$filterNot$iv = scope2;
        boolean $i$f$filterNot = false;
        Iterable iterable2 = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            if (((Boolean)skip2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List members = (List)destination$iv$iv2;
        builder.setPackage(serializer.packagePartProto(fqName2, (Collection)members).build());
        builder.setExtension(JsProtoBuf.packageFragmentFiles, this.serializeFiles(fileRegistry, bindingContext, new AnnotationSerializer((DescriptorAwareStringTable)stringTable)));
        Pair pair = stringTable.buildProto();
        ProtoBuf.StringTable strings = (ProtoBuf.StringTable)pair.component1();
        ProtoBuf.QualifiedNameTable qualifiedNames = (ProtoBuf.QualifiedNameTable)pair.component2();
        builder.setStrings(strings);
        builder.setQualifiedNames(qualifiedNames);
        ProtoBuf.PackageFragment packageFragment = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)packageFragment, (String)"builder.build()");
        return packageFragment;
    }

    /*
     * WARNING - void declaration
     */
    private final JsProtoBuf.Files serializeFiles(KotlinFileRegistry fileRegistry, BindingContext bindingContext, AnnotationSerializer serializer) {
        JsProtoBuf.Files.Builder filesProto = JsProtoBuf.Files.newBuilder();
        Iterable $this$sortedBy$iv = fileRegistry.getFileIds().entrySet();
        boolean $i$f$sortedBy = false;
        for (Map.Entry entry : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getValue();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getValue()));
            }
        })) {
            List list;
            Object object;
            KotlinFileMetadata file = (KotlinFileMetadata)entry.getKey();
            int id = ((Number)entry.getValue()).intValue();
            JsProtoBuf.File.Builder fileProto = JsProtoBuf.File.newBuilder();
            if (id != filesProto.getFileCount()) {
                fileProto.setId(id);
            }
            if ((object = file) instanceof KotlinPsiFileMetadata) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = ((KotlinPsiFileMetadata)file).getKtFile().getAnnotationEntries();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Object object2 = bindingContext.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)it);
                    Intrinsics.checkNotNull((Object)object2);
                    collection.add((AnnotationDescriptor)object2);
                }
                list = (List)destination$iv$iv;
            } else if (object instanceof KotlinDeserializedFileMetadata) {
                KotlinJavascriptPackageFragment.FileHolder fileHolder = ((KotlinDeserializedFileMetadata)file).getPackageFragment().getFileMap().get(((KotlinDeserializedFileMetadata)file).getFileId());
                Intrinsics.checkNotNull((Object)fileHolder);
                list = fileHolder.getAnnotations();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List annotations2 = list;
            object = DescriptorUtilsKt.filterOutSourceAnnotations(annotations2).iterator();
            while (object.hasNext()) {
                AnnotationDescriptor annotation = (AnnotationDescriptor)object.next();
                fileProto.addAnnotation(serializer.serializeAnnotation(annotation));
            }
            filesProto.addFile(fileProto);
        }
        JsProtoBuf.Files files = filesProto.build();
        Intrinsics.checkNotNullExpressionValue((Object)files, (String)"filesProto.build()");
        return files;
    }

    @NotNull
    public final JsProtoBuf.Header serializeHeader(@NotNull ModuleDescriptor module, @Nullable FqName packageFqName, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        JsProtoBuf.Header.Builder header = JsProtoBuf.Header.newBuilder();
        if (packageFqName != null) {
            header.setPackageFqName(packageFqName.asString());
        }
        if (languageVersionSettings.isPreRelease()) {
            header.setFlags(1);
        }
        JsProtoBuf.Header header2 = header.build();
        Intrinsics.checkNotNullExpressionValue((Object)header2, (String)"header.build()");
        return header2;
    }

    @NotNull
    public final Set<FqName> getPackagesFqNames(@NotNull ModuleDescriptor module) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Set $this$getPackagesFqNames_u24lambda_u244 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        PackageFragmentProvider packageFragmentProvider = KotlinJavascriptSerializationUtilKt.access$getPackageFragmentProviderForModuleContentWithoutDependencies(module);
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"ROOT");
        INSTANCE.getSubPackagesFqNames(packageFragmentProvider, fqName2, $this$getPackagesFqNames_u24lambda_u244);
        FqName fqName3 = FqName.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"ROOT");
        $this$getPackagesFqNames_u24lambda_u244.add(fqName3);
        return set;
    }

    private final void getSubPackagesFqNames(PackageFragmentProvider packageFragmentProvider, FqName fqName2, Set<FqName> result) {
        if (!fqName2.isRoot()) {
            result.add(fqName2);
        }
        for (FqName subPackage : packageFragmentProvider.getSubPackagesOf(fqName2, (Function1<? super Name, Boolean>)((Function1)getSubPackagesFqNames.1.INSTANCE))) {
            this.getSubPackagesFqNames(packageFragmentProvider, subPackage, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final KotlinJavaScriptLibraryParts readModuleAsProto(@NotNull byte[] metadata, @NotNull JsMetadataVersion metadataVersion) {
        ModuleKind moduleKind;
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
        Closeable closeable = new GZIPInputStream(new ByteArrayInputStream(metadata));
        Throwable throwable = null;
        try {
            GZIPInputStream stream = (GZIPInputStream)closeable;
            boolean bl = false;
            stream = TuplesKt.to((Object)JsProtoBuf.Header.parseDelimitedFrom(stream, JsSerializerProtocol.INSTANCE.getExtensionRegistry()), (Object)JsProtoBuf.Library.parseFrom(stream, JsSerializerProtocol.INSTANCE.getExtensionRegistry()));
        }
        catch (Throwable stream) {
            throwable = stream;
            throw stream;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        GZIPInputStream gZIPInputStream = stream;
        JsProtoBuf.Header header = (JsProtoBuf.Header)gZIPInputStream.component1();
        JsProtoBuf.Library content = (JsProtoBuf.Library)gZIPInputStream.component2();
        JsProtoBuf.Library.Kind kind = content.getKind();
        switch (kind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case -1: 
            case 1: {
                moduleKind = ModuleKind.PLAIN;
                break;
            }
            case 2: {
                moduleKind = ModuleKind.AMD;
                break;
            }
            case 3: {
                moduleKind = ModuleKind.COMMON_JS;
                break;
            }
            case 4: {
                moduleKind = ModuleKind.UMD;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ModuleKind moduleKind2 = moduleKind;
        Intrinsics.checkNotNullExpressionValue((Object)header, (String)"header");
        List<ProtoBuf.PackageFragment> list = content.getPackageFragmentList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"content.packageFragmentList");
        ProtocolStringList protocolStringList = content.getImportedModuleList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"content.importedModuleList");
        return new KotlinJavaScriptLibraryParts(header, list, moduleKind2, protocolStringList, metadataVersion);
    }

    private static final void serializeDescriptors$serializeClasses(Function1<? super DeclarationDescriptor, Boolean> skip2, KotlinJavascriptSerializerExtension extension, Project $project, ProtoBuf.PackageFragment.Builder builder, Collection<? extends DeclarationDescriptor> descriptors, DescriptorSerializer parentSerializer) {
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            ProtoBuf.Class classProto;
            if (!(declarationDescriptor instanceof ClassDescriptor) || ((Boolean)skip2.invoke((Object)declarationDescriptor)).booleanValue()) continue;
            DescriptorSerializer serializer = DescriptorSerializer.Companion.create((ClassDescriptor)declarationDescriptor, (SerializerExtension)extension, parentSerializer, $project);
            MemberScope memberScope2 = ((ClassDescriptor)declarationDescriptor).getUnsubstitutedInnerClassesScope();
            Intrinsics.checkNotNullExpressionValue((Object)memberScope2, (String)"descriptor.unsubstitutedInnerClassesScope");
            KotlinJavascriptSerializationUtil.serializeDescriptors$serializeClasses(skip2, extension, $project, builder, ResolutionScope.DefaultImpls.getContributedDescriptors$default(memberScope2, null, null, 3, null), serializer);
            if (serializer.classProto((ClassDescriptor)declarationDescriptor).build() == null) {
                throw new IllegalStateException(("Class not serialized: " + declarationDescriptor).toString());
            }
            builder.addClass_(classProto);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001dB7\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u0005H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializationUtil$SerializedMetadata;", "", "serializedFragments", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "jsDescriptor", "Lorg/jetbrains/kotlin/serialization/js/JsModuleDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "metadataVersion", "Lorg/jetbrains/kotlin/utils/JsMetadataVersion;", "(Ljava/util/Map;Lorg/jetbrains/kotlin/serialization/js/JsModuleDescriptor;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/utils/JsMetadataVersion;)V", "asByteArray", "asLibrary", "Lorg/jetbrains/kotlin/metadata/js/JsProtoBuf$Library;", "asString", "", "serializedPackages", "", "Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializationUtil$SerializedMetadata$SerializedPackage;", "appendPackageFragments", "", "Ljava/io/OutputStream;", "writeProto", "fieldNumber", "", "content", "SerializedPackage", "js.serializer"})
    public static final class SerializedMetadata {
        @NotNull
        private final Map<FqName, byte[]> serializedFragments;
        @NotNull
        private final JsModuleDescriptor<ModuleDescriptor> jsDescriptor;
        @NotNull
        private final LanguageVersionSettings languageVersionSettings;
        @NotNull
        private final JsMetadataVersion metadataVersion;

        public SerializedMetadata(@NotNull Map<FqName, byte[]> serializedFragments, @NotNull JsModuleDescriptor<? extends ModuleDescriptor> jsDescriptor, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull JsMetadataVersion metadataVersion) {
            Intrinsics.checkNotNullParameter(serializedFragments, (String)"serializedFragments");
            Intrinsics.checkNotNullParameter(jsDescriptor, (String)"jsDescriptor");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
            this.serializedFragments = serializedFragments;
            this.jsDescriptor = jsDescriptor;
            this.languageVersionSettings = languageVersionSettings;
            this.metadataVersion = metadataVersion;
        }

        @NotNull
        public final List<SerializedPackage> serializedPackages() {
            ArrayList<SerializedPackage> packages2 = new ArrayList<SerializedPackage>();
            for (Map.Entry<FqName, byte[]> entry : this.serializedFragments.entrySet()) {
                FqName fqName2 = entry.getKey();
                byte[] part = entry.getValue();
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                DataOutputStream $this$serializedPackages_u24lambda_u240 = new DataOutputStream(stream);
                boolean bl = false;
                int[] version = this.metadataVersion.toArray();
                $this$serializedPackages_u24lambda_u240.writeInt(version.length);
                int[] $this$forEach$iv = version;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    int element$iv;
                    int p0 = element$iv = $this$forEach$iv[i];
                    boolean bl2 = false;
                    $this$serializedPackages_u24lambda_u240.writeInt(p0);
                }
                INSTANCE.serializeHeader(this.jsDescriptor.getData(), fqName2, this.languageVersionSettings).writeDelimitedTo(stream);
                stream.write(part);
                byte[] byArray = stream.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"stream.toByteArray()");
                packages2.add(new SerializedPackage(fqName2, byArray));
            }
            return packages2;
        }

        @NotNull
        public final String asString() {
            return KotlinJavascriptMetadataUtils.INSTANCE.formatMetadataAsString(this.jsDescriptor.getName(), this.asByteArray(), this.metadataVersion);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final byte[] asByteArray() {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream $this$asByteArray_u24lambda_u243 = byteArrayOutputStream = new ByteArrayOutputStream();
            boolean bl = false;
            Closeable closeable = new GZIPOutputStream($this$asByteArray_u24lambda_u243);
            Throwable throwable = null;
            try {
                GZIPOutputStream stream = (GZIPOutputStream)closeable;
                boolean bl2 = false;
                INSTANCE.serializeHeader(this.jsDescriptor.getData(), null, this.languageVersionSettings).writeDelimitedTo(stream);
                this.asLibrary().writeTo(stream);
                this.appendPackageFragments(stream);
                Iterable $this$forEach$iv = this.jsDescriptor.getImported();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    OutputStream outputStream = stream;
                    byte[] byArray = it.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    this.writeProto(outputStream, 3, byArray);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"ByteArrayOutputStream().\u2026          }.toByteArray()");
            return byArray;
        }

        private final JsProtoBuf.Library asLibrary() {
            JsProtoBuf.Library.Kind kind;
            ModuleKind moduleKind = this.jsDescriptor.getKind();
            JsProtoBuf.Library.Builder builder = JsProtoBuf.Library.newBuilder();
            switch (WhenMappings.$EnumSwitchMapping$0[moduleKind.ordinal()]) {
                case 1: {
                    kind = JsProtoBuf.Library.Kind.PLAIN;
                    break;
                }
                case 2: {
                    kind = JsProtoBuf.Library.Kind.AMD;
                    break;
                }
                case 3: {
                    kind = JsProtoBuf.Library.Kind.COMMON_JS;
                    break;
                }
                case 4: {
                    kind = JsProtoBuf.Library.Kind.UMD;
                    break;
                }
                case 5: {
                    throw new IllegalStateException("Es modules serialization".toString());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            JsProtoBuf.Library.Kind moduleProtoKind = kind;
            if (builder.getKind() != moduleProtoKind) {
                builder.setKind(moduleProtoKind);
            }
            JsProtoBuf.Library library = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)library, (String)"builder.build()");
            return library;
        }

        private final void writeProto(OutputStream $this$writeProto, int fieldNumber, byte[] content) {
            int size;
            $this$writeProto.write(fieldNumber << 3 | 2);
            for (size = content.length; size > 127; size >>>= 7) {
                $this$writeProto.write(0x80 | size & 0x7F);
            }
            $this$writeProto.write(size);
            $this$writeProto.write(content);
        }

        private final void appendPackageFragments(OutputStream $this$appendPackageFragments) {
            Iterable $this$sortedBy$iv = this.serializedFragments.entrySet();
            boolean $i$f$sortedBy = false;
            Iterator iterator2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry entry = (Map.Entry)a;
                    boolean bl = false;
                    FqName fqName2 = (FqName)entry.getKey();
                    entry = (Map.Entry)b;
                    Comparable comparable = (Comparable)((Object)fqName2.asString());
                    bl = false;
                    fqName2 = (FqName)entry.getKey();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)fqName2.asString())));
                }
            }).iterator();
            while (iterator2.hasNext()) {
                byte[] fragment = (byte[])((Map.Entry)iterator2.next()).getValue();
                this.writeProto($this$appendPackageFragments, 2, fragment);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializationUtil$SerializedMetadata$SerializedPackage;", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "bytes", "", "(Lorg/jetbrains/kotlin/name/FqName;[B)V", "getBytes", "()[B", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "js.serializer"})
        public static final class SerializedPackage {
            @NotNull
            private final FqName fqName;
            @NotNull
            private final byte[] bytes;

            public SerializedPackage(@NotNull FqName fqName2, @NotNull byte[] bytes2) {
                Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
                Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
                this.fqName = fqName2;
                this.bytes = bytes2;
            }

            @NotNull
            public final FqName getFqName() {
                return this.fqName;
            }

            @NotNull
            public final byte[] getBytes() {
                return this.bytes;
            }
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ModuleKind.values().length];
                try {
                    nArray[ModuleKind.PLAIN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ModuleKind.AMD.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ModuleKind.COMMON_JS.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ModuleKind.UMD.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ModuleKind.ES.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsProtoBuf.Library.Kind.values().length];
            try {
                nArray[JsProtoBuf.Library.Kind.PLAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsProtoBuf.Library.Kind.AMD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsProtoBuf.Library.Kind.COMMON_JS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsProtoBuf.Library.Kind.UMD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

