/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.checkers.JavaNullabilityChecker;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeWithEnhancementKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypePreparator;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaOverrideWithWrongNullabilityOverrideChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "typePreparatorUnwrappingEnhancement", "Lorg/jetbrains/kotlin/types/checker/KotlinTypePreparator;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class JavaOverrideWithWrongNullabilityOverrideChecker
implements DeclarationChecker {
    @NotNull
    public static final JavaOverrideWithWrongNullabilityOverrideChecker INSTANCE = new JavaOverrideWithWrongNullabilityOverrideChecker();
    @NotNull
    private static final KotlinTypePreparator typePreparatorUnwrappingEnhancement = new KotlinTypePreparator(){

        @NotNull
        public UnwrappedType prepareType(@NotNull KotlinTypeMarker type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            UnwrappedType it = super.prepareType(type2);
            boolean bl = false;
            KotlinType kotlinType = TypeWithEnhancementKt.getEnhancementDeeply(it);
            if (kotlinType == null) {
                kotlinType = it;
            }
            return kotlinType.unwrap();
        }
    };

    private JavaOverrideWithWrongNullabilityOverrideChecker() {
    }

    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        boolean hasOverrideNode;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(descriptor2 instanceof CallableMemberDescriptor)) {
            return;
        }
        if (((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors().isEmpty()) {
            return;
        }
        KtModifierList modifierList = declaration.getModifierList();
        boolean bl = hasOverrideNode = modifierList != null && modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        if (!hasOverrideNode) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor2).getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor containingClass = classDescriptor;
        for (CallableMemberDescriptor callableMemberDescriptor : ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors()) {
            FunctionDescriptor unwrappedOverridden2;
            OverridingUtil overridingUtilWithEnhancementUnwrapped2;
            if (!(callableMemberDescriptor instanceof JavaMethodDescriptor)) continue;
            Set relatedTypeParameters = new LinkedHashSet();
            Intrinsics.checkNotNullExpressionValue((Object)OverridingUtil.createWithTypePreparatorAndCustomSubtype(typePreparatorUnwrappingEnhancement, (Function2<KotlinType, KotlinType, Boolean>)((Function2)new Function2<KotlinType, KotlinType, Boolean>((Set<TypeParameterDescriptor>)relatedTypeParameters){
                final /* synthetic */ Set<TypeParameterDescriptor> $relatedTypeParameters;
                {
                    this.$relatedTypeParameters = $relatedTypeParameters;
                    super(2);
                }

                public final Boolean invoke(KotlinType subtype, KotlinType supertype) {
                    Intrinsics.checkNotNullExpressionValue((Object)subtype, (String)"subtype");
                    Intrinsics.checkNotNullExpressionValue((Object)supertype, (String)"supertype");
                    boolean bl = JavaNullabilityChecker.Companion.isNullableTypeAgainstNotNullTypeParameter(subtype, supertype);
                    Set<TypeParameterDescriptor> set = this.$relatedTypeParameters;
                    boolean it = bl;
                    boolean bl2 = false;
                    if (it) {
                        ClassifierDescriptor classifierDescriptor = subtype.getConstructor().getDeclarationDescriptor();
                        CollectionsKt.addIfNotNull((Collection)set, classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null);
                    }
                    return !bl;
                }
            })), (String)"relatedTypeParameters = \u2026  }\n                    }");
            if (overridingUtilWithEnhancementUnwrapped2.isOverridableBy(callableMemberDescriptor, (CallableDescriptor)descriptor2, containingClass, true).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE || OverridingUtil.DEFAULT.isOverridableBy(callableMemberDescriptor, (CallableDescriptor)descriptor2, containingClass, true).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
            FunctionDescriptor functionDescriptor = ((JavaMethodDescriptor)callableMemberDescriptor).substitute(TypeSubstitutor.create(new TypeSubstitution(){

                @Nullable
                public TypeProjection get(@NotNull KotlinType key) {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    return null;
                }

                @NotNull
                public KotlinType prepareTopLevelType(@NotNull KotlinType topLevelType, @NotNull Variance position) {
                    Intrinsics.checkNotNullParameter((Object)topLevelType, (String)"topLevelType");
                    Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
                    KotlinType kotlinType = TypeWithEnhancementKt.getEnhancementDeeply(topLevelType);
                    if (kotlinType == null) {
                        kotlinType = topLevelType;
                    }
                    return kotlinType;
                }
            }));
            if (functionDescriptor == null) {
                functionDescriptor = unwrappedOverridden2 = (FunctionDescriptor)callableMemberDescriptor;
            }
            if (!((Collection)relatedTypeParameters).isEmpty()) {
                context.getTrace().report((Diagnostic)ErrorsJvm.WRONG_TYPE_PARAMETER_NULLABILITY_FOR_JAVA_OVERRIDE.on((PsiElement)declaration, kotlin.collections.CollectionsKt.first((Iterable)relatedTypeParameters)));
                break;
            }
            context.getTrace().report((Diagnostic)ErrorsJvm.WRONG_NULLABILITY_FOR_JAVA_OVERRIDE.on((PsiElement)declaration, (Object)descriptor2, (Object)unwrappedOverridden2));
            break;
        }
    }
}

