/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolderKt;
import org.jetbrains.kotlin.jps.build.KotlinIncludedModuleSourceRoot;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001(B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020$0\u00132\u0006\u0010%\u001a\u00020\tJ\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0'2\u0006\u0010%\u001a\u00020\tR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u00060\u0014R\u00020\u00000\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0011\u0010!\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001e\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;", "", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "delegate", "Lorg/jetbrains/jps/builders/DirtyFilesHolder;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "(Lorg/jetbrains/jps/ModuleChunk;Lorg/jetbrains/jps/incremental/CompileContext;Lorg/jetbrains/jps/builders/DirtyFilesHolder;)V", "allDirtyFiles", "", "Ljava/io/File;", "getAllDirtyFiles", "()Ljava/util/Set;", "allRemovedFilesFiles", "getAllRemovedFilesFiles", "byTarget", "", "Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder$TargetFiles;", "getByTarget", "()Ljava/util/Map;", "getChunk", "()Lorg/jetbrains/jps/ModuleChunk;", "getContext", "()Lorg/jetbrains/jps/incremental/CompileContext;", "hasDirtyFiles", "", "getHasDirtyFiles", "()Z", "hasDirtyOrRemovedFiles", "getHasDirtyOrRemovedFiles", "hasRemovedFiles", "getHasRemovedFiles", "getDirtyFiles", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$Source;", "target", "getRemovedFiles", "", "TargetFiles", "jps-plugin"})
@SourceDebugExtension(value={"SMAP\nKotlinDirtySourceFilesHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinDirtySourceFilesHolder.kt\norg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,112:1\n1863#2:113\n1557#2:114\n1628#2,3:115\n774#2:118\n865#2,2:119\n1864#2:121\n188#3,3:122\n188#3,3:125\n97#3,5:128\n97#3,5:133\n*S KotlinDebug\n*F\n+ 1 KotlinDirtySourceFilesHolder.kt\norg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder\n*L\n75#1:113\n77#1:114\n77#1:115,3\n78#1:118\n78#1:119,2\n75#1:121\n64#1:122,3\n67#1:125,3\n104#1:128,5\n107#1:133,5\n*E\n"})
public final class KotlinDirtySourceFilesHolder {
    @NotNull
    private final ModuleChunk chunk;
    @NotNull
    private final CompileContext context;
    @NotNull
    private final Map<ModuleBuildTarget, TargetFiles> byTarget;

    /*
     * WARNING - void declaration
     */
    public KotlinDirtySourceFilesHolder(@NotNull ModuleChunk chunk, @NotNull CompileContext context, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> delegate) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        this.chunk = chunk;
        this.context = context;
        Map byTarget = new LinkedHashMap();
        Set set = this.chunk.getTargets();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"chunk.targets");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            File it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            ModuleBuildTarget target = (ModuleBuildTarget)element$iv;
            boolean bl = false;
            Collection collection = delegate.getRemovedFiles((BuildTarget)target);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"delegate.getRemovedFiles(target)");
            Iterable iterable = collection;
            boolean $i$f$map = false;
            void var13_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(new File((String)((Object)it)));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (File)element$iv$iv;
                boolean bl3 = false;
                if (!KotlinDirtySourceFilesHolderKt.isKotlinSourceFile(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List removedFiles = (List)destination$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
            byTarget.put(target, new TargetFiles(target, removedFiles));
        }
        delegate.processDirtyFiles((arg_0, arg_1, arg_2) -> KotlinDirtySourceFilesHolder._init_$lambda$5(byTarget, this, arg_0, arg_1, arg_2));
        this.byTarget = byTarget;
    }

    @NotNull
    public final ModuleChunk getChunk() {
        return this.chunk;
    }

    @NotNull
    public final CompileContext getContext() {
        return this.context;
    }

    @NotNull
    public final Map<ModuleBuildTarget, TargetFiles> getByTarget() {
        return this.byTarget;
    }

    public final boolean getHasRemovedFiles() {
        boolean bl;
        block3: {
            Map<ModuleBuildTarget, TargetFiles> $this$any$iv = this.byTarget;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<ModuleBuildTarget, TargetFiles>> iterator2 = $this$any$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<ModuleBuildTarget, TargetFiles> element$iv;
                    Map.Entry<ModuleBuildTarget, TargetFiles> it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    boolean bl3 = !it.getValue().getRemoved().isEmpty();
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean getHasDirtyFiles() {
        boolean bl;
        block3: {
            Map<ModuleBuildTarget, TargetFiles> $this$any$iv = this.byTarget;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<ModuleBuildTarget, TargetFiles>> iterator2 = $this$any$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<ModuleBuildTarget, TargetFiles> element$iv;
                    Map.Entry<ModuleBuildTarget, TargetFiles> it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    boolean bl3 = !it.getValue().getDirty().isEmpty();
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean getHasDirtyOrRemovedFiles() {
        return this.getHasRemovedFiles() || this.getHasDirtyFiles();
    }

    @NotNull
    public final Map<File, KotlinModuleBuildTarget.Source> getDirtyFiles(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Object object = this.byTarget.get(target);
        if (object == null || (object = ((TargetFiles)object).getDirty()) == null) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    @NotNull
    public final Collection<File> getRemovedFiles(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Object object = this.byTarget.get(target);
        if (object == null || (object = ((TargetFiles)object).getRemoved()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<File> getAllDirtyFiles() {
        void var2_2;
        void $this$flatMapTo$iv;
        Map<ModuleBuildTarget, TargetFiles> map = this.byTarget;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            Iterable list$iv = ((TargetFiles)it.getValue()).getDirty().keySet();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<File> getAllRemovedFilesFiles() {
        void var2_2;
        void $this$flatMapTo$iv;
        Map<ModuleBuildTarget, TargetFiles> map = this.byTarget;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            Iterable list$iv = ((TargetFiles)it.getValue()).getRemoved();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)var2_2;
    }

    private static final boolean _init_$lambda$5(Map $byTarget, KotlinDirtySourceFilesHolder this$0, ModuleBuildTarget target, File file, JavaSourceRootDescriptor root) {
        Intrinsics.checkNotNullParameter((Object)$byTarget, (String)"$byTarget");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        TargetFiles targetFiles = (TargetFiles)$byTarget.get(target);
        if (targetFiles == null) {
            throw new IllegalStateException(("processDirtyFiles should callback only on chunk `" + this$0.chunk + "` targets (`" + target + "` is not)").toString());
        }
        TargetFiles targetInfo = targetFiles;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        if (KotlinDirtySourceFilesHolderKt.isKotlinSourceFile(file)) {
            Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
            targetInfo._markDirty$jps_plugin(file, root);
        }
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder$TargetFiles;", "", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "removed", "", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;Lorg/jetbrains/jps/incremental/ModuleBuildTarget;Ljava/util/Collection;)V", "_dirty", "", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$Source;", "dirty", "", "getDirty", "()Ljava/util/Map;", "getRemoved", "()Ljava/util/Collection;", "getTarget", "()Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "_markDirty", "", "file", "root", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "_markDirty$jps_plugin", "jps-plugin"})
    public final class TargetFiles {
        @NotNull
        private final ModuleBuildTarget target;
        @NotNull
        private final Collection<File> removed;
        @NotNull
        private final Map<File, KotlinModuleBuildTarget.Source> _dirty;

        public TargetFiles(@NotNull ModuleBuildTarget target, Collection<? extends File> removed) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter(removed, (String)"removed");
            this.target = target;
            this.removed = removed;
            this._dirty = new LinkedHashMap();
        }

        @NotNull
        public final ModuleBuildTarget getTarget() {
            return this.target;
        }

        @NotNull
        public final Collection<File> getRemoved() {
            return this.removed;
        }

        @NotNull
        public final Map<File, KotlinModuleBuildTarget.Source> getDirty() {
            return this._dirty;
        }

        public final void _markDirty$jps_plugin(@NotNull File file, @NotNull JavaSourceRootDescriptor root) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            boolean isCrossCompiled = root instanceof KotlinIncludedModuleSourceRoot;
            File file2 = FilesKt.normalize((File)file).getAbsoluteFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file.normalize().absoluteFile");
            KotlinModuleBuildTarget.Source old = this._dirty.put(file2, new KotlinModuleBuildTarget.Source(file, isCrossCompiled));
            if (!(old == null || old.isCrossCompiled() == isCrossCompiled)) {
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append('`').append(FilesKt.normalize((File)file).getAbsoluteFile()).append("` already marked as dirty: old is cross compiled: ");
                KotlinModuleBuildTarget.Source source = old;
                Intrinsics.checkNotNull((Object)source);
                String string = stringBuilder.append(source.isCrossCompiled()).append(", new is cross compiled: ").append(isCrossCompiled).toString();
                throw new IllegalStateException(string.toString());
            }
        }
    }
}

