/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.VParentBase;
import jfxtras.icalendarfx.components.VComponent;
import jfxtras.icalendarfx.components.VEvent;
import jfxtras.icalendarfx.components.VFreeBusy;
import jfxtras.icalendarfx.components.VJournal;
import jfxtras.icalendarfx.components.VPersonal;
import jfxtras.icalendarfx.components.VTimeZone;
import jfxtras.icalendarfx.components.VTodo;
import jfxtras.icalendarfx.content.MultiLineContent;
import jfxtras.icalendarfx.content.OrdererBase;
import jfxtras.icalendarfx.content.UnfoldingStringIterator;
import jfxtras.icalendarfx.itip.AbstractITIPFactory;
import jfxtras.icalendarfx.itip.DefaultITIPFactory;
import jfxtras.icalendarfx.itip.Processable;
import jfxtras.icalendarfx.properties.calendar.CalendarScale;
import jfxtras.icalendarfx.properties.calendar.Method;
import jfxtras.icalendarfx.properties.calendar.ProductIdentifier;
import jfxtras.icalendarfx.properties.calendar.Version;
import jfxtras.icalendarfx.properties.component.misc.NonStandardProperty;
import jfxtras.icalendarfx.properties.component.misc.RequestStatus;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;

public class VCalendar
extends VParentBase<VCalendar> {
    private static final String NAME = "VCALENDAR";
    private static final String FIRST_CONTENT_LINE = "BEGIN:VCALENDAR";
    private static final String LAST_CONTENT_LINE = "END:VCALENDAR";
    private CalendarScale calendarScale;
    private Method method;
    private ProductIdentifier productIdentifier;
    private Version version;
    private List<NonStandardProperty> nonStandardProps;
    private List<VEvent> vEvents;
    private List<VTodo> vTodos;
    private List<VJournal> vJournals;
    private List<VFreeBusy> vFreeBusys;
    private List<VTimeZone> vTimeZones;
    private AbstractITIPFactory iTIPFactory;

    @Override
    public String name() {
        return NAME;
    }

    public CalendarScale getCalendarScale() {
        return this.calendarScale;
    }

    public void setCalendarScale(String calendarScale) {
        this.setCalendarScale(CalendarScale.parse(calendarScale));
    }

    public void setCalendarScale(CalendarScale calendarScale) {
        this.calendarScale = calendarScale;
        this.orderChild(calendarScale);
    }

    public VCalendar withCalendarScale(CalendarScale calendarScale) {
        this.setCalendarScale(calendarScale);
        return this;
    }

    public VCalendar withCalendarScale(String calendarScale) {
        this.setCalendarScale(calendarScale);
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.setMethod(Method.parse(method));
    }

    public void setMethod(Method method) {
        this.method = method;
        this.orderChild(method);
    }

    public void setMethod(Method.MethodType method) {
        this.setMethod(new Method(method));
    }

    public VCalendar withMethod(Method method) {
        this.setMethod(method);
        return this;
    }

    public VCalendar withMethod(Method.MethodType method) {
        this.setMethod(method);
        return this;
    }

    public VCalendar withMethod(String method) {
        this.setMethod(method);
        return this;
    }

    public ProductIdentifier getProductIdentifier() {
        return this.productIdentifier;
    }

    public void setProductIdentifier(String productIdentifier) {
        this.setProductIdentifier(ProductIdentifier.parse(productIdentifier));
    }

    public void setProductIdentifier(ProductIdentifier productIdentifier) {
        this.productIdentifier = productIdentifier;
        this.orderChild(productIdentifier);
    }

    public VCalendar withProductIdentifier(ProductIdentifier productIdentifier) {
        this.setProductIdentifier(productIdentifier);
        return this;
    }

    public VCalendar withProductIdentifier(String productIdentifier) {
        this.setProductIdentifier(productIdentifier);
        return this;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.setVersion(Version.parse(version));
    }

    public void setVersion(Version version) {
        this.version = version;
        this.orderChild(version);
    }

    public VCalendar withVersion(Version version) {
        this.setVersion(version);
        return this;
    }

    public VCalendar withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public VCalendar withVersion() {
        this.setVersion(new Version());
        return this;
    }

    public List<NonStandardProperty> getNonStandard() {
        return this.nonStandardProps;
    }

    public void setNonStandard(List<NonStandardProperty> nonStandardProps) {
        if (this.nonStandardProps != null) {
            this.nonStandardProps.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.nonStandardProps = nonStandardProps;
        if (nonStandardProps != null) {
            nonStandardProps.forEach(c -> this.orderChild((VChild)c));
        }
    }

    public VCalendar withNonStandard(List<NonStandardProperty> nonStandardProps) {
        if (this.getNonStandard() == null) {
            this.setNonStandard(new ArrayList<NonStandardProperty>());
        }
        this.getNonStandard().addAll(nonStandardProps);
        if (nonStandardProps != null) {
            nonStandardProps.forEach(c -> this.orderChild((VChild)c));
        }
        return this;
    }

    public VCalendar withNonStandard(String ... nonStandardProps) {
        List<NonStandardProperty> newElements = Arrays.stream(nonStandardProps).map(c -> NonStandardProperty.parse(c)).collect(Collectors.toList());
        return this.withNonStandard(newElements);
    }

    public VCalendar withNonStandard(NonStandardProperty ... nonStandardProps) {
        return this.withNonStandard(Arrays.asList(nonStandardProps));
    }

    public List<VEvent> getVEvents() {
        return this.vEvents;
    }

    public void setVEvents(List<VEvent> vEvents) {
        if (this.vEvents != null) {
            this.vEvents.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.vEvents = vEvents;
        if (vEvents != null) {
            vEvents.forEach(c -> this.orderChild((VChild)c));
        }
    }

    public VCalendar withVEvents(List<VEvent> vEvents) {
        if (this.getVEvents() == null) {
            this.setVEvents(new ArrayList<VEvent>());
        }
        this.getVEvents().addAll(vEvents);
        if (vEvents != null) {
            vEvents.forEach(c -> this.orderChild((VChild)c));
        }
        return this;
    }

    public VCalendar withVEvents(String ... vEvents) {
        List<VEvent> list = Arrays.stream(vEvents).map(c -> VEvent.parse(c)).collect(Collectors.toList());
        return this.withVEvents(list);
    }

    public VCalendar withVEvents(VEvent ... vEvents) {
        return this.withVEvents(Arrays.asList(vEvents));
    }

    public List<VTodo> getVTodos() {
        return this.vTodos;
    }

    public void setVTodos(List<VTodo> vTodos) {
        if (this.vTodos != null) {
            this.vTodos.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.vTodos = vTodos;
        if (vTodos != null) {
            vTodos.forEach(c -> this.orderChild((VChild)c));
        }
    }

    public VCalendar withVTodos(List<VTodo> vTodos) {
        if (this.getVTodos() == null) {
            this.setVTodos(new ArrayList<VTodo>());
        }
        this.getVTodos().addAll(vTodos);
        if (vTodos != null) {
            vTodos.forEach(c -> this.orderChild((VChild)c));
        }
        return this;
    }

    public VCalendar withVTodos(String ... vTodos) {
        List<VTodo> list = Arrays.stream(vTodos).map(c -> VTodo.parse(c)).collect(Collectors.toList());
        return this.withVTodos(list);
    }

    public VCalendar withVTodos(VTodo ... vTodos) {
        return this.withVTodos(Arrays.asList(vTodos));
    }

    public List<VJournal> getVJournals() {
        return this.vJournals;
    }

    public void setVJournals(List<VJournal> vJournals) {
        if (this.vJournals != null) {
            this.vJournals.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.vJournals = vJournals;
        if (vJournals != null) {
            vJournals.forEach(c -> this.orderChild((VChild)c));
        }
    }

    public VCalendar withVJournals(List<VJournal> vJournals) {
        if (this.getVJournals() == null) {
            this.setVJournals(new ArrayList<VJournal>());
        }
        this.getVJournals().addAll(vJournals);
        if (vJournals != null) {
            vJournals.forEach(c -> this.orderChild((VChild)c));
        }
        return this;
    }

    public VCalendar withVJournals(String ... vJournals) {
        List<VJournal> list = Arrays.stream(vJournals).map(c -> VJournal.parse(c)).collect(Collectors.toList());
        return this.withVJournals(list);
    }

    public VCalendar withVJournals(VJournal ... vJournals) {
        return this.withVJournals(Arrays.asList(vJournals));
    }

    public List<VFreeBusy> getVFreeBusies() {
        return this.vFreeBusys;
    }

    public void setVFreeBusys(List<VFreeBusy> vFreeBusys) {
        if (this.vFreeBusys != null) {
            this.vFreeBusys.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.vFreeBusys = vFreeBusys;
        if (vFreeBusys != null) {
            vFreeBusys.forEach(c -> this.orderChild((VChild)c));
        }
    }

    public VCalendar withVFreeBusies(List<VFreeBusy> vFreeBusys) {
        if (this.getVFreeBusies() == null) {
            this.setVFreeBusys(new ArrayList<VFreeBusy>());
        }
        this.getVFreeBusies().addAll(vFreeBusys);
        if (vFreeBusys != null) {
            vFreeBusys.forEach(c -> this.orderChild((VChild)c));
        }
        return this;
    }

    public VCalendar withVFreeBusies(String ... vFreeBusys) {
        List<VFreeBusy> list = Arrays.stream(vFreeBusys).map(c -> VFreeBusy.parse(c)).collect(Collectors.toList());
        return this.withVFreeBusies(list);
    }

    public VCalendar withVFreeBusies(VFreeBusy ... vFreeBusys) {
        return this.withVFreeBusies(Arrays.asList(vFreeBusys));
    }

    public List<VTimeZone> getVTimeZones() {
        return this.vTimeZones;
    }

    public void setVTimeZones(List<VTimeZone> vTimeZones) {
        if (this.vTimeZones != null) {
            this.vTimeZones.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.vTimeZones = vTimeZones;
        if (vTimeZones != null) {
            vTimeZones.forEach(c -> this.orderChild((VChild)c));
        }
    }

    public VCalendar withVTimeZones(List<VTimeZone> vTimeZones) {
        if (this.getVTimeZones() == null) {
            this.setVTimeZones(new ArrayList<VTimeZone>());
        }
        this.getVTimeZones().addAll(vTimeZones);
        if (vTimeZones != null) {
            vTimeZones.forEach(c -> this.orderChild((VChild)c));
        }
        return this;
    }

    public VCalendar withVTimeZones(String ... vTimeZones) {
        List<VTimeZone> list = Arrays.stream(vTimeZones).map(c -> VTimeZone.parse(c)).collect(Collectors.toList());
        return this.withVTimeZones(list);
    }

    public VCalendar withVTimeZones(VTimeZone ... vTimeZones) {
        return this.withVTimeZones(Arrays.asList(vTimeZones));
    }

    public List<? extends VComponent> getVComponents(VComponent vComponent) {
        if (vComponent instanceof VEvent) {
            return this.getVEvents();
        }
        if (vComponent instanceof VTodo) {
            return this.getVTodos();
        }
        if (vComponent instanceof VJournal) {
            return this.getVJournals();
        }
        if (vComponent instanceof VFreeBusy) {
            return this.getVFreeBusies();
        }
        if (vComponent instanceof VTimeZone) {
            return this.getVTimeZones();
        }
        throw new RuntimeException("Unsuppored VComponent type:" + vComponent.getClass());
    }

    public void setMethodProcessFactory(AbstractITIPFactory iTIPFactory) {
        this.iTIPFactory = iTIPFactory;
    }

    public AbstractITIPFactory getITIPFactory() {
        return this.iTIPFactory;
    }

    public List<String> processITIPMessage(VCalendar ... iTIPMessages) {
        return this.processITIPMessage(Arrays.asList(iTIPMessages));
    }

    public List<String> processITIPMessage(Collection<VCalendar> iTIPMessages) {
        ArrayList<String> log = new ArrayList<String>();
        iTIPMessages.forEach(message -> {
            Processable methodProcess;
            if (message.getMethod() == null) {
                methodProcess = this.getITIPFactory().getITIPMessageProcess(Method.MethodType.PUBLISH);
            } else {
                Method.MethodType method = (Method.MethodType)((Object)((Object)message.getMethod().getValue()));
                methodProcess = this.getITIPFactory().getITIPMessageProcess(method);
            }
            List<String> methodLog = methodProcess.process(this, (VCalendar)message);
            log.addAll(methodLog);
        });
        return log;
    }

    public List<String> processITIPMessage(String iTIPMessages) {
        ArrayList<String> log = new ArrayList<String>();
        ArrayList<String> iTIPMessageList = new ArrayList<String>();
        StringBuilder builder = new StringBuilder(1000);
        for (String line : iTIPMessages.split(System.lineSeparator())) {
            if (line.equals(FIRST_CONTENT_LINE) && builder.length() > 0) {
                iTIPMessageList.add(builder.toString());
                builder = new StringBuilder(1000);
            }
            builder.append(line + System.lineSeparator());
        }
        if (builder.length() > 0) {
            iTIPMessageList.add(builder.toString());
        }
        iTIPMessageList.forEach(message -> {
            List<String> methodLog = this.processITIPMessage(VCalendar.parse(message));
            log.addAll(methodLog);
        });
        return log;
    }

    @Deprecated
    public VComponent importVComponent(String contentText) {
        boolean isVComponentValidToAdd;
        String conflict;
        VParentBase vComponent = null;
        List<String> contentLines = Arrays.asList(contentText.split(System.lineSeparator()));
        UnfoldingStringIterator unfoldedLines = new UnfoldingStringIterator(contentLines.iterator());
        boolean useRequestStatus = true;
        vComponent.parseContent(unfoldedLines);
        String string = conflict = vComponent instanceof VEvent ? DateTimeUtilities.checkScheduleConflict((VEvent)vComponent, this.getVEvents()) : null;
        if (conflict != null) {
            List<RequestStatus> requestStatus;
            if (((VPersonal)vComponent).getRequestStatus() == null) {
                requestStatus = new ArrayList<RequestStatus>();
                ((VPersonal)vComponent).setRequestStatus(requestStatus);
            } else {
                requestStatus = ((VPersonal)vComponent).getRequestStatus();
            }
            Iterator<RequestStatus> rsIterator = requestStatus.iterator();
            while (rsIterator.hasNext()) {
                RequestStatus rs = rsIterator.next();
                if (!((String)rs.getValue()).substring(0, 3).equals("2.0")) continue;
                rsIterator.remove();
            }
            requestStatus.add(RequestStatus.parse("4.1;Event conflict with " + conflict));
        }
        if (((VPersonal)vComponent).getRequestStatus() == null) {
            isVComponentValidToAdd = true;
        } else {
            boolean bl = isVComponentValidToAdd = !((VPersonal)vComponent).getRequestStatus().stream().map(s -> (String)s.getValue()).anyMatch(s -> s.charAt(0) == '3' || s.charAt(0) == '4');
        }
        if (isVComponentValidToAdd) {
            this.addChild((VChild)((Object)vComponent));
        }
        return vComponent;
    }

    @Deprecated
    public List<String> importVComponent(VComponent newVComponent) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public List<String> errors() {
        List<String> errors = super.errors();
        if (this.getProductIdentifier() == null) {
            errors.add("PRODID is not present.  PRODID is REQUIRED and MUST NOT occur more than once");
        }
        if (this.getVersion() == null) {
            errors.add("VERSION is not present.  VERSION is REQUIRED and MUST NOT occur more than once");
        }
        return errors;
    }

    public VCalendar() {
        this.setMethodProcessFactory(new DefaultITIPFactory());
        this.orderer = new OrdererBase(this, this.getGetters());
        this.contentLineGenerator = new MultiLineContent(this.orderer, FIRST_CONTENT_LINE, LAST_CONTENT_LINE, 1000);
    }

    public VCalendar(VCalendar source) {
        this();
        source.copyChildrenInto(this);
    }

    public static VCalendar parse(Reader reader) throws IOException {
        BufferedReader br = new BufferedReader(reader);
        UnfoldingStringIterator unfoldedLineIterator = new UnfoldingStringIterator(br.lines().iterator());
        VCalendar vCalendar = new VCalendar();
        vCalendar.parseContent(unfoldedLineIterator);
        return vCalendar;
    }

    public static VCalendar parse(Path icsFilePath) throws IOException {
        return VCalendar.parse(Files.newBufferedReader(icsFilePath));
    }

    public static VCalendar parseICalendarFile(Path icsFilePath, boolean useResourceStatus) throws IOException {
        BufferedReader br = Files.newBufferedReader(icsFilePath);
        List lines = br.lines().collect(Collectors.toList());
        VCalendar vCalendar = new VCalendar();
        vCalendar.parseContent(lines.iterator());
        return vCalendar;
    }

    public static VCalendar parseICalendarFile(Path icsFilePath) throws IOException {
        BufferedReader br = Files.newBufferedReader(icsFilePath);
        List lines = br.lines().collect(Collectors.toList());
        VCalendar vCalendar = new VCalendar();
        vCalendar.parseContent(lines.iterator());
        return vCalendar;
    }

    @Override
    protected boolean isContentValid(String valueContent) {
        boolean isElementValid = super.isContentValid(valueContent);
        if (!isElementValid) {
            return false;
        }
        boolean isBeginPresent = valueContent.startsWith(FIRST_CONTENT_LINE);
        if (!isBeginPresent) {
            return false;
        }
        int lastLineIndex = valueContent.lastIndexOf(System.lineSeparator());
        if (lastLineIndex == -1) {
            return false;
        }
        boolean isEndPresent = valueContent.substring(lastLineIndex).equals(LAST_CONTENT_LINE);
        return !isEndPresent;
    }

    public static VCalendar parse(String content) {
        return VCalendar.parse(new VCalendar(), content);
    }
}

