/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.components;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jfxtras.icalendarfx.VCalendar;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.components.VDescribable;
import jfxtras.icalendarfx.components.VLastModified;
import jfxtras.icalendarfx.components.VPersonal;
import jfxtras.icalendarfx.components.VRepeatable;
import jfxtras.icalendarfx.components.VRepeatableBase;
import jfxtras.icalendarfx.properties.VPropertyElement;
import jfxtras.icalendarfx.properties.component.change.DateTimeCreated;
import jfxtras.icalendarfx.properties.component.change.LastModified;
import jfxtras.icalendarfx.properties.component.change.Sequence;
import jfxtras.icalendarfx.properties.component.descriptive.Attachment;
import jfxtras.icalendarfx.properties.component.descriptive.Categories;
import jfxtras.icalendarfx.properties.component.descriptive.Classification;
import jfxtras.icalendarfx.properties.component.descriptive.Status;
import jfxtras.icalendarfx.properties.component.descriptive.Summary;
import jfxtras.icalendarfx.properties.component.recurrence.ExceptionDates;
import jfxtras.icalendarfx.properties.component.recurrence.RecurrenceDates;
import jfxtras.icalendarfx.properties.component.recurrence.RecurrenceRule;
import jfxtras.icalendarfx.properties.component.recurrence.RecurrenceRuleCache;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RecurrenceRuleValue;
import jfxtras.icalendarfx.properties.component.relationship.Contact;
import jfxtras.icalendarfx.properties.component.relationship.RecurrenceId;
import jfxtras.icalendarfx.properties.component.relationship.RelatedTo;
import jfxtras.icalendarfx.properties.component.relationship.UniqueIdentifier;
import jfxtras.icalendarfx.properties.component.time.DateTimeStart;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;

public abstract class VDisplayable<T>
extends VPersonal<T>
implements VRepeatable<T>,
VDescribable<T>,
VLastModified<T> {
    private List<Attachment<?>> attachments;
    private List<Categories> categories;
    private Classification classification;
    private List<Contact> contacts;
    private DateTimeCreated dateTimeCreated;
    private List<ExceptionDates> exceptionDates;
    private LastModified lastModified;
    private List<RecurrenceDates> recurrenceDates;
    private RecurrenceId recurrenceId;
    private List<RelatedTo> relatedTo;
    private RecurrenceRule recurrenceRule;
    private Sequence sequence;
    private Status status;
    private Summary summary;
    private RecurrenceRuleCache recurrenceCache = new RecurrenceRuleCache(this);

    @Override
    public List<Attachment<?>> getAttachments() {
        return this.attachments;
    }

    @Override
    public void setAttachments(List<Attachment<?>> attachments) {
        if (this.attachments != null) {
            this.attachments.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.attachments = attachments;
        if (attachments != null) {
            attachments.forEach(e -> this.orderChild((VChild)e));
        }
    }

    public List<Categories> getCategories() {
        return this.categories;
    }

    public void setCategories(List<Categories> categories) {
        if (this.categories != null) {
            this.categories.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.categories = categories;
        if (categories != null) {
            categories.forEach(e -> this.orderChild((VChild)e));
        }
    }

    public T withCategories(List<Categories> categories) {
        if (this.getCategories() == null) {
            this.setCategories(new ArrayList<Categories>());
        }
        this.getCategories().addAll(categories);
        if (categories != null) {
            categories.forEach(c -> this.orderChild((VChild)c));
        }
        return (T)this;
    }

    public T withCategories(String ... categories) {
        return this.withCategories(new Categories(categories));
    }

    public T withCategories(Categories ... categories) {
        this.withCategories(new ArrayList<Categories>(Arrays.asList(categories)));
        return (T)this;
    }

    public Classification getClassification() {
        return this.classification;
    }

    public void setClassification(String classification) {
        this.setClassification(Classification.parse(classification));
    }

    public void setClassification(Classification classification) {
        this.orderChild(this.classification, (VChild)classification);
        this.classification = classification;
    }

    public void setClassification(Classification.ClassificationType classification) {
        this.setClassification(new Classification(classification));
    }

    public T withClassification(Classification classification) {
        this.setClassification(classification);
        return (T)this;
    }

    public T withClassification(Classification.ClassificationType classification) {
        this.setClassification(classification);
        return (T)this;
    }

    public T withClassification(String classification) {
        this.setClassification(classification);
        return (T)this;
    }

    public List<Contact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<Contact> contacts) {
        if (this.contacts != null) {
            this.contacts.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.contacts = contacts;
        if (contacts != null) {
            contacts.forEach(c -> this.orderChild((VChild)c));
        }
    }

    public T withContacts(List<Contact> contacts) {
        if (this.getContacts() == null) {
            this.setContacts(new ArrayList<Contact>());
        }
        this.getContacts().addAll(contacts);
        if (contacts != null) {
            contacts.forEach(c -> this.orderChild((VChild)c));
        }
        return (T)this;
    }

    public T withContacts(String ... contacts) {
        List<Contact> list = Arrays.stream(contacts).map(c -> Contact.parse(c)).collect(Collectors.toList());
        return this.withContacts(list);
    }

    public T withContacts(Contact ... contacts) {
        return this.withContacts(Arrays.asList(contacts));
    }

    public DateTimeCreated getDateTimeCreated() {
        return this.dateTimeCreated;
    }

    public void setDateTimeCreated(String dateTimeCreated) {
        this.setDateTimeCreated(DateTimeCreated.parse(dateTimeCreated));
    }

    public void setDateTimeCreated(DateTimeCreated dateTimeCreated) {
        this.orderChild(this.dateTimeCreated, (VChild)dateTimeCreated);
        this.dateTimeCreated = dateTimeCreated;
    }

    public void setDateTimeCreated(ZonedDateTime dateTimeCreated) {
        this.setDateTimeCreated(new DateTimeCreated(dateTimeCreated));
    }

    public T withDateTimeCreated(ZonedDateTime dateTimeCreated) {
        this.setDateTimeCreated(dateTimeCreated);
        return (T)this;
    }

    public T withDateTimeCreated(String dateTimeCreated) {
        this.setDateTimeCreated(dateTimeCreated);
        return (T)this;
    }

    public T withDateTimeCreated(DateTimeCreated dateTimeCreated) {
        this.setDateTimeCreated(dateTimeCreated);
        return (T)this;
    }

    public List<ExceptionDates> getExceptionDates() {
        return this.exceptionDates;
    }

    public void setExceptionDates(List<ExceptionDates> exceptionDates) {
        if (this.exceptionDates != null) {
            this.exceptionDates.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.exceptionDates = exceptionDates;
        if (exceptionDates != null) {
            exceptionDates.forEach(e -> this.orderChild((VChild)e));
        }
    }

    public T withExceptionDates(List<ExceptionDates> exceptions) {
        if (this.getExceptionDates() == null) {
            this.setExceptionDates(new ArrayList<ExceptionDates>());
        }
        this.getExceptionDates().addAll(exceptions);
        if (exceptions != null) {
            exceptions.forEach(c -> this.orderChild((VChild)c));
        }
        return (T)this;
    }

    public T withExceptionDates(String ... exceptions) {
        List<ExceptionDates> list = Arrays.stream(exceptions).map(c -> ExceptionDates.parse(c)).collect(Collectors.toList());
        return this.withExceptionDates(list);
    }

    public T withExceptionDates(Temporal ... exceptions) {
        return this.withExceptionDates(new ExceptionDates(exceptions));
    }

    public T withExceptionDates(ExceptionDates ... exceptions) {
        return this.withExceptionDates(Arrays.asList(exceptions));
    }

    @Override
    public LastModified getDateTimeLastModified() {
        return this.lastModified;
    }

    @Override
    public void setDateTimeLastModified(LastModified lastModified) {
        this.orderChild(this.lastModified, (VChild)lastModified);
        this.lastModified = lastModified;
    }

    @Override
    public List<RecurrenceDates> getRecurrenceDates() {
        return this.recurrenceDates;
    }

    @Override
    public void setRecurrenceDates(List<RecurrenceDates> recurrenceDates) {
        this.recurrenceDates = recurrenceDates;
        if (recurrenceDates != null) {
            recurrenceDates.forEach(c -> this.orderChild((VChild)c));
        }
    }

    public RecurrenceId getRecurrenceId() {
        return this.recurrenceId;
    }

    public void setRecurrenceId(RecurrenceId recurrenceId) {
        this.orderChild(this.recurrenceId, (VChild)recurrenceId);
        this.recurrenceId = recurrenceId;
    }

    public void setRecurrenceId(String recurrenceId) {
        this.setRecurrenceId(RecurrenceId.parse(recurrenceId));
    }

    public void setRecurrenceId(Temporal temporal) {
        if (temporal instanceof LocalDate || temporal instanceof LocalDateTime || temporal instanceof ZonedDateTime) {
            if (this.getRecurrenceId() == null) {
                this.setRecurrenceId(new RecurrenceId(temporal));
            } else {
                this.getRecurrenceId().setValue(temporal);
            }
        } else {
            throw new DateTimeException("Only LocalDate, LocalDateTime and ZonedDateTime supported. " + temporal.getClass().getSimpleName() + " is not supported");
        }
    }

    public T withRecurrenceId(RecurrenceId recurrenceId) {
        this.setRecurrenceId(recurrenceId);
        return (T)this;
    }

    public T withRecurrenceId(String recurrenceId) {
        this.setRecurrenceId(recurrenceId);
        return (T)this;
    }

    public T withRecurrenceId(Temporal recurrenceId) {
        this.setRecurrenceId(recurrenceId);
        return (T)this;
    }

    String checkRecurrenceIdConsistency() {
        DateTimeUtilities.DateTimeType parentDateTimeStartType;
        DateTimeUtilities.DateTimeType recurrenceIdType;
        if (this.getRecurrenceId() != null && this.recurrenceParent() != null && (recurrenceIdType = DateTimeUtilities.DateTimeType.of((Temporal)this.getRecurrenceId().getValue())) != (parentDateTimeStartType = DateTimeUtilities.DateTimeType.of((Temporal)this.recurrenceParent().getDateTimeStart().getValue()))) {
            return VPropertyElement.RECURRENCE_IDENTIFIER.toString() + ":RecurrenceId DateTimeType (" + (Object)((Object)recurrenceIdType) + ") must be same as the type of its parent's DateTimeStart (" + (Object)((Object)parentDateTimeStartType) + ")";
        }
        return null;
    }

    public List<RelatedTo> getRelatedTo() {
        return this.relatedTo;
    }

    public void setRelatedTo(List<RelatedTo> relatedTo) {
        if (this.relatedTo != null) {
            this.relatedTo.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.relatedTo = relatedTo;
        if (relatedTo != null) {
            relatedTo.forEach(c -> this.orderChild((VChild)c));
        }
    }

    public T withRelatedTo(List<RelatedTo> relatedTo) {
        if (this.getRelatedTo() == null) {
            this.setRelatedTo(new ArrayList<RelatedTo>());
        }
        this.getRelatedTo().addAll(relatedTo);
        if (relatedTo != null) {
            relatedTo.forEach(c -> this.orderChild((VChild)c));
        }
        return (T)this;
    }

    public T withRelatedTo(String ... relatedTo) {
        List<RelatedTo> list = Arrays.stream(relatedTo).map(c -> RelatedTo.parse(c)).collect(Collectors.toList());
        return this.withRelatedTo(list);
    }

    public T withRelatedTo(RelatedTo ... relatedTo) {
        return this.withRelatedTo(Arrays.asList(relatedTo));
    }

    @Override
    public RecurrenceRule getRecurrenceRule() {
        return this.recurrenceRule;
    }

    @Override
    public void setRecurrenceRule(RecurrenceRule recurrenceRule) {
        this.orderChild(this.recurrenceRule, (VChild)recurrenceRule);
        this.recurrenceRule = recurrenceRule;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.orderChild(this.sequence, (VChild)sequence);
        this.sequence = sequence;
    }

    public void setSequence(String sequence) {
        this.setSequence(Sequence.parse(sequence));
    }

    public void setSequence(Integer sequence) {
        this.setSequence(new Sequence(sequence));
    }

    public T withSequence(Sequence sequence) {
        if (this.getSequence() == null) {
            this.setSequence(sequence);
            return (T)this;
        }
        throw new IllegalArgumentException("Property can only occur once in the calendar component");
    }

    public T withSequence(Integer sequence) {
        if (this.getSequence() == null) {
            this.setSequence(sequence);
            return (T)this;
        }
        throw new IllegalArgumentException("Property can only occur once in the calendar component");
    }

    public T withSequence(String sequence) {
        if (this.getSequence() == null) {
            this.setSequence(sequence);
            return (T)this;
        }
        throw new IllegalArgumentException("Property can only occur once in the calendar component");
    }

    public void incrementSequence() {
        if (this.getSequence() != null) {
            this.setSequence((Integer)this.getSequence().getValue() + 1);
        } else {
            this.setSequence(1);
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.orderChild(this.status, (VChild)status);
        this.status = status;
    }

    public void setStatus(String status) {
        this.setStatus(Status.parse(status));
    }

    public void setStatus(Status.StatusType status) {
        this.setStatus(new Status(status));
    }

    public T withStatus(Status status) {
        this.setStatus(status);
        return (T)this;
    }

    public T withStatus(Status.StatusType status) {
        this.setStatus(status);
        return (T)this;
    }

    public T withStatus(String status) {
        this.setStatus(status);
        return (T)this;
    }

    @Override
    public Summary getSummary() {
        return this.summary;
    }

    @Override
    public void setSummary(Summary summary) {
        this.orderChild(this.summary, (VChild)summary);
        this.summary = summary;
    }

    @Override
    void dateTimeStartListenerHook() {
        super.dateTimeStartListenerHook();
        String reccurenceIDErrorString = this.checkRecurrenceIdConsistency();
        if (reccurenceIDErrorString != null) {
            throw new RuntimeException(reccurenceIDErrorString);
        }
    }

    public VDisplayable() {
    }

    public VDisplayable(VDisplayable<T> source) {
        super(source);
    }

    @Override
    @Deprecated
    public Stream<Temporal> streamRecurrences(Temporal start) {
        Stream<Temporal> stream3;
        Stream<Temporal> stream2;
        Stream<Temporal> inStream = VRepeatable.super.streamRecurrences(start);
        Comparator<Temporal> temporalComparator = DateTimeUtilities.getTemporalComparator(start);
        List<VDisplayable<?>> children = this.recurrenceChildren();
        if (children != null) {
            List recurrenceIDTemporals = this.recurrenceChildren().stream().map(c -> (Temporal)c.getRecurrenceId().getValue()).collect(Collectors.toList());
            stream2 = inStream.filter(t -> !recurrenceIDTemporals.contains(t));
        } else {
            stream2 = inStream;
        }
        if (this.getExceptionDates() != null) {
            List exceptions = this.getExceptionDates().stream().flatMap(r -> ((Set)r.getValue()).stream()).map(v -> v).sorted(temporalComparator).collect(Collectors.toList());
            stream3 = stream2.filter(d -> !exceptions.contains(d));
        } else {
            stream3 = stream2;
        }
        if (this.getRecurrenceRule() == null) {
            return stream3;
        }
        if (((RecurrenceRuleValue)this.getRecurrenceRule().getValue()).getCount() == null) {
            return this.recurrenceCache().makeCache(stream3);
        }
        return stream3;
    }

    @Override
    public RecurrenceRuleCache recurrenceCache() {
        return this.recurrenceCache;
    }

    public List<VDisplayable<?>> recurrenceChildren() {
        if (this.getParent() != null && this.getRecurrenceId() == null) {
            UniqueIdentifier myUid = this.getUniqueIdentifier();
            return this.calendarList().stream().map(c -> (VDisplayable)c).filter(c -> c != this).filter(c -> c.getUniqueIdentifier().equals(myUid)).filter(c -> c.getRecurrenceId() != null).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public VDisplayable<?> recurrenceParent() {
        if (this.getParent() != null && this.getRecurrenceId() != null) {
            UniqueIdentifier myUid = this.getUniqueIdentifier();
            Optional<VDisplayable> recurrenceParent = this.calendarList().stream().map(c -> (VDisplayable)c).filter(c -> c != this).filter(c -> c.getUniqueIdentifier().equals(myUid)).filter(c -> c.getRecurrenceId() == null).findAny();
            return recurrenceParent.isPresent() ? recurrenceParent.get() : null;
        }
        return null;
    }

    public List<VDisplayable<?>> orphanedRecurrenceChildren() {
        VCalendar vCalendar;
        boolean isRecurrenceParent;
        boolean bl = isRecurrenceParent = this.getRecurrenceId() == null;
        if (isRecurrenceParent && (vCalendar = (VCalendar)this.getParent()) != null) {
            UniqueIdentifier uid = this.getUniqueIdentifier();
            return this.calendarList().stream().map(v -> (VDisplayable)v).filter(v -> v.getUniqueIdentifier().equals(uid)).filter(v -> v.getRecurrenceId() != null).filter(v -> {
                Temporal myRecurrenceID = (Temporal)v.getRecurrenceId().getValue();
                Temporal cacheStart = this.recurrenceCache().getClosestStart(myRecurrenceID);
                Temporal nextRecurrenceDateTime = ((RecurrenceRuleValue)this.getRecurrenceRule().getValue()).streamRecurrences(cacheStart).filter(t -> !DateTimeUtilities.isBefore(t, myRecurrenceID)).findFirst().orElseGet(() -> null);
                return !Objects.equals(nextRecurrenceDateTime, myRecurrenceID);
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> errors() {
        List<String> errors = super.errors();
        String reccurenceIDErrorString = this.checkRecurrenceIdConsistency();
        if (reccurenceIDErrorString != null) {
            errors.add(reccurenceIDErrorString);
        }
        errors.addAll(VRepeatableBase.errorsRepeatable(this));
        errors.addAll(VRepeatableBase.errorsRecurrence(this.getExceptionDates(), this.getDateTimeStart()));
        errors.addAll(VRepeatableBase.errorsRecurrence(this.getRecurrenceDates(), this.getDateTimeStart()));
        return errors;
    }

    public void eraseDateTimeProperties() {
        this.setDateTimeStart((DateTimeStart)null);
    }
}

