/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.VCalendar;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.components.VDisplayable;
import jfxtras.icalendarfx.properties.component.descriptive.Description;

public class VJournal
extends VDisplayable<VJournal> {
    private List<Description> descriptions;

    public List<Description> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<Description> descriptions) {
        if (this.descriptions != null) {
            this.descriptions.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.descriptions = descriptions;
        if (descriptions != null) {
            descriptions.forEach(c -> this.orderChild((VChild)c));
        }
    }

    public VJournal withDescriptions(List<Description> descriptions) {
        if (this.getDescriptions() == null) {
            this.setDescriptions(new ArrayList<Description>());
        }
        this.getDescriptions().addAll(descriptions);
        if (descriptions != null) {
            descriptions.forEach(c -> this.orderChild((VChild)c));
        }
        return this;
    }

    public VJournal withDescriptions(String ... descriptions) {
        List<Description> list = Arrays.stream(descriptions).map(c -> Description.parse(c)).collect(Collectors.toList());
        return this.withDescriptions(list);
    }

    public VJournal withDescriptions(Description ... descriptions) {
        return this.withDescriptions(Arrays.asList(descriptions));
    }

    public List<VJournal> calendarList() {
        if (this.getParent() != null) {
            VCalendar cal = (VCalendar)this.getParent();
            return cal.getVJournals();
        }
        return null;
    }

    public VJournal() {
    }

    public VJournal(VJournal source) {
        super(source);
    }

    @Override
    public List<String> errors() {
        return Collections.unmodifiableList(super.errors());
    }

    public static VJournal parse(String content) {
        return VJournal.parse(new VJournal(), content);
    }
}

