/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.components;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.components.VAlarm;
import jfxtras.icalendarfx.components.VComponent;
import jfxtras.icalendarfx.components.VDescribable2;
import jfxtras.icalendarfx.components.VDisplayable;
import jfxtras.icalendarfx.components.VDuration;
import jfxtras.icalendarfx.properties.component.descriptive.Description;
import jfxtras.icalendarfx.properties.component.descriptive.GeographicPosition;
import jfxtras.icalendarfx.properties.component.descriptive.Location;
import jfxtras.icalendarfx.properties.component.descriptive.Priority;
import jfxtras.icalendarfx.properties.component.descriptive.Resources;
import jfxtras.icalendarfx.properties.component.time.DurationProp;

public abstract class VLocatable<T>
extends VDisplayable<T>
implements VDescribable2<T>,
VDuration<T> {
    private Description description;
    private DurationProp duration;
    private GeographicPosition geographicPosition;
    private Location location;
    private Priority priority;
    private List<Resources> resources;
    private List<VAlarm> vAlarms;

    @Override
    public Description getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(Description description) {
        this.orderChild(this.description, (VChild)description);
        this.description = description;
    }

    @Override
    public DurationProp getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(DurationProp duration) {
        LocalDateTime now;
        LocalDateTime adjustedNow;
        if (duration != null && (adjustedNow = (now = LocalDateTime.now()).plus((TemporalAmount)duration.getValue())).isBefore(now)) {
            throw new DateTimeException("DURATION is negative (" + duration + "). DURATION MUST be positive.");
        }
        this.orderChild(this.duration, (VChild)duration);
        this.duration = duration;
    }

    public GeographicPosition getGeographicPosition() {
        return this.geographicPosition;
    }

    public void setGeographicPosition(GeographicPosition geographicPosition) {
        this.orderChild(this.geographicPosition, (VChild)geographicPosition);
        this.geographicPosition = geographicPosition;
    }

    public void setGeographicPosition(String geographicPosition) {
        this.setGeographicPosition(GeographicPosition.parse(geographicPosition));
    }

    public void setGeographicPosition(double latitude, double longitude) {
        this.getGeographicPosition().setLatitude(latitude);
        this.getGeographicPosition().setLongitude(longitude);
    }

    public T withGeographicPosition(GeographicPosition geographicPosition) {
        this.setGeographicPosition(geographicPosition);
        return (T)this;
    }

    public T withGeographicPosition(String geographicPosition) {
        this.setGeographicPosition(geographicPosition);
        return (T)this;
    }

    public T withGeographicPosition(double latitude, double longitude) {
        this.setGeographicPosition(latitude, longitude);
        return (T)this;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.orderChild(this.location, (VChild)location);
        this.location = location;
    }

    public void setLocation(String location) {
        this.setLocation(Location.parse(location));
    }

    public T withLocation(Location location) {
        this.setLocation(location);
        return (T)this;
    }

    public T withLocation(String location) {
        this.setLocation(location);
        return (T)this;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.orderChild(this.priority, (VChild)priority);
        this.priority = priority;
    }

    public void setPriority(String priority) {
        this.setPriority(Priority.parse(priority));
    }

    public void setPriority(int priority) {
        this.setPriority(new Priority(priority));
    }

    public T withPriority(Priority priority) {
        this.setPriority(priority);
        return (T)this;
    }

    public T withPriority(String priority) {
        this.setPriority(priority);
        return (T)this;
    }

    public T withPriority(int priority) {
        this.setPriority(priority);
        return (T)this;
    }

    public List<Resources> getResources() {
        return this.resources;
    }

    public void setResources(List<Resources> resources) {
        if (this.resources != null) {
            this.resources.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.resources = resources;
        if (resources != null) {
            resources.forEach(c -> this.orderChild((VChild)c));
        }
    }

    public T withResources(List<Resources> resources) {
        if (this.getResources() == null) {
            this.setResources(new ArrayList<Resources>());
        }
        this.getResources().addAll(resources);
        if (resources != null) {
            resources.forEach(c -> this.orderChild((VChild)c));
        }
        return (T)this;
    }

    public T withResources(String ... resources) {
        List<Resources> list = Arrays.stream(resources).map(c -> Resources.parse(c)).collect(Collectors.toList());
        return this.withResources(list);
    }

    public T withResources(Resources ... resources) {
        return this.withResources(Arrays.asList(resources));
    }

    public List<VAlarm> getVAlarms() {
        return this.vAlarms;
    }

    public void setVAlarms(List<VAlarm> vAlarms) {
        if (this.vAlarms != null) {
            this.vAlarms.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.vAlarms = vAlarms;
        if (vAlarms != null) {
            vAlarms.forEach(c -> this.orderChild((VChild)c));
        }
    }

    public T withVAlarms(List<VAlarm> vAlarms) {
        if (this.getVAlarms() == null) {
            this.setVAlarms(new ArrayList<VAlarm>());
        }
        if (vAlarms != null) {
            this.getVAlarms().addAll(vAlarms);
            vAlarms.forEach(c -> this.orderChild((VChild)c));
        }
        return (T)this;
    }

    public T withVAlarms(VAlarm ... vAlarms) {
        this.withVAlarms(Arrays.asList(vAlarms));
        return (T)this;
    }

    public T withVAlarms(String ... vAlarms) {
        List<VAlarm> newElements = Arrays.stream(vAlarms).map(c -> VAlarm.parse(c)).collect(Collectors.toList());
        return this.withVAlarms(newElements);
    }

    public VLocatable() {
    }

    public VLocatable(VLocatable<T> source) {
        super(source);
    }

    @Override
    void addSubcomponent(VComponent subcomponent) {
        List<VAlarm> list;
        if (subcomponent instanceof VAlarm) {
            if (this.getVAlarms() == null) {
                list = new ArrayList<VAlarm>();
                this.setVAlarms(list);
            } else {
                list = this.getVAlarms();
            }
        } else {
            throw new IllegalArgumentException("Unspoorted subcomponent type:" + subcomponent.getClass().getSimpleName() + " found inside " + this.name() + " component");
        }
        list.add((VAlarm)subcomponent);
    }

    @Override
    public List<String> errors() {
        LocalDateTime now;
        LocalDateTime adjustedNow;
        boolean isDurationPresent;
        List<String> errors = super.errors();
        if (this.getVAlarms() != null) {
            this.getVAlarms().forEach(v -> errors.addAll(v.errors()));
        }
        boolean bl = isDurationPresent = this.getDuration() != null;
        if (isDurationPresent && (adjustedNow = (now = LocalDateTime.now()).plus((TemporalAmount)this.getDuration().getValue())).isBefore(now)) {
            errors.add("DURATION is negative (" + this.getDuration().getValue() + "). DURATION MUST be positive.");
        }
        return errors;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        if (this.getVAlarms() != null) {
            for (VAlarm property : this.getVAlarms()) {
                hash = 31 * hash + ((Object)property).hashCode();
            }
        }
        return hash;
    }

    @Override
    public Stream<Temporal> streamRecurrences(Temporal start) {
        TemporalAmount adjustment = this.getActualDuration();
        return super.streamRecurrences(start.minus(adjustment));
    }

    @Override
    public void eraseDateTimeProperties() {
        super.eraseDateTimeProperties();
        this.setDuration((DurationProp)null);
    }

    public abstract TemporalAmount getActualDuration();

    public abstract void setEndOrDuration(Temporal var1, Temporal var2);
}

