/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.components;

import java.time.DateTimeException;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.components.VComponent;
import jfxtras.icalendarfx.properties.component.recurrence.PropertyBaseRecurrence;
import jfxtras.icalendarfx.properties.component.recurrence.RecurrenceDates;
import jfxtras.icalendarfx.properties.component.recurrence.RecurrenceRule;
import jfxtras.icalendarfx.properties.component.recurrence.RecurrenceRuleCache;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RecurrenceRuleValue;
import jfxtras.icalendarfx.properties.component.time.DateTimeStart;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;
import jfxtras.icalendarfx.utilities.ICalendarUtilities;

public interface VRepeatable<T>
extends VComponent {
    public List<RecurrenceDates> getRecurrenceDates();

    public void setRecurrenceDates(List<RecurrenceDates> var1);

    default public T withRecurrenceDates(List<RecurrenceDates> recurrenceDates) {
        if (this.getRecurrenceDates() == null) {
            this.setRecurrenceDates(new ArrayList<RecurrenceDates>());
        }
        this.getRecurrenceDates().addAll(recurrenceDates);
        if (recurrenceDates != null) {
            recurrenceDates.forEach(c -> this.orderChild((VChild)c));
        }
        return (T)this;
    }

    default public T withRecurrenceDates(String ... recurrenceDates) {
        List<RecurrenceDates> list = Arrays.stream(recurrenceDates).map(c -> RecurrenceDates.parse(c)).collect(Collectors.toList());
        return this.withRecurrenceDates(list);
    }

    default public T withRecurrenceDates(Temporal ... recurrenceDates) {
        return this.withRecurrenceDates(new RecurrenceDates(recurrenceDates));
    }

    default public T withRecurrenceDates(RecurrenceDates ... recurrenceDates) {
        return this.withRecurrenceDates(Arrays.asList(recurrenceDates));
    }

    default public String checkRecurrencesConsistency(List<? extends PropertyBaseRecurrence<?>> list) {
        if (list == null || list.isEmpty() || this.getDateTimeStart() == null) {
            return null;
        }
        Temporal firstRecurrence = (Temporal)this.getDateTimeStart().getValue();
        if (firstRecurrence == null) {
            return null;
        }
        DateTimeUtilities.DateTimeType dateTimeStartType = DateTimeUtilities.DateTimeType.of(firstRecurrence);
        Optional<DateTimeUtilities.DateTimeType> nonMatchingType = list.stream().flatMap(p -> ((Set)p.getValue()).stream()).map(t -> DateTimeUtilities.DateTimeType.of(t)).filter(y -> !y.equals((Object)dateTimeStartType)).findAny();
        if (nonMatchingType.isPresent()) {
            return list.get(0).name() + ": Recurrences DateTimeType " + (Object)((Object)nonMatchingType.get()) + " doesn't match DTSTART DateTimeType " + (Object)((Object)dateTimeStartType);
        }
        return null;
    }

    public static String checkPotentialRecurrencesConsistency(List<? extends PropertyBaseRecurrence<?>> list, PropertyBaseRecurrence<?> testObj) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Temporal firstRecurrence = (Temporal)((Set)list.get(0).getValue()).iterator().next();
        if (firstRecurrence == null) {
            return null;
        }
        DateTimeUtilities.DateTimeType firstDateTimeTypeType = DateTimeUtilities.DateTimeType.of(firstRecurrence);
        Optional<DateTimeUtilities.DateTimeType> nonMatchingType = ((Set)testObj.getValue()).stream().map(t -> DateTimeUtilities.DateTimeType.of(t)).filter(y -> !y.equals((Object)firstDateTimeTypeType)).findAny();
        if (nonMatchingType.isPresent()) {
            return list.get(0).name() + ": Added recurrences DateTimeType " + (Object)((Object)nonMatchingType.get()) + " doesn't match previous recurrences DateTimeType " + (Object)((Object)firstDateTimeTypeType);
        }
        return null;
    }

    default public void checkDateTimeStartConsistency() {
        DateTimeUtilities.DateTimeType dateTimeStartType;
        Temporal firstRecurrence;
        DateTimeUtilities.DateTimeType recurrenceType;
        if (this.getRecurrenceDates() != null && this.getDateTimeStart() != null && (recurrenceType = DateTimeUtilities.DateTimeType.of(firstRecurrence = (Temporal)((Set)this.getRecurrenceDates().get(0).getValue()).iterator().next())) != (dateTimeStartType = DateTimeUtilities.DateTimeType.of((Temporal)this.getDateTimeStart().getValue()))) {
            throw new DateTimeException("Recurrences DateTimeType (" + (Object)((Object)recurrenceType) + ") must be same as the DateTimeType of DateTimeStart (" + (Object)((Object)dateTimeStartType) + ")");
        }
    }

    public RecurrenceRule getRecurrenceRule();

    public void setRecurrenceRule(RecurrenceRule var1);

    default public void setRecurrenceRule(RecurrenceRuleValue rrule) {
        if (rrule == null) {
            this.setRecurrenceRule((RecurrenceRule)null);
        } else {
            this.setRecurrenceRule(new RecurrenceRule(rrule));
        }
    }

    default public void setRecurrenceRule(String rrule) {
        this.setRecurrenceRule(RecurrenceRule.parse(rrule));
    }

    default public T withRecurrenceRule(String rrule) {
        this.setRecurrenceRule(rrule);
        return (T)this;
    }

    default public T withRecurrenceRule(RecurrenceRule rrule) {
        this.setRecurrenceRule(rrule);
        return (T)this;
    }

    default public T withRecurrenceRule(RecurrenceRuleValue rrule) {
        this.setRecurrenceRule(rrule);
        return (T)this;
    }

    public DateTimeStart getDateTimeStart();

    public RecurrenceRuleCache recurrenceCache();

    default public Stream<Temporal> streamRecurrences(Temporal start, Temporal end) {
        return ICalendarUtilities.takeWhile(this.streamRecurrences(start), a -> DateTimeUtilities.isBefore(a, end));
    }

    default public Stream<Temporal> streamRecurrences(Temporal start) {
        Stream<Object> stream1;
        DateTimeUtilities.DateTimeType dateTimeStartType;
        DateTimeUtilities.DateTimeType startType = DateTimeUtilities.DateTimeType.of(start);
        if (startType != (dateTimeStartType = DateTimeUtilities.DateTimeType.of((Temporal)this.getDateTimeStart().getValue()))) {
            throw new DateTimeException("Start type " + (Object)((Object)startType) + " must match DTSTART type of " + (Object)((Object)dateTimeStartType));
        }
        if (this.getRecurrenceRule() == null) {
            stream1 = Arrays.asList((Temporal)this.getDateTimeStart().getValue()).stream();
        } else if (((RecurrenceRuleValue)this.getRecurrenceRule().getValue()).getCount() == null) {
            Temporal cacheStart = this.recurrenceCache().getClosestStart(start);
            stream1 = ((RecurrenceRuleValue)this.getRecurrenceRule().getValue()).streamRecurrences(cacheStart);
        } else {
            stream1 = ((RecurrenceRuleValue)this.getRecurrenceRule().getValue()).streamRecurrences((Temporal)this.getDateTimeStart().getValue());
        }
        Comparator<Temporal> temporalComparator = DateTimeUtilities.getTemporalComparator(start);
        Stream<Object> stream2 = this.getRecurrenceDates() == null ? stream1 : VRepeatable.merge(stream1, this.getRecurrenceDates().stream().flatMap(r -> ((Set)r.getValue()).stream()).map(v -> v).filter(t -> !DateTimeUtilities.isBefore(t, start)).sorted(temporalComparator), temporalComparator);
        return stream2.filter(t -> !DateTimeUtilities.isBefore(t, start));
    }

    default public Stream<Temporal> streamRecurrences() {
        return this.streamRecurrences((Temporal)this.getDateTimeStart().getValue());
    }

    default public Temporal previousStreamValue(Temporal value) {
        Temporal t;
        Temporal cacheStart = this.recurrenceCache().getClosestStart(value);
        Iterator i = this.streamRecurrences(cacheStart).iterator();
        Temporal lastT = null;
        while (i.hasNext() && DateTimeUtilities.isBefore(t = (Temporal)i.next(), value)) {
            lastT = t;
        }
        return lastT;
    }

    default public boolean isRecurrence(Temporal temporal) {
        if (temporal == null) {
            throw new DateTimeException("Temporal parameter must not be null.");
        }
        Iterator startInstanceIterator = this.streamRecurrences(temporal).iterator();
        while (startInstanceIterator.hasNext()) {
            Temporal myStartInstance = (Temporal)startInstanceIterator.next();
            if (myStartInstance.equals(temporal)) {
                return true;
            }
            if (!DateTimeUtilities.isAfter(myStartInstance, temporal)) continue;
            return false;
        }
        return false;
    }

    default public boolean isRecurrenceSetEmpty() {
        Iterator i = this.streamRecurrences().iterator();
        return !i.hasNext();
    }

    default public Temporal lastRecurrence() {
        if (this.getRecurrenceRule() != null && ((RecurrenceRuleValue)this.getRecurrenceRule().getValue()).isInfinite()) {
            return null;
        }
        Iterator i = this.streamRecurrences().iterator();
        Temporal myTemporal = null;
        while (i.hasNext()) {
            myTemporal = (Temporal)i.next();
        }
        return myTemporal;
    }

    @Deprecated
    public static <T> Stream<T> merge(Stream<T> stream1, Stream<T> stream2, Comparator<T> comparator) {
        MergedIterator iterator = new MergedIterator(stream1.iterator(), stream2.iterator(), comparator);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    public static class MergedIterator<T>
    implements Iterator<T> {
        private final Iterator<T> iterator1;
        private final Iterator<T> iterator2;
        private final Comparator<T> comparator;
        private T next1;
        private T next2;

        public MergedIterator(Iterator<T> iterator1, Iterator<T> iterator2, Comparator<T> comparator) {
            this.iterator1 = iterator1;
            this.iterator2 = iterator2;
            this.comparator = comparator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator1.hasNext() || this.iterator2.hasNext() || this.next1 != null || this.next2 != null;
        }

        @Override
        public T next() {
            T theNext;
            int result;
            if (this.iterator1.hasNext() && this.next1 == null) {
                this.next1 = this.iterator1.next();
            }
            if (this.iterator2.hasNext() && this.next2 == null) {
                this.next2 = this.iterator2.next();
            }
            int n = this.next1 == null ? 1 : (result = this.next2 == null ? -1 : this.comparator.compare(this.next1, this.next2));
            if (result > 0) {
                theNext = this.next2;
                this.next2 = null;
            } else if (result < 0) {
                theNext = this.next1;
                this.next1 = null;
            } else {
                theNext = this.next1;
                this.next1 = null;
                this.next2 = null;
            }
            return theNext;
        }
    }
}

