/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.components;

import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Collections;
import java.util.List;
import jfxtras.icalendarfx.VCalendar;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.components.VDescribable2;
import jfxtras.icalendarfx.components.VLocatable;
import jfxtras.icalendarfx.properties.component.descriptive.PercentComplete;
import jfxtras.icalendarfx.properties.component.time.DateTimeCompleted;
import jfxtras.icalendarfx.properties.component.time.DateTimeDue;
import jfxtras.icalendarfx.properties.component.time.DurationProp;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;

public class VTodo
extends VLocatable<VTodo>
implements VDescribable2<VTodo> {
    private DateTimeCompleted dateTimeCompleted;
    private DateTimeDue dateTimeDue;
    private PercentComplete percentComplete;

    public DateTimeCompleted getDateTimeCompleted() {
        return this.dateTimeCompleted;
    }

    public void setDateTimeCompleted(String dateTimeCompleted) {
        this.setDateTimeCompleted(DateTimeCompleted.parse(dateTimeCompleted));
    }

    public void setDateTimeCompleted(DateTimeCompleted dateTimeCompleted) {
        this.orderChild(this.dateTimeCompleted, (VChild)dateTimeCompleted);
        this.dateTimeCompleted = dateTimeCompleted;
    }

    public void setDateTimeCompleted(ZonedDateTime dateTimeCompleted) {
        this.setDateTimeCompleted(new DateTimeCompleted(dateTimeCompleted));
    }

    public VTodo withDateTimeCompleted(ZonedDateTime dateTimeCompleted) {
        this.setDateTimeCompleted(dateTimeCompleted);
        return this;
    }

    public VTodo withDateTimeCompleted(String dateTimeCompleted) {
        this.setDateTimeCompleted(dateTimeCompleted);
        return this;
    }

    public VTodo withDateTimeCompleted(DateTimeCompleted dateTimeCompleted) {
        this.setDateTimeCompleted(dateTimeCompleted);
        return this;
    }

    public DateTimeDue getDateTimeDue() {
        return this.dateTimeDue;
    }

    public void setDateTimeDue(String dateTimeDue) {
        this.setDateTimeDue(DateTimeDue.parse(dateTimeDue));
    }

    public void setDateTimeDue(DateTimeDue dateTimeDue) {
        this.orderChild(this.dateTimeDue, (VChild)dateTimeDue);
        this.dateTimeDue = dateTimeDue;
    }

    public void setDateTimeDue(Temporal dateTimeDue) {
        if (!(dateTimeDue instanceof LocalDate || dateTimeDue instanceof LocalDateTime || dateTimeDue instanceof ZonedDateTime)) {
            throw new DateTimeException("Only LocalDate, LocalDateTime and ZonedDateTime supported. " + dateTimeDue.getClass().getSimpleName() + " is not supported");
        }
        this.setDateTimeDue(new DateTimeDue(dateTimeDue));
    }

    public VTodo withDateTimeDue(Temporal dateTimeDue) {
        this.setDateTimeDue(dateTimeDue);
        return this;
    }

    public VTodo withDateTimeDue(String dateTimeDue) {
        this.setDateTimeDue(dateTimeDue);
        return this;
    }

    public VTodo withDateTimeDue(DateTimeDue dateTimeDue) {
        this.setDateTimeDue(dateTimeDue);
        return this;
    }

    @Override
    public void setDuration(DurationProp duration) {
        if (this.getDateTimeDue() != null && this.getDuration() != null) {
            throw new DateTimeException("DURATION and DUE can't both be set");
        }
        super.setDuration(duration);
    }

    public PercentComplete getPercentComplete() {
        return this.percentComplete;
    }

    public void setPercentComplete(String percentComplete) {
        this.setPercentComplete(PercentComplete.parse(percentComplete));
    }

    public void setPercentComplete(Integer percentComplete) {
        this.setPercentComplete(new PercentComplete(percentComplete));
    }

    public void setPercentComplete(PercentComplete percentComplete) {
        this.orderChild(this.percentComplete, (VChild)percentComplete);
        this.percentComplete = percentComplete;
    }

    public VTodo withPercentComplete(PercentComplete percentComplete) {
        this.setPercentComplete(percentComplete);
        return this;
    }

    public VTodo withPercentComplete(Integer percentComplete) {
        this.setPercentComplete(percentComplete);
        return this;
    }

    public VTodo withPercentComplete(String percentComplete) {
        this.setPercentComplete(PercentComplete.parse(percentComplete));
        return this;
    }

    public List<VTodo> calendarList() {
        if (this.getParent() != null) {
            VCalendar cal = (VCalendar)this.getParent();
            return cal.getVTodos();
        }
        return null;
    }

    public VTodo() {
    }

    public VTodo(VTodo source) {
        super(source);
    }

    @Override
    public TemporalAmount getActualDuration() {
        TemporalAmount duration;
        if (this.getDuration() != null) {
            duration = (TemporalAmount)this.getDuration().getValue();
        } else if (this.getDateTimeDue() != null) {
            Temporal dtstart = (Temporal)this.getDateTimeStart().getValue();
            Temporal dtdue = (Temporal)this.getDateTimeDue().getValue();
            duration = DateTimeUtilities.temporalAmountBetween(dtstart, dtdue);
        } else {
            return Duration.ZERO;
        }
        return duration;
    }

    @Override
    public void setEndOrDuration(Temporal startRecurrence, Temporal endRecurrence) {
        TemporalAmount duration = DateTimeUtilities.temporalAmountBetween(startRecurrence, endRecurrence);
        if (this.getDuration() != null) {
            this.setDuration(duration);
        } else if (this.getDateTimeDue() != null) {
            Temporal due = ((Temporal)this.getDateTimeStart().getValue()).plus(duration);
            this.setDateTimeDue(due);
        } else {
            throw new RuntimeException("Either DTEND or DURATION must be set");
        }
    }

    @Override
    public List<String> errors() {
        boolean isDurationPresent;
        List<String> errors = super.errors();
        if (this.getDateTimeStart() == null) {
            errors.add("DTSTART is REQUIRED and MUST NOT occur more than once");
        }
        boolean isDateTimeDuePresent = this.getDateTimeDue() != null;
        boolean bl = isDurationPresent = this.getDuration() != null;
        if (this.getDateTimeDue() != null && this.getDateTimeStart() != null) {
            DateTimeUtilities.DateTimeType dueType;
            boolean isDateTimeDueMatch;
            DateTimeUtilities.DateTimeType startType = DateTimeUtilities.DateTimeType.of((Temporal)this.getDateTimeStart().getValue());
            boolean bl2 = isDateTimeDueMatch = startType == (dueType = DateTimeUtilities.DateTimeType.of((Temporal)this.getDateTimeDue().getValue()));
            if (!isDateTimeDueMatch) {
                errors.add("The value type of DUE MUST be the same as the DTSTART property (" + (Object)((Object)dueType) + ", " + (Object)((Object)startType));
            }
        }
        if (isDateTimeDuePresent || isDurationPresent) {
            if (isDateTimeDuePresent && isDurationPresent) {
                errors.add("Both DUE and DURATION are present.  DUE or DURATION MAY appear, but both MUST NOT occur in the same " + this.name());
            } else if (isDateTimeDuePresent && !DateTimeUtilities.isAfter((Temporal)this.getDateTimeDue().getValue(), (Temporal)this.getDateTimeStart().getValue())) {
                errors.add("DUE is not after DTSTART.  DUE MUST be after DTSTART");
            }
        }
        return Collections.unmodifiableList(errors);
    }

    @Override
    public void eraseDateTimeProperties() {
        super.eraseDateTimeProperties();
        this.setDateTimeDue((DateTimeDue)null);
    }

    public static VTodo parse(String content) {
        return VTodo.parse(new VTodo(), content);
    }
}

