/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.parameters;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jfxtras.icalendarfx.parameters.ParameterEnumBasedWithUnknown;
import jfxtras.icalendarfx.utilities.StringConverter;

public class ParticipationRole
extends ParameterEnumBasedWithUnknown<ParticipationRole, ParticipationRoleType> {
    private static final StringConverter<ParticipationRoleType> CONVERTER = new StringConverter<ParticipationRoleType>(){

        @Override
        public String toString(ParticipationRoleType object) {
            return object.toString();
        }

        @Override
        public ParticipationRoleType fromString(String string) {
            return ParticipationRoleType.enumFromName(string.toUpperCase());
        }
    };

    public ParticipationRole() {
        super(ParticipationRoleType.REQUIRED_PARTICIPANT, CONVERTER);
    }

    public ParticipationRole(ParticipationRoleType value) {
        super(value, CONVERTER);
    }

    public ParticipationRole(ParticipationRole source) {
        super(source, CONVERTER);
    }

    public static ParticipationRole parse(String content) {
        return ParticipationRole.parse(new ParticipationRole(), content);
    }

    public static enum ParticipationRoleType {
        CHAIR(Arrays.asList("CHAIR")),
        REQUIRED_PARTICIPANT(Arrays.asList("REQ-PARTICIPANT", "REQ_PARTICIPANT")),
        OPTIONAL_PARTICIPANT(Arrays.asList("OPT-PARTICIPANT", "OPT_PARTICIPANT")),
        NON_PARTICIPANT(Arrays.asList("NON-PARTICIPANT", "NON_PARTICIPANT")),
        UNKNOWN(Arrays.asList("UNKNOWN"));

        private static Map<String, ParticipationRoleType> enumFromNameMap;
        private List<String> names;

        private static Map<String, ParticipationRoleType> makeEnumFromNameMap() {
            HashMap<String, ParticipationRoleType> map = new HashMap<String, ParticipationRoleType>();
            Arrays.stream(ParticipationRoleType.values()).forEach(r -> r.names.stream().forEach(n -> map.put((String)n, (ParticipationRoleType)((Object)r))));
            return map;
        }

        public static ParticipationRoleType enumFromName(String propertyName) {
            ParticipationRoleType type = enumFromNameMap.get(propertyName.toUpperCase());
            return type == null ? UNKNOWN : type;
        }

        public String toString() {
            return this.names.get(0);
        }

        private ParticipationRoleType(List<String> names) {
            this.names = names;
        }

        static {
            enumFromNameMap = ParticipationRoleType.makeEnumFromNameMap();
        }
    }
}

