/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.List;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.parameters.TimeZoneIdentifierParameter;
import jfxtras.icalendarfx.parameters.VParameterElement;
import jfxtras.icalendarfx.parameters.ValueParameter;
import jfxtras.icalendarfx.properties.PropDateTime;
import jfxtras.icalendarfx.properties.VPropertyBase;
import jfxtras.icalendarfx.properties.ValueType;

public abstract class PropBaseDateTime<T, U>
extends VPropertyBase<T, U>
implements PropDateTime<T> {
    private Object myElement;
    private TimeZoneIdentifierParameter timeZoneIdentifier;

    @Override
    public TimeZoneIdentifierParameter getTimeZoneIdentifier() {
        return this.timeZoneIdentifier;
    }

    @Override
    public void setTimeZoneIdentifier(TimeZoneIdentifierParameter timeZoneIdentifier) {
        if (this.myElement != null && !(this.myElement instanceof ZonedDateTime)) {
            throw new DateTimeException(VParameterElement.TIME_ZONE_IDENTIFIER.name() + " can't be set for date-time of type " + this.getValue().getClass().getSimpleName());
        }
        this.orderChild(this.timeZoneIdentifier, (VChild)timeZoneIdentifier);
        this.timeZoneIdentifier = timeZoneIdentifier;
    }

    public void setTimeZoneIdentifier(String value) {
        this.setTimeZoneIdentifier(TimeZoneIdentifierParameter.parse(value));
    }

    public void setTimeZoneIdentifier(ZoneId zone) {
        this.setTimeZoneIdentifier(new TimeZoneIdentifierParameter(zone));
    }

    public U withTimeZoneIdentifier(TimeZoneIdentifierParameter timeZoneIdentifier) {
        this.setTimeZoneIdentifier(timeZoneIdentifier);
        return (U)this;
    }

    public U withTimeZoneIdentifier(ZoneId zone) {
        this.setTimeZoneIdentifier(zone);
        return (U)this;
    }

    public U withTimeZoneIdentifier(String content) {
        this.setTimeZoneIdentifier(content);
        return (U)this;
    }

    protected PropBaseDateTime() {
    }

    public PropBaseDateTime(T temporal) {
        super(temporal);
    }

    public PropBaseDateTime(PropBaseDateTime<T, U> source) {
        super(source);
    }

    @Override
    protected String modifiedValue() {
        String timeZone = this.getTimeZoneIdentifier() != null ? "[" + ((ZoneId)this.getTimeZoneIdentifier().getValue()).toString() + "]" : "";
        String modifiedValue = super.modifiedValue();
        return modifiedValue != null ? timeZone + modifiedValue : null;
    }

    @Override
    public void setValue(T value) {
        super.setValue(value);
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            this.myElement = collection.isEmpty() ? null : collection.iterator().next();
        } else if (value instanceof Temporal) {
            this.myElement = value;
        } else {
            throw new DateTimeException("Unsupported type:" + value.getClass().getSimpleName());
        }
        if (this.myElement != null) {
            if (this.myElement instanceof ZonedDateTime) {
                ZoneId zone = ((ZonedDateTime)this.myElement).getZone();
                if (!zone.equals(ZoneId.of("Z"))) {
                    if (this.getValueType() != null && this.getValueType().getValue() == ValueType.DATE) {
                        this.setValueType((ValueParameter)null);
                    }
                    if (this.getTimeZoneIdentifier() == null) {
                        this.setTimeZoneIdentifier(new TimeZoneIdentifierParameter(zone));
                    }
                }
            } else if (this.myElement instanceof LocalDateTime || this.myElement instanceof LocalDate) {
                if (this.getTimeZoneIdentifier() != null) {
                    throw new DateTimeException("Only ZonedDateTime is permitted when specifying a Time Zone Identifier (" + this.myElement.getClass().getSimpleName() + ")");
                }
                if (this.getValueType() == null) {
                    if (this.myElement instanceof LocalDate) {
                        this.setValueType(ValueType.DATE);
                    } else if (this.getValueType() != null && this.getValueType().getValue() == ValueType.DATE) {
                        this.setValueType((ValueParameter)null);
                    }
                }
            } else {
                throw new DateTimeException("Unsupported Temporal type:" + value.getClass().getSimpleName());
            }
        }
    }

    @Override
    public List<String> errors() {
        List<String> errors = super.errors();
        if (this.getValue() != null && this.getValueType() != null) {
            if (this.getValue() instanceof LocalDate) {
                if (this.getValueType().getValue() != ValueType.DATE) {
                    errors.add(this.name() + "'s value (" + this.getValue() + ") doesn't match its value type (" + this.getValueType().getValue() + ").  For that value, the required value type is " + (Object)((Object)ValueType.DATE));
                }
            } else if ((this.getValue() instanceof LocalDateTime || this.getValue() instanceof ZonedDateTime) && this.getValueType().getValue() != ValueType.DATE_TIME) {
                errors.add(this.name() + "'s value (" + this.getValue() + ") doesn't match its value type (" + this.getValueType().getValue() + ").  For that value, the required value type is " + (Object)((Object)ValueType.DATE_TIME));
            }
        }
        return errors;
    }
}

