/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.alarm;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.List;
import jfxtras.icalendarfx.VElementBase;
import jfxtras.icalendarfx.parameters.AlarmTriggerRelationship;
import jfxtras.icalendarfx.parameters.ValueParameter;
import jfxtras.icalendarfx.properties.PropAlarmTrigger;
import jfxtras.icalendarfx.properties.VPropertyBase;
import jfxtras.icalendarfx.properties.ValueType;

public class Trigger<T>
extends VPropertyBase<T, Trigger<T>>
implements PropAlarmTrigger<T> {
    private AlarmTriggerRelationship relationship;

    @Override
    public AlarmTriggerRelationship getAlarmTrigger() {
        return this.relationship;
    }

    @Override
    public void setAlarmTrigger(AlarmTriggerRelationship relationship) {
        if (relationship != null) {
            ValueType valueType;
            ValueType valueType2 = valueType = this.getValueType() == null ? this.defaultValueType : (ValueType)((Object)this.getValueType().getValue());
            if (valueType == ValueType.DURATION) {
                this.orderChild(relationship);
                this.relationship = relationship;
            } else {
                throw new IllegalArgumentException("Alarm Trigger Relationship can only be set if value type is DURATION");
            }
        }
    }

    public Trigger<T> withAlarmTrigger(AlarmTriggerRelationship format) {
        this.setAlarmTrigger(format);
        return this;
    }

    public Trigger(Trigger<T> source) {
        super(source);
    }

    public Trigger(T value) {
        super(value);
    }

    public Trigger() {
    }

    @Override
    public void setValue(T value) {
        if (value instanceof ZonedDateTime) {
            ZoneId zone = ((ZonedDateTime)value).getZone();
            if (!zone.equals(ZoneId.of("Z"))) {
                throw new DateTimeException("Unsupported ZoneId:" + zone + " only Z supported");
            }
            this.setValueType(ValueType.DATE_TIME);
        }
        super.setValue(value);
    }

    @Override
    public void setValueType(ValueParameter valueType) {
        if (valueType.getValue() == ValueType.DATE_TIME && this.getAlarmTrigger() != null) {
            throw new IllegalArgumentException("Value type can only be set to DATE-TIME if Alarm Trigger Relationship is null");
        }
        super.setValueType(valueType);
    }

    @Override
    protected void setConverterByClass(Class<T> clazz) {
        if (TemporalAmount.class.isAssignableFrom(clazz)) {
            this.setConverter(ValueType.DURATION.getConverter());
        } else if (clazz.equals(ZonedDateTime.class)) {
            this.setConverter(ValueType.DATE_TIME.getConverter());
        } else {
            throw new IllegalArgumentException("Only parameterized types of Duration, Period and ZonedDateTime are supported.");
        }
    }

    @Override
    public boolean isValid() {
        boolean isDateTimeValue;
        boolean bl = this.getValueType() == null ? false : (isDateTimeValue = this.getValueType().getValue() != ValueType.DATE_TIME);
        if (isDateTimeValue && this.getAlarmTrigger() != null) {
            return false;
        }
        return super.isValid();
    }

    public static <U> Trigger<U> parse(String content) {
        return Trigger.parse(new Trigger(), content);
    }

    public static <U> Trigger<U> parse(Class<U> clazz, String value) {
        Trigger<U> property = new Trigger<U>();
        property.setConverterByClass(clazz);
        List<VElementBase.Message> m = property.parseContent(value);
        if (!m.isEmpty()) {
            throw new DateTimeException("Invalid value:" + value);
        }
        return property;
    }
}

