/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.descriptive;

import java.text.DecimalFormat;
import jfxtras.icalendarfx.properties.VPropertyBase;

public class GeographicPosition
extends VPropertyBase<String, GeographicPosition> {
    private Double latitude;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.######");
    private Double longitude;

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
        this.buildNewValue();
    }

    public GeographicPosition withLatitude(Double latitude) {
        this.setLatitude(latitude);
        return this;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
        this.buildNewValue();
    }

    public GeographicPosition withLongitude(Double longitude) {
        this.setLongitude(longitude);
        return this;
    }

    public GeographicPosition(GeographicPosition source) {
        super(source);
        this.updateParts((String)this.getValue());
    }

    public GeographicPosition(double latitude, double longitude) {
        this.setLatitude(latitude);
        this.setLongitude(longitude);
    }

    public GeographicPosition() {
    }

    @Override
    protected String valueContent() {
        StringBuilder builder = new StringBuilder(20);
        builder.append(DECIMAL_FORMAT.format(this.getLatitude()) + ";");
        builder.append(DECIMAL_FORMAT.format(this.getLongitude()));
        return builder.toString();
    }

    public static GeographicPosition parse(String content) {
        return GeographicPosition.parse(new GeographicPosition(), content);
    }

    private void updateParts(String newValue) {
        String[] values = newValue.split(";");
        if (values.length != 2) {
            throw new IllegalArgumentException("Can't parse geographic position value:" + newValue);
        }
        this.setLatitude(Double.parseDouble(values[0]));
        this.setLongitude(Double.parseDouble(values[1]));
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
        this.updateParts(value);
    }

    private void buildNewValue() {
        if (this.getLatitude() != null && this.getLongitude() != null) {
            StringBuilder builder = new StringBuilder(20);
            builder.append(DECIMAL_FORMAT.format(this.getLatitude()) + ";");
            builder.append(DECIMAL_FORMAT.format(this.getLongitude()));
            super.setValue(builder.toString());
        }
    }
}

