/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.recurrence;

import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import jfxtras.icalendarfx.components.VRepeatable;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RecurrenceRuleValue;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;

public class RecurrenceRuleCache {
    private static final int CACHE_RANGE = 51;
    private static final int CACHE_SKIP = 21;
    private int skipCounter = 0;
    public Temporal[] temporalCache;
    private Temporal dateTimeStartLast;
    private RecurrenceRuleValue rRuleLast;
    public int cacheStart = 0;
    public int cacheEnd = 0;
    private VRepeatable<?> component;

    public RecurrenceRuleCache(VRepeatable<?> component) {
        this.component = component;
    }

    public Temporal previousValue(Temporal value) {
        Temporal t;
        Temporal start;
        if (this.cacheEnd == 0) {
            start = (Temporal)this.component.getDateTimeStart().getValue();
        } else {
            Temporal m = null;
            for (int i = this.cacheEnd; i > this.cacheStart; --i) {
                if (!DateTimeUtilities.isBefore(this.temporalCache[i], value)) continue;
                m = this.temporalCache[i];
                break;
            }
            start = m != null ? m : (Temporal)this.component.getDateTimeStart().getValue();
        }
        Iterator i = this.component.streamRecurrences(start).iterator();
        Temporal lastT = null;
        while (i.hasNext() && DateTimeUtilities.isBefore(t = (Temporal)i.next(), value)) {
            lastT = t;
        }
        return lastT;
    }

    public Temporal getClosestStart(Temporal targetStart) {
        Temporal match;
        Temporal start2;
        Temporal dateTimeStart = (Temporal)this.component.getDateTimeStart().getValue();
        RecurrenceRuleValue recurrenceRule = this.component.getRecurrenceRule() != null ? (RecurrenceRuleValue)this.component.getRecurrenceRule().getValue() : null;
        Temporal temporal = start2 = DateTimeUtilities.isBefore(targetStart, dateTimeStart) ? dateTimeStart : targetStart;
        if (recurrenceRule == null) {
            return null;
        }
        if (this.dateTimeStartLast != null && this.rRuleLast != null) {
            boolean rRuleChanged;
            boolean startChanged = !dateTimeStart.equals(this.dateTimeStartLast);
            boolean bl = rRuleChanged = !recurrenceRule.equals(this.rRuleLast);
            if (startChanged || rRuleChanged) {
                this.temporalCache = null;
                this.cacheStart = 0;
                this.cacheEnd = 0;
                this.skipCounter = 0;
                this.dateTimeStartLast = dateTimeStart;
                this.rRuleLast = recurrenceRule;
            }
        } else {
            this.dateTimeStartLast = dateTimeStart;
            this.rRuleLast = recurrenceRule;
        }
        if (this.temporalCache != null) {
            Temporal[] p2;
            Temporal[] p1;
            int len = this.temporalCache.length;
            if (this.cacheEnd < this.cacheStart) {
                p1 = Arrays.copyOfRange(this.temporalCache, this.cacheStart, len);
                p2 = Arrays.copyOfRange(this.temporalCache, 0, Math.min(this.cacheEnd + 1, len));
            } else if (this.cacheEnd > this.cacheStart) {
                p2 = Arrays.copyOfRange(this.temporalCache, this.cacheStart, len);
                p1 = Arrays.copyOfRange(this.temporalCache, 0, Math.min(this.cacheEnd + 1, len));
            } else {
                p1 = null;
                p2 = null;
            }
            if (p1 != null) {
                int p1Index = 0;
                int p2Index = 0;
                for (int i = 0; i < len; ++i) {
                    if (p1Index < p1.length) {
                        this.temporalCache[i] = p1[p1Index];
                        ++p1Index;
                        continue;
                    }
                    if (p2Index < p2.length) {
                        this.temporalCache[i] = p2[p2Index];
                        ++p2Index;
                        continue;
                    }
                    this.cacheEnd = i;
                    break;
                }
            }
            Temporal latestCacheValue = this.temporalCache[this.cacheEnd];
            if (!DateTimeUtilities.isBefore(start2, this.temporalCache[this.cacheStart])) {
                Temporal m = latestCacheValue;
                for (int i = this.cacheStart; i < this.cacheEnd + 1; ++i) {
                    if (!DateTimeUtilities.isAfter(this.temporalCache[i], start2)) continue;
                    m = this.temporalCache[i - 1];
                    break;
                }
                match = m;
            } else {
                this.cacheStart = 0;
                this.cacheEnd = 0;
                this.temporalCache[this.cacheStart] = dateTimeStart;
                match = dateTimeStart;
            }
        } else {
            this.temporalCache = new Temporal[51];
            this.temporalCache[this.cacheStart] = dateTimeStart;
            match = dateTimeStart;
        }
        return match;
    }

    public Stream<Temporal> makeCache(Stream<Temporal> inStream) {
        Temporal earliestCacheValue = this.temporalCache[this.cacheStart];
        Temporal latestCacheValue = this.temporalCache[this.cacheEnd];
        Stream<Temporal> outStream = inStream.peek(t -> {
            if (this.component.getRecurrenceRule() != null) {
                if (DateTimeUtilities.isBefore(t, earliestCacheValue)) {
                    if (this.skipCounter == 21) {
                        --this.cacheStart;
                        if (this.cacheStart < 0) {
                            this.cacheStart = 50;
                        }
                        if (this.cacheStart == this.cacheEnd) {
                            --this.cacheEnd;
                        }
                        this.temporalCache[this.cacheStart] = t;
                        this.skipCounter = 0;
                    } else {
                        ++this.skipCounter;
                    }
                }
                if (DateTimeUtilities.isAfter(t, latestCacheValue)) {
                    if (this.skipCounter == 21) {
                        ++this.cacheEnd;
                        if (this.cacheEnd == 51) {
                            this.cacheEnd = 0;
                        }
                        if (this.cacheStart == this.cacheEnd) {
                            ++this.cacheStart;
                        }
                        this.temporalCache[this.cacheEnd] = t;
                        this.skipCounter = 0;
                    } else {
                        ++this.skipCounter;
                    }
                }
                if (this.cacheEnd < 0) {
                    this.cacheEnd = 50;
                }
                if (this.cacheStart == 51) {
                    this.cacheStart = 0;
                }
            }
        });
        return outStream;
    }
}

