/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.recurrence.rrule;

import java.util.Collections;
import java.util.List;
import jfxtras.icalendarfx.VElementBase;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RRulePartBase;

public class Interval
extends RRulePartBase<Integer, Interval> {
    public static final int DEFAULT_INTERVAL = 1;

    public Interval() {
        this.setValue(1);
    }

    public Interval(Integer interval) {
        this();
        this.setValue(interval);
    }

    public Interval(Interval source) {
        this();
        this.setValue(source.getValue());
    }

    @Override
    protected List<VElementBase.Message> parseContent(String content) {
        String valueString = Interval.extractValue(content);
        this.setValue(Integer.parseInt(valueString));
        return Collections.EMPTY_LIST;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getValue() == null ? 0 : ((Integer)this.getValue()).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        return this.getValue() == null ? other.getValue() == null : ((Integer)this.getValue()).equals(other.getValue());
    }

    @Override
    public List<String> errors() {
        List<String> errors = super.errors();
        if (this.getValue() != null && (Integer)this.getValue() < 1) {
            errors.add("INTERVAL is " + this.getValue() + ".  The value MUST be greater than or equal to 1.");
        }
        return errors;
    }

    public static Interval parse(String content) {
        return Interval.parse(new Interval(), content);
    }
}

