/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.recurrence.rrule;

import java.time.DayOfWeek;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jfxtras.icalendarfx.VElementBase;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RRuleElement;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RRulePartBase;

public class WeekStart
extends RRulePartBase<DayOfWeek, WeekStart> {
    public static final DayOfWeek DEFAULT_WEEK_START = DayOfWeek.MONDAY;

    @Override
    void setValue(String weekStart) {
        this.parseContent(weekStart);
    }

    @Override
    public WeekStart withValue(String weekStart) {
        this.setValue(weekStart);
        return this;
    }

    public WeekStart(DayOfWeek dayOfWeek) {
        this();
        this.setValue(dayOfWeek);
    }

    public WeekStart() {
        this.setValue(DEFAULT_WEEK_START);
    }

    public WeekStart(WeekStart source) {
        this();
        this.setValue(source.getValue());
    }

    @Override
    public String toString() {
        return RRuleElement.fromClass(this.getClass()).toString() + "=" + ((DayOfWeek)this.getValue()).toString().substring(0, 2);
    }

    @Override
    protected List<VElementBase.Message> parseContent(String content) {
        String valueString = WeekStart.extractValue(content);
        DayOfWeek dayOfWeek = Arrays.stream(DayOfWeek.values()).filter(d -> d.toString().substring(0, 2).equals(valueString)).findAny().get();
        this.setValue(dayOfWeek);
        return Collections.EMPTY_LIST;
    }

    public static WeekStart parse(String content) {
        return WeekStart.parse(new WeekStart(), content);
    }
}

