/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx;

import java.time.Month;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jfxtras.icalendarfx.VElementBase;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RRuleElement;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx.ByRuleAbstract;

public class ByMonth
extends ByRuleAbstract<Month, ByMonth> {
    @Override
    public void setValue(int ... months) {
        Month[] monthArray = (Month[])Arrays.stream(months).mapToObj(i -> Month.of(i)).toArray(Month[]::new);
        this.setValue((T[])monthArray);
    }

    @Override
    public ByMonth withValue(int ... months) {
        this.setValue(months);
        return this;
    }

    public ByMonth() {
    }

    public ByMonth(int ... months) {
        this();
        this.setValue(months);
    }

    public ByMonth(Month ... months) {
        this();
        this.setValue(Arrays.asList(months));
    }

    public ByMonth(ByMonth source) {
        super(source);
    }

    @Override
    public String toString() {
        String days = ((List)this.getValue()).stream().map(d -> Integer.toString(d.getValue())).collect(Collectors.joining(","));
        return (Object)((Object)RRuleElement.BY_MONTH) + "=" + days;
    }

    @Override
    public Stream<Temporal> streamRecurrences(Stream<Temporal> inStream, ChronoUnit chronoUnit, Temporal startTemporal) {
        switch (chronoUnit) {
            case HOURS: 
            case MINUTES: 
            case SECONDS: 
            case DAYS: 
            case WEEKS: 
            case MONTHS: {
                return inStream.filter(t -> {
                    Month myMonth = Month.from(t);
                    for (Month month : (List)this.getValue()) {
                        if (month != myMonth) continue;
                        return true;
                    }
                    return false;
                });
            }
            case YEARS: {
                return inStream.flatMap(t -> {
                    ArrayList<Temporal> dates = new ArrayList<Temporal>();
                    int monthNum = Month.from(t).getValue();
                    for (Month month : (List)this.getValue()) {
                        int myMonthNum = month.getValue();
                        int monthShift = myMonthNum - monthNum;
                        Temporal newTemporal = t.plus(monthShift, ChronoUnit.MONTHS);
                        dates.add(newTemporal);
                    }
                    return dates.stream();
                });
            }
        }
        throw new RuntimeException("Not implemented ChronoUnit: " + chronoUnit);
    }

    @Override
    protected List<VElementBase.Message> parseContent(String content) {
        String valueString = ByMonth.extractValue(content);
        Month[] monthArray = (Month[])Arrays.asList(valueString.split(",")).stream().map(s -> Month.of(Integer.parseInt(s))).toArray(Month[]::new);
        this.setValue((T[])monthArray);
        return Collections.EMPTY_LIST;
    }

    public static ByMonth parse(String content) {
        return ByMonth.parse(new ByMonth(), content);
    }
}

