/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx;

import java.time.DayOfWeek;
import java.time.Year;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RecurrenceRuleValue;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.WeekStart;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx.ByRuleIntegerAbstract;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;

public class ByWeekNumber
extends ByRuleIntegerAbstract<ByWeekNumber> {
    private static final int MIN_DAYS_IN_WEEK = 4;

    private DayOfWeek getWeekStart() {
        if (this.getParent() != null) {
            WeekStart weekStart = ((RecurrenceRuleValue)this.getParent()).getWeekStart();
            return weekStart == null ? WeekStart.DEFAULT_WEEK_START : (DayOfWeek)weekStart.getValue();
        }
        return WeekStart.DEFAULT_WEEK_START;
    }

    public ByWeekNumber() {
    }

    public ByWeekNumber(Integer ... weekNumbers) {
        super(weekNumbers);
    }

    public ByWeekNumber(ByWeekNumber source) {
        super(source);
    }

    @Override
    Predicate<Integer> isValidValue() {
        return value -> value >= -53 && value <= 53 && value != 0;
    }

    @Override
    public Stream<Temporal> streamRecurrences(Stream<Temporal> inStream, ChronoUnit chronoUnit, Temporal dateTimeStart) {
        switch (chronoUnit) {
            case YEARS: {
                WeekFields weekFields = WeekFields.of(this.getWeekStart(), 4);
                Stream<Temporal> outStream = inStream.flatMap(date -> {
                    ArrayList dates = new ArrayList();
                    Iterator iterator = ((List)this.getValue()).iterator();
                    while (iterator.hasNext()) {
                        Temporal startDate;
                        int finalWeekNumber;
                        int weekNumber = (Integer)iterator.next();
                        Temporal correctYearTemporal = weekNumber > 0 ? date : date.minus(1L, ChronoUnit.YEARS);
                        correctYearTemporal = correctYearTemporal.with(TemporalAdjusters.firstDayOfYear()).with(TemporalAdjusters.nextOrSame(weekFields.getFirstDayOfWeek()));
                        Year correctYear = Year.from(correctYearTemporal);
                        long between = 0L;
                        if (weekNumber > 0) {
                            finalWeekNumber = weekNumber;
                        } else if (weekNumber < 0) {
                            Temporal lastDayOfYear;
                            int weeksInYear = 53;
                            Temporal startWeek53 = correctYearTemporal.with(weekFields.weekOfWeekBasedYear(), weeksInYear);
                            between = ChronoUnit.DAYS.between(startWeek53, lastDayOfYear = correctYearTemporal.with(TemporalAdjusters.lastDayOfYear()));
                            int adjustment = between >= 3L ? 1 : 0;
                            finalWeekNumber = weeksInYear + weekNumber + adjustment;
                        } else {
                            throw new IllegalArgumentException(this.name().toString() + " can't have a value of zero");
                        }
                        if ((startDate = finalWeekNumber > 0 ? correctYearTemporal.with(weekFields.weekOfWeekBasedYear(), finalWeekNumber) : (between < 0L ? correctYearTemporal.minus(1L, ChronoUnit.WEEKS) : null)) == null) continue;
                        IntStream.range(0, 7).forEach(days -> {
                            Temporal newTemporal = startDate.plus(days, ChronoUnit.DAYS);
                            Year myYear = Year.from(newTemporal);
                            if (myYear.equals(correctYear)) {
                                dates.add(newTemporal);
                            }
                        });
                    }
                    return dates.stream().sorted(DateTimeUtilities.TEMPORAL_COMPARATOR);
                });
                return outStream;
            }
            case DAYS: 
            case WEEKS: 
            case MONTHS: 
            case HOURS: 
            case MINUTES: 
            case SECONDS: {
                throw new IllegalArgumentException("BYWEEKNO is not available for " + chronoUnit + " frequency.");
            }
        }
        return null;
    }

    public static ByWeekNumber parse(String content) {
        return ByWeekNumber.parse(new ByWeekNumber(), content);
    }
}

