/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.timezone;

import java.time.DateTimeException;
import java.time.ZoneId;
import jfxtras.icalendarfx.properties.VPropertyBase;
import jfxtras.icalendarfx.utilities.StringConverter;

public class TimeZoneIdentifier
extends VPropertyBase<ZoneId, TimeZoneIdentifier> {
    private static final StringConverter<ZoneId> CONVERTER = new StringConverter<ZoneId>(){

        @Override
        public String toString(ZoneId object) {
            return object == null ? null : object.toString();
        }

        @Override
        public ZoneId fromString(String string) {
            try {
                return ZoneId.of(string);
            }
            catch (DateTimeException e) {
                return null;
            }
        }
    };

    public TimeZoneIdentifier(TimeZoneIdentifier source) {
        super(source);
    }

    public TimeZoneIdentifier(ZoneId value) {
        this();
        this.setValue(value);
    }

    public TimeZoneIdentifier() {
        this.setConverter(CONVERTER);
    }

    @Override
    public boolean isValid() {
        boolean isNonGlobalOK = this.getValue() != null;
        boolean isGloballyUniqueOK = this.getUnknownValue() != null && this.getUnknownValue().charAt(0) == '/';
        boolean isValueTypeOK = this.getValueType() != null ? this.allowedValueTypes.contains(this.getValueType().getValue()) : true;
        return (isNonGlobalOK || isGloballyUniqueOK) && isValueTypeOK;
    }

    @Override
    public boolean equals(Object obj) {
        boolean superEquals = super.equals(obj);
        if (!superEquals) {
            return false;
        }
        TimeZoneIdentifier testObj = (TimeZoneIdentifier)obj;
        boolean unknownEquals = this.getUnknownValue() == null ? testObj.getUnknownValue() == null : this.getUnknownValue().equals(testObj.getUnknownValue());
        return unknownEquals;
    }

    public static TimeZoneIdentifier parse(String content) {
        return TimeZoneIdentifier.parse(new TimeZoneIdentifier(), content);
    }
}

