/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.fxml;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javafx.scene.Node;
import jfxtras.fxml.BuilderService;
import jfxtras.internal.scene.control.fxml.AbstractBuilder;
import jfxtras.scene.control.CalendarTimePicker;

public class CalendarTimePickerBuilder
extends AbstractBuilder
implements BuilderService<CalendarTimePicker> {
    private static final SimpleDateFormat HMSSimpleDateFormat = new SimpleDateFormat("HH:mm:ss");
    private Calendar calendar = null;
    private Locale locale = null;
    private Integer minuteStep = null;
    private Integer secondStep = null;

    public String getCalendar() {
        return null;
    }

    public void setCalendar(String value) {
        try {
            Calendar lCalendar = Calendar.getInstance();
            lCalendar.setTime(HMSSimpleDateFormat.parse(value));
            this.calendar = lCalendar;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLocale() {
        return null;
    }

    public void setLocale(String value) {
        this.locale = Locale.forLanguageTag(value);
    }

    public Integer getMinuteStep() {
        return null;
    }

    public void setMinuteStep(Integer value) {
        this.minuteStep = (int)value;
    }

    public Integer getSecondStep() {
        return null;
    }

    public void setSecondStep(Integer value) {
        this.secondStep = (int)value;
    }

    public CalendarTimePicker build() {
        CalendarTimePicker lCalendarTimePicker = new CalendarTimePicker();
        if (this.locale != null) {
            lCalendarTimePicker.setLocale(this.locale);
        }
        if (this.calendar != null) {
            lCalendarTimePicker.setCalendar(this.calendar);
        }
        if (this.minuteStep != null) {
            lCalendarTimePicker.setMinuteStep(this.minuteStep);
        }
        if (this.secondStep != null) {
            lCalendarTimePicker.setSecondStep(this.secondStep);
        }
        this.applyCommonProperties((Node)lCalendarTimePicker);
        return lCalendarTimePicker;
    }

    @Override
    public boolean isBuilderFor(Class<?> clazz) {
        return CalendarTimePicker.class.isAssignableFrom(clazz);
    }
}

