/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.fxml;

import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import jfxtras.fxml.BuilderService;
import jfxtras.internal.scene.control.fxml.AbstractLocalDateTimeAPITextFieldBuilder;
import jfxtras.scene.control.LocalTimeTextField;

public class LocalTimeTextFieldBuilder
extends AbstractLocalDateTimeAPITextFieldBuilder
implements BuilderService<LocalTimeTextField> {
    public LocalTimeTextField build() {
        Locale lLocale = this.iLocale == null ? Locale.getDefault() : this.iLocale;
        LocalTimeTextField lLocalTimeTextField = new LocalTimeTextField();
        if (this.iDateTimeFormatter != null) {
            lLocalTimeTextField.setDateTimeFormatter(DateTimeFormatter.ofPattern(this.iDateTimeFormatter).withLocale(lLocale));
        }
        if (this.iPromptText != null) {
            lLocalTimeTextField.setPromptText(this.iPromptText);
        }
        if (this.iDateTimeFormatters != null) {
            ObservableList lDateTimeFormatters = FXCollections.observableArrayList();
            for (String lPart : this.iDateTimeFormatters) {
                lDateTimeFormatters.add((Object)DateTimeFormatter.ofPattern(lPart.trim()).withLocale(lLocale));
            }
            lLocalTimeTextField.setDateTimeFormatters((ObservableList<DateTimeFormatter>)lDateTimeFormatters);
        }
        this.applyCommonProperties((Node)lLocalTimeTextField);
        return lLocalTimeTextField;
    }

    @Override
    public boolean isBuilderFor(Class<?> clazz) {
        return LocalTimeTextField.class.isAssignableFrom(clazz);
    }
}

