/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Popup;
import jfxtras.internal.scene.control.skin.CalendarTimePickerSkin;
import jfxtras.internal.scene.control.skin.TextFieldSkin;
import jfxtras.scene.control.CalendarTimePicker;
import jfxtras.scene.control.CalendarTimeTextField;
import jfxtras.scene.control.ImageViewButton;
import jfxtras.util.NodeUtil;

public class CalendarTimeTextFieldSkin
extends SkinBase<CalendarTimeTextField>
implements TextFieldSkin {
    private TextField textField = null;
    private ImageView imageView = null;
    private GridPane gridPane = null;
    private CalendarTimePicker calendarTimePicker = null;
    private Popup popup = null;
    private CalendarTimePicker calendarPicker = null;

    public CalendarTimeTextFieldSkin(CalendarTimeTextField control) {
        super((Control)control);
        this.construct();
    }

    private void construct() {
        this.createNodes();
        this.textField.editableProperty().bindBidirectional((Property)((CalendarTimeTextField)this.getSkinnable()).editableProperty());
        ((CalendarTimeTextField)this.getSkinnable()).calendarProperty().addListener(observable -> this.refreshValue());
        ((CalendarTimeTextField)this.getSkinnable()).dateFormatProperty().addListener(observable -> this.refreshValue());
        this.refreshValue();
        this.initFocusSimulation();
        ((CalendarTimeTextField)this.getSkinnable()).pickerShowingProperty().addListener((observable, oldValue, showing) -> {
            if (showing.booleanValue()) {
                this.showPopup();
            } else if (this.popup != null) {
                this.popup.hide();
            }
        });
    }

    private void refreshValue() {
        Calendar c = ((CalendarTimeTextField)this.getSkinnable()).getCalendar();
        String s = c == null ? "" : ((CalendarTimeTextField)this.getSkinnable()).getDateFormat().format(c.getTime());
        this.textField.setText(s);
    }

    private void initFocusSimulation() {
        ((CalendarTimeTextField)this.getSkinnable()).focusedProperty().addListener((observable, wasFocused, isFocused) -> {
            if (isFocused.booleanValue()) {
                this.textField.requestFocus();
            }
        });
    }

    @Override
    public void selectAll() {
        this.textField.selectAll();
    }

    private void createNodes() {
        this.textField = new TextField();
        this.textField.focusedProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable arg0) {
                if (!CalendarTimeTextFieldSkin.this.textField.isFocused()) {
                    CalendarTimeTextFieldSkin.this.parse();
                }
            }
        });
        this.textField.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent evt) {
                CalendarTimeTextFieldSkin.this.parse();
            }
        });
        this.textField.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN) {
                    CalendarTimeTextFieldSkin.this.parse();
                    Calendar lCalendar = (Calendar)((CalendarTimeTextField)CalendarTimeTextFieldSkin.this.getSkinnable()).getCalendar().clone();
                    if (keyEvent.isControlDown()) {
                        lCalendar.add(11, keyEvent.getCode() == KeyCode.UP ? 1 : -1);
                    } else {
                        lCalendar.add(12, keyEvent.getCode() == KeyCode.UP ? ((CalendarTimeTextField)CalendarTimeTextFieldSkin.this.getSkinnable()).getMinuteStep() : -1 * ((CalendarTimeTextField)CalendarTimeTextFieldSkin.this.getSkinnable()).getMinuteStep());
                    }
                    ((CalendarTimeTextField)CalendarTimeTextFieldSkin.this.getSkinnable()).setCalendar(CalendarTimePickerSkin.blockMinutesToStep(lCalendar, ((CalendarTimeTextField)CalendarTimeTextFieldSkin.this.getSkinnable()).getMinuteStep()));
                }
            }
        });
        this.textField.tooltipProperty().bindBidirectional((Property)((CalendarTimeTextField)this.getSkinnable()).tooltipProperty());
        if (((CalendarTimeTextField)this.getSkinnable()).getTooltip() == null) {
            ((CalendarTimeTextField)this.getSkinnable()).setTooltip(new Tooltip("Type a time or use # for now, or +/-<number>[h|m] for delta's (for example: -3m for minus 3 minutes)\nUse cursor up and down plus optional ctrl (hour) for quick keyboard changes."));
        }
        this.textField.promptTextProperty().bind(((CalendarTimeTextField)this.getSkinnable()).promptTextProperty());
        this.imageView = new ImageViewButton();
        this.imageView.getStyleClass().add((Object)"icon");
        this.imageView.setPickOnBounds(true);
        this.imageView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent evt) {
                if (!CalendarTimeTextFieldSkin.this.textField.isEditable()) {
                    return;
                }
                if (CalendarTimeTextFieldSkin.this.textField.focusedProperty().get()) {
                    CalendarTimeTextFieldSkin.this.parse();
                }
                ((CalendarTimeTextField)CalendarTimeTextFieldSkin.this.getSkinnable()).setPickerShowing(true);
            }
        });
        this.gridPane = new GridPane();
        this.gridPane.setHgap(3.0);
        this.gridPane.add((Node)this.textField, 0, 0);
        this.gridPane.add((Node)this.imageView, 1, 0);
        ColumnConstraints column0 = new ColumnConstraints(20.0, 100.0, Double.MAX_VALUE);
        column0.setHgrow(Priority.ALWAYS);
        this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column0});
        ((CalendarTimeTextField)this.getSkinnable()).getStyleClass().add((Object)this.getClass().getSimpleName());
        this.getChildren().add((Object)this.gridPane);
        this.calendarTimePicker = new CalendarTimePicker();
        Bindings.bindBidirectional(this.calendarTimePicker.minuteStepProperty(), ((CalendarTimeTextField)this.getSkinnable()).minuteStepProperty());
        Bindings.bindBidirectional(this.calendarTimePicker.secondStepProperty(), ((CalendarTimeTextField)this.getSkinnable()).secondStepProperty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() {
        block16: {
            try {
                String lText = this.textField.getText();
                lText = lText.trim();
                if (lText.length() == 0) {
                    ((CalendarTimeTextField)this.getSkinnable()).setCalendar(null);
                    return;
                }
                if (lText.startsWith("-") || lText.startsWith("+")) {
                    if (lText.startsWith("+")) {
                        lText = lText.substring(1);
                    }
                    int lUnit = 5;
                    if (lText.toLowerCase().endsWith("m")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 12;
                    }
                    if (lText.toLowerCase().endsWith("h")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 11;
                    }
                    int lDelta = Integer.parseInt(lText);
                    Calendar lCalendar = (Calendar)((CalendarTimeTextField)this.getSkinnable()).getCalendar().clone();
                    lCalendar.add(lUnit, lDelta);
                    ((CalendarTimeTextField)this.getSkinnable()).setCalendar(CalendarTimePickerSkin.blockMinutesToStep(lCalendar, ((CalendarTimeTextField)this.getSkinnable()).getMinuteStep()));
                    break block16;
                }
                if (lText.equals("#")) {
                    ((CalendarTimeTextField)this.getSkinnable()).setCalendar(CalendarTimePickerSkin.blockMinutesToStep(Calendar.getInstance(((CalendarTimeTextField)this.getSkinnable()).getLocale()), ((CalendarTimeTextField)this.getSkinnable()).getMinuteStep()));
                    break block16;
                }
                try {
                    Calendar lCalendar = ((CalendarTimeTextField)this.getSkinnable()).getCalendar();
                    Date lDate = null;
                    for (DateFormat lDateFormat : ((CalendarTimeTextField)this.getSkinnable()).getDateFormats()) {
                        try {
                            lDate = lDateFormat.parse(lText);
                            break;
                        }
                        catch (ParseException parseException) {
                        }
                    }
                    if (lDate == null) {
                        lDate = ((CalendarTimeTextField)this.getSkinnable()).getDateFormat().parse(lText);
                    }
                    lCalendar = Calendar.getInstance(((CalendarTimeTextField)this.getSkinnable()).getLocale());
                    lCalendar.setTime(lDate);
                    ((CalendarTimeTextField)this.getSkinnable()).setCalendar(lCalendar);
                }
                finally {
                    this.refreshValue();
                }
            }
            catch (Throwable t) {
                if (((CalendarTimeTextField)this.getSkinnable()).getParseErrorCallback() != null) {
                    ((CalendarTimeTextField)this.getSkinnable()).getParseErrorCallback().call((Object)t);
                }
                t.printStackTrace();
            }
        }
    }

    private void setupPopup() {
        this.popup = new Popup();
        this.popup.setAutoFix(true);
        this.popup.setAutoHide(true);
        this.popup.setHideOnEscape(true);
        BorderPane lBorderPane = new BorderPane(){

            public String getUserAgentStylesheet() {
                return ((CalendarTimeTextField)CalendarTimeTextFieldSkin.this.getSkinnable()).getUserAgentStylesheet();
            }
        };
        lBorderPane.getStyleClass().add((Object)(this.getClass().getSimpleName() + "_popup"));
        lBorderPane.setCenter((Node)this.calendarTimePicker);
        ImageViewButton lImageView = new ImageViewButton();
        lImageView.getStyleClass().addAll((Object[])new String[]{"close-icon"});
        lImageView.setPickOnBounds(true);
        lImageView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent evt) {
                CalendarTimeTextFieldSkin.this.popup.hide();
                CalendarTimeTextFieldSkin.this.popup = null;
                ((CalendarTimeTextField)CalendarTimeTextFieldSkin.this.getSkinnable()).calendarProperty().set(CalendarTimeTextFieldSkin.this.calendarTimePicker.calendarProperty().get());
            }
        });
        lBorderPane.rightProperty().set((Object)lImageView);
        this.popup.getContent().add((Object)lBorderPane);
        this.popup.setOnShown(event -> ((CalendarTimePickerSkin)this.calendarTimePicker.getSkin()).labelDateFormatProperty().set((Object)((CalendarTimeTextField)this.getSkinnable()).getDateFormat()));
        this.popup.showingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean showing) {
                ((CalendarTimeTextField)CalendarTimeTextFieldSkin.this.getSkinnable()).setPickerShowing(showing);
                if (!showing.booleanValue()) {
                    CalendarTimeTextFieldSkin.this.popup.showingProperty().removeListener((ChangeListener)this);
                    CalendarTimeTextFieldSkin.this.popup = null;
                }
            }
        });
    }

    private void showPopup() {
        if (this.popup == null) {
            this.setupPopup();
        }
        this.calendarTimePicker.calendarProperty().set(((CalendarTimeTextField)this.getSkinnable()).calendarProperty().get());
        double height = this.textField.getHeight() == 0.0 ? this.textField.prefHeight(-1.0) : this.textField.getHeight();
        this.popup.show((Node)this.textField, NodeUtil.screenX((Node)this.getSkinnable()), NodeUtil.screenY((Node)this.getSkinnable()) + height);
    }
}

