/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import java.time.LocalDate;
import java.util.Calendar;
import java.util.Collection;
import java.util.logging.Logger;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper;
import jfxtras.scene.control.CalendarPicker;
import jfxtras.scene.control.LocalDatePicker;

public class LocalDatePickerSkin
extends SkinBase<LocalDatePicker> {
    private static final Logger log = Logger.getLogger(LocalDatePickerSkin.class.getName());
    private CalendarPicker calendarPicker = null;

    public LocalDatePickerSkin(LocalDatePicker control) {
        super((Control)control);
        this.construct();
    }

    private void construct() {
        this.createNodes();
        this.calendarPicker.getStyleClass().addAll((Object[])new String[]{((Object)((Object)((LocalDatePicker)this.getSkinnable()))).getClass().getSimpleName()});
        this.calendarPicker.getStyleClass().addAll((Collection)((LocalDatePicker)this.getSkinnable()).getStyleClass());
        this.calendarPicker.styleProperty().bindBidirectional((Property)((LocalDatePicker)this.getSkinnable()).styleProperty());
        this.calendarPicker.localeProperty().bindBidirectional(((LocalDatePicker)this.getSkinnable()).localeProperty());
        DateTimeToCalendarHelper.syncLocalDate(this.calendarPicker.calendarProperty(), ((LocalDatePicker)this.getSkinnable()).localDateProperty(), ((LocalDatePicker)this.getSkinnable()).localeProperty());
        DateTimeToCalendarHelper.syncLocalDate(this.calendarPicker.displayedCalendar(), ((LocalDatePicker)this.getSkinnable()).displayedLocalDateProperty(), ((LocalDatePicker)this.getSkinnable()).localeProperty());
        DateTimeToCalendarHelper.syncLocalDates(this.calendarPicker.calendars(), ((LocalDatePicker)this.getSkinnable()).localDates(), ((LocalDatePicker)this.getSkinnable()).localeProperty());
        DateTimeToCalendarHelper.syncLocalDates(this.calendarPicker.highlightedCalendars(), ((LocalDatePicker)this.getSkinnable()).highlightedLocalDates(), ((LocalDatePicker)this.getSkinnable()).localeProperty());
        DateTimeToCalendarHelper.syncLocalDates(this.calendarPicker.disabledCalendars(), ((LocalDatePicker)this.getSkinnable()).disabledLocalDates(), ((LocalDatePicker)this.getSkinnable()).localeProperty());
        this.syncMode();
        this.calendarPicker.allowNullProperty().bindBidirectional((Property)((LocalDatePicker)this.getSkinnable()).allowNullProperty());
        this.calendarPicker.setCalendarRangeCallback(new Callback<CalendarPicker.CalendarRange, Void>(){

            public Void call(CalendarPicker.CalendarRange calendarRange) {
                Callback<LocalDatePicker.LocalDateRange, Void> lCallback = ((LocalDatePicker)LocalDatePickerSkin.this.getSkinnable()).getLocalDateRangeCallback();
                if (lCallback == null) {
                    return null;
                }
                return (Void)lCallback.call((Object)new LocalDatePicker.LocalDateRange(DateTimeToCalendarHelper.createLocalDateFromCalendar(calendarRange.getStartCalendar()), DateTimeToCalendarHelper.createLocalDateFromCalendar(calendarRange.getEndCalendar())));
            }
        });
        this.calendarPicker.setValueValidationCallback(new Callback<Calendar, Boolean>(){

            public Boolean call(Calendar calendar) {
                Callback<LocalDate, Boolean> lCallback = ((LocalDatePicker)LocalDatePickerSkin.this.getSkinnable()).getValueValidationCallback();
                if (lCallback == null) {
                    return true;
                }
                return (Boolean)lCallback.call((Object)DateTimeToCalendarHelper.createLocalDateFromCalendar(calendar));
            }
        });
    }

    private void syncMode() {
        this.calendarPicker.modeProperty().addListener(invalidationEvent -> {
            CalendarPicker.Mode newValue = this.calendarPicker.getMode();
            if (newValue == CalendarPicker.Mode.SINGLE) {
                ((LocalDatePicker)this.getSkinnable()).modeProperty().set((Object)LocalDatePicker.Mode.SINGLE);
            }
            if (newValue == CalendarPicker.Mode.RANGE) {
                ((LocalDatePicker)this.getSkinnable()).modeProperty().set((Object)LocalDatePicker.Mode.RANGE);
            }
            if (newValue == CalendarPicker.Mode.MULTIPLE) {
                ((LocalDatePicker)this.getSkinnable()).modeProperty().set((Object)LocalDatePicker.Mode.MULTIPLE);
            }
        });
        InvalidationListener localDatePickerModeInvalidationListener = invalidationEvent -> {
            LocalDatePicker.Mode newValue = ((LocalDatePicker)this.getSkinnable()).getMode();
            if (newValue == LocalDatePicker.Mode.SINGLE) {
                this.calendarPicker.modeProperty().set((Object)CalendarPicker.Mode.SINGLE);
            }
            if (newValue == LocalDatePicker.Mode.RANGE) {
                this.calendarPicker.modeProperty().set((Object)CalendarPicker.Mode.RANGE);
            }
            if (newValue == LocalDatePicker.Mode.MULTIPLE) {
                this.calendarPicker.modeProperty().set((Object)CalendarPicker.Mode.MULTIPLE);
            }
        };
        ((LocalDatePicker)this.getSkinnable()).modeProperty().addListener(localDatePickerModeInvalidationListener);
        localDatePickerModeInvalidationListener.invalidated(null);
    }

    private void createNodes() {
        this.calendarPicker = new CalendarPicker();
        this.getChildren().add((Object)this.calendarPicker);
        ((LocalDatePicker)this.getSkinnable()).getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
    }
}

