/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.base24hour;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentAbstractPane;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentRegularBodyPane;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentTaskBodyPane;
import jfxtras.internal.scene.control.skin.agenda.base24hour.LayoutHelp;
import jfxtras.scene.control.agenda.Agenda;

abstract class AppointmentAbstractTrackedPane
extends AppointmentAbstractPane {
    protected final LocalDateTime startDateTime;
    protected final LocalDateTime endDateTime;
    protected final long durationInMS;
    protected final boolean firstPaneOfAppointment;
    protected final boolean intermediatePaneOfAppointment;
    protected final boolean lastPaneOfAppointment;
    List<AppointmentAbstractTrackedPane> clusterMembers = new ArrayList<AppointmentAbstractTrackedPane>();
    List<List<AppointmentAbstractTrackedPane>> clusterTracks = new ArrayList<List<AppointmentAbstractTrackedPane>>();
    AppointmentAbstractTrackedPane clusterOwner = this;
    int clusterTrackIdx = -1;

    AppointmentAbstractTrackedPane(LocalDate localDate, Agenda.Appointment appointment, LayoutHelp layoutHelp) {
        super(appointment, layoutHelp);
        LocalDateTime localDateTime = this.startDateTime = appointment.getStartLocalDateTime().toLocalDate().isEqual(localDate) ? appointment.getStartLocalDateTime() : localDate.atStartOfDay();
        if (appointment.getEndLocalDateTime() == null) {
            this.endDateTime = null;
            this.durationInMS = 0L;
        } else {
            this.endDateTime = appointment.getEndLocalDateTime().toLocalDate().isEqual(localDate) ? appointment.getEndLocalDateTime() : localDate.plusDays(1L).atStartOfDay();
            this.durationInMS = this.startDateTime.until(this.endDateTime, ChronoUnit.MILLIS);
        }
        this.firstPaneOfAppointment = this.startDateTime.equals(appointment.getStartLocalDateTime());
        this.lastPaneOfAppointment = this.endDateTime != null && this.endDateTime.equals(appointment.getEndLocalDateTime());
        this.intermediatePaneOfAppointment = !this.firstPaneOfAppointment && !this.lastPaneOfAppointment;
    }

    @Override
    protected boolean showStartTimeText() {
        return this.firstPaneOfAppointment;
    }

    @Override
    protected boolean showEndTimeText() {
        return this.lastPaneOfAppointment;
    }

    static List<? extends AppointmentAbstractTrackedPane> determineTracks(List<? extends AppointmentAbstractTrackedPane> appointmentAbstractTrackedPanes) {
        Collections.sort(appointmentAbstractTrackedPanes, new Comparator<AppointmentAbstractTrackedPane>(){

            @Override
            public int compare(AppointmentAbstractTrackedPane o1, AppointmentAbstractTrackedPane o2) {
                if (!o1.startDateTime.isEqual(o2.startDateTime)) {
                    return o1.startDateTime.compareTo(o2.startDateTime);
                }
                if (o1 instanceof AppointmentRegularBodyPane && o2 instanceof AppointmentTaskBodyPane) {
                    return -1;
                }
                if (o1 instanceof AppointmentTaskBodyPane && o2 instanceof AppointmentRegularBodyPane) {
                    return 1;
                }
                return o1.durationInMS == o2.durationInMS ? 0 : (o1.durationInMS > o2.durationInMS ? -1 : 1);
            }
        });
        AppointmentAbstractTrackedPane lClusterOwner = null;
        for (AppointmentAbstractTrackedPane appointmentAbstractTrackedPane : appointmentAbstractTrackedPanes) {
            int lTrackNr;
            if (lClusterOwner == null) {
                lClusterOwner = appointmentAbstractTrackedPane;
                lClusterOwner.clusterTracks = new ArrayList<List<AppointmentAbstractTrackedPane>>();
            }
            if ((lTrackNr = AppointmentAbstractTrackedPane.determineTrackWhereAppointmentCanBeAdded(lClusterOwner.clusterTracks, appointmentAbstractTrackedPane)) == 0) {
                boolean lOverlaps = false;
                for (int i = 1; i < lClusterOwner.clusterTracks.size() && !lOverlaps; ++i) {
                    lOverlaps = AppointmentAbstractTrackedPane.checkIfTheAppointmentOverlapsAnAppointmentAlreadyInThisTrack(lClusterOwner.clusterTracks, i, appointmentAbstractTrackedPane);
                }
                if (!lOverlaps) {
                    lClusterOwner = appointmentAbstractTrackedPane;
                    lClusterOwner.clusterMembers = new ArrayList<AppointmentAbstractTrackedPane>();
                    lClusterOwner.clusterTracks = new ArrayList<List<AppointmentAbstractTrackedPane>>();
                    lClusterOwner.clusterTracks.add(new ArrayList());
                }
            }
            lClusterOwner.clusterMembers.add(appointmentAbstractTrackedPane);
            lClusterOwner.clusterTracks.get(lTrackNr).add(appointmentAbstractTrackedPane);
            appointmentAbstractTrackedPane.clusterOwner = lClusterOwner;
            appointmentAbstractTrackedPane.clusterTrackIdx = lTrackNr;
        }
        return appointmentAbstractTrackedPanes;
    }

    private static int determineTrackWhereAppointmentCanBeAdded(List<List<AppointmentAbstractTrackedPane>> tracks, AppointmentAbstractTrackedPane appointmentPane) {
        int lTrackNr = 0;
        while (true) {
            if (lTrackNr == tracks.size()) {
                tracks.add(new ArrayList());
            }
            if (!AppointmentAbstractTrackedPane.checkIfTheAppointmentOverlapsAnAppointmentAlreadyInThisTrack(tracks, lTrackNr, appointmentPane)) {
                return lTrackNr;
            }
            ++lTrackNr;
        }
    }

    private static boolean checkIfTheAppointmentOverlapsAnAppointmentAlreadyInThisTrack(List<List<AppointmentAbstractTrackedPane>> tracks, int tracknr, AppointmentAbstractTrackedPane newAppointmentPane) {
        List<AppointmentAbstractTrackedPane> lTrack = tracks.get(tracknr);
        for (AppointmentAbstractTrackedPane lAppointmentPane : lTrack) {
            LocalDateTime lNewEnd;
            LocalDateTime lPlacedStart = lAppointmentPane.startDateTime;
            LocalDateTime lPlacedEnd = lAppointmentPane.endDateTime != null ? lAppointmentPane.endDateTime : lAppointmentPane.startDateTime.plusMinutes(10L);
            LocalDateTime lNewStart = newAppointmentPane.startDateTime;
            LocalDateTime localDateTime = lNewEnd = newAppointmentPane.endDateTime != null ? newAppointmentPane.endDateTime : newAppointmentPane.startDateTime.plusMinutes(10L);
            if (!lPlacedStart.isEqual(lNewStart) && lNewEnd != null && !lPlacedStart.isBefore(lNewEnd) || lPlacedEnd == null || !lPlacedEnd.isAfter(lNewStart)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "pane=" + this.startDateTime + "-" + this.endDateTime + ";" + super.toString();
    }
}

