/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.base24hour;

import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentAbstractTrackedPane;
import jfxtras.internal.scene.control.skin.agenda.base24hour.LayoutHelp;
import jfxtras.scene.control.agenda.Agenda;

class AppointmentTaskBodyPane
extends AppointmentAbstractTrackedPane {
    private String startAsString;
    private Text timeText = null;
    private Text summaryText = null;

    AppointmentTaskBodyPane(Agenda.Appointment appointment, LayoutHelp layoutHelp) {
        super(appointment.getStartLocalDateTime().toLocalDate(), appointment, layoutHelp);
        this.startAsString = layoutHelp.timeDateTimeFormatter.format(this.startDateTime);
        this.appointmentMenu.yProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)this.appointmentMenu.heightProperty()).divide(2.0));
        this.getChildren().add((Object)this.appointmentMenu);
        this.getChildren().add((Object)this.createTimeText());
        if (appointment.getSummary() != null) {
            this.getChildren().add((Object)this.createSummaryText());
        }
    }

    private Text createTimeText() {
        this.timeText = new Text(this.startAsString);
        this.timeText.getStyleClass().add((Object)"AppointmentTimeLabel");
        this.timeText.xProperty().bind((ObservableValue)this.appointmentMenu.widthProperty().add((ObservableNumberValue)this.layoutHelp.paddingProperty).add((ObservableNumberValue)this.layoutHelp.paddingProperty));
        this.timeText.yProperty().bind((ObservableValue)this.heightProperty().multiply(-0.5).add(this.timeText.prefHeight(0.0) / 2.0));
        return this.timeText;
    }

    private Text createSummaryText() {
        this.summaryText = new Text(this.appointment.getSummary().replace("\n", ""));
        this.summaryText.setWrappingWidth(0.0);
        this.summaryText.getStyleClass().add((Object)"AppointmentLabel");
        this.summaryText.xProperty().bind((ObservableValue)this.timeText.xProperty().add(this.timeText.prefWidth(0.0)));
        this.summaryText.yProperty().bind((ObservableValue)this.timeText.yProperty());
        this.summaryText.wrappingWidthProperty().bind((ObservableValue)this.widthProperty().subtract(this.layoutHelp.paddingProperty.get()));
        Rectangle lClip = new Rectangle(0.0, 0.0, 0.0, 0.0);
        lClip.xProperty().bind((ObservableValue)this.summaryText.xProperty());
        lClip.yProperty().bind((ObservableValue)this.summaryText.yProperty().multiply(-1.0));
        lClip.widthProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)this.summaryText.yProperty()).subtract(40.0));
        lClip.heightProperty().set(this.timeText.prefHeight(0.0));
        this.summaryText.setClip((Node)lClip);
        return this.summaryText;
    }
}

