/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;

public class CategorySelectionGridPane
extends GridPane {
    private Pane[] icons;
    private final ImageView checkIcon = new ImageView();
    private IntegerProperty categorySelected = new SimpleIntegerProperty(-1);

    public IntegerProperty categorySelectedProperty() {
        return this.categorySelected;
    }

    public void setCategorySelected(Integer i) {
        this.categorySelected.set(i.intValue());
    }

    public Integer getCategorySelected() {
        return this.categorySelected.getValue();
    }

    public CategorySelectionGridPane() {
        this.checkIcon.getStyleClass().add((Object)"check-icon");
    }

    public void setupData(String initialCategory, List<String> categories) {
        this.setHgap(3.0);
        this.setVgap(3.0);
        this.icons = new Pane[categories.size()];
        List categoriesIndices = IntStream.range(0, categories.size()).mapToObj(i -> new Integer(i)).collect(Collectors.toList());
        for (Integer lCnt : categoriesIndices) {
            Pane icon = new Pane();
            icon.setPrefSize(24.0, 24.0);
            Rectangle rectangle = new Rectangle(24.0, 24.0);
            rectangle.setArcWidth(6.0);
            rectangle.setArcHeight(6.0);
            rectangle.getStyleClass().add((Object)("group" + lCnt));
            icon.getChildren().add((Object)rectangle);
            this.icons[lCnt.intValue()] = icon;
            this.add((Node)this.icons[lCnt], lCnt % 12, lCnt / 12);
            this.updateToolTip(lCnt, categories.get(lCnt));
            this.setupMouseOverAsBusy((Node)this.icons[lCnt]);
            this.icons[lCnt].setOnMouseClicked(mouseEvent -> {
                mouseEvent.consume();
                this.categorySelected.set(lCnt.intValue());
            });
        }
        int index = categories.indexOf(initialCategory);
        if (index >= 0) {
            this.setCategorySelected(index);
            this.setLPane(index);
        }
        this.categorySelectedProperty().addListener((observable, oldSelection, newSelection) -> {
            int oldS = (Integer)oldSelection;
            int newS = (Integer)newSelection;
            this.setLPane(newS);
            this.unsetLPane(oldS);
        });
    }

    private void unsetLPane(int i) {
        if (i >= 0) {
            this.icons[i].getChildren().remove((Object)this.checkIcon);
        }
    }

    private void setLPane(int i) {
        this.icons[i].getChildren().add((Object)this.checkIcon);
    }

    public void updateToolTip(int i, String category) {
        if (category != null) {
            Tooltip.install((Node)this.icons[i], (Tooltip)new Tooltip(category));
        }
    }

    private void setupMouseOverAsBusy(Node node) {
        node.setOnMouseEntered(mouseEvent -> {
            if (!mouseEvent.isPrimaryButtonDown()) {
                node.setCursor(Cursor.HAND);
                mouseEvent.consume();
            }
        });
        node.setOnMouseExited(mouseEvent -> {
            if (!mouseEvent.isPrimaryButtonDown()) {
                node.setCursor(Cursor.DEFAULT);
                mouseEvent.consume();
            }
        });
    }
}

