/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour;

import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.shape.Rectangle;
import javafx.stage.Modality;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.AgendaDateTimeUtilities;
import jfxtras.scene.control.agenda.Agenda;

public class NewAppointmentDialog
extends Dialog<ButtonBar.ButtonData> {
    public NewAppointmentDialog(Agenda.Appointment appointment, ObservableList<Agenda.AppointmentGroup> appointmentGroups, ResourceBundle resources) {
        this.initModality(Modality.APPLICATION_MODAL);
        this.setTitle(resources.getString("dialog.event.new.title"));
        String appointmentTime = AgendaDateTimeUtilities.formatRange(appointment.getStartTemporal(), appointment.getEndTemporal());
        this.setHeaderText(appointmentTime);
        ButtonType createButton = new ButtonType(resources.getString("dialog.event.new.create"), ButtonBar.ButtonData.OK_DONE);
        ButtonType editButton = new ButtonType(resources.getString("dialog.event.new.edit"), ButtonBar.ButtonData.OTHER);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{createButton, editButton, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        TextField summaryTextField = new TextField(appointment.getSummary());
        summaryTextField.setPromptText(resources.getString("new.event"));
        summaryTextField.textProperty().addListener((obs, oldValue, newValue) -> appointment.setSummary((String)newValue));
        ComboBox appointmentGroupComboBox = new ComboBox();
        appointmentGroupComboBox.setItems(appointmentGroups);
        appointmentGroupComboBox.getSelectionModel().select((Object)appointment.getAppointmentGroup());
        appointmentGroupComboBox.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> appointment.setAppointmentGroup((Agenda.AppointmentGroup)newSelection));
        this.getDialogPane().setId("newAppointmentDialog");
        this.getDialogPane().lookupButton(createButton).setId("newAppointmentCreateButton");
        this.getDialogPane().lookupButton(editButton).setId("newAppointmentEditButton");
        this.getDialogPane().lookupButton(ButtonType.CANCEL).setId("newAppointmentCancelButton");
        summaryTextField.setId("summaryTextField");
        appointmentGroupComboBox.setId("appointmentGroupComboBox");
        Map<Agenda.AppointmentGroup, Node> iconMap = appointmentGroups.stream().collect(Collectors.toMap(g -> g, g -> {
            Rectangle icon = new Rectangle(20.0, 20.0);
            icon.getStyleClass().add((Object)g.getStyleClass());
            return icon;
        }));
        Callback cellFactory = p -> new ListCell<Agenda.AppointmentGroup>(){

            protected void updateItem(Agenda.AppointmentGroup item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                } else {
                    Rectangle icon = new Rectangle(20.0, 20.0);
                    icon.setArcWidth(6.0);
                    icon.setArcHeight(6.0);
                    icon.getStyleClass().add((Object)item.getStyleClass());
                    this.setGraphic((Node)icon);
                    this.setText(item.getDescription());
                }
            }
        };
        appointmentGroupComboBox.setCellFactory(cellFactory);
        appointmentGroupComboBox.setButtonCell((ListCell)cellFactory.call(null));
        grid.add((Node)new Label(resources.getString("summary")), 0, 0);
        grid.add((Node)summaryTextField, 1, 0);
        grid.add((Node)new Label(resources.getString("category")), 0, 1);
        grid.add((Node)appointmentGroupComboBox, 1, 1);
        this.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> summaryTextField.requestFocus());
        this.setResultConverter(dialogButton -> dialogButton.getButtonData());
    }
}

