/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour;

import java.util.ResourceBundle;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.AgendaDateTimeUtilities;
import jfxtras.scene.control.agenda.Agenda;

public class OneAppointmentSelectedAlert
extends Alert {
    public OneAppointmentSelectedAlert(Agenda.Appointment appointment, ResourceBundle resources) {
        super(Alert.AlertType.CONFIRMATION);
        this.initModality(Modality.NONE);
        this.getDialogPane().getStyleClass().add((Object)"choice-dialog");
        ButtonType editButtonType = new ButtonType(resources.getString("edit"));
        ButtonType deleteButtonType = new ButtonType(resources.getString("delete"));
        ButtonType cancelButtonType = ButtonType.CANCEL;
        this.getButtonTypes().setAll((Object[])new ButtonType[]{editButtonType, deleteButtonType, cancelButtonType});
        this.getDialogPane().setId("newAppointmentDialog");
        this.getDialogPane().lookupButton(editButtonType).setId("OneAppointmentSelectedEditButton");
        this.getDialogPane().lookupButton(deleteButtonType).setId("OneAppointmentSelectedDeleteButton");
        this.getDialogPane().lookupButton(cancelButtonType).setId("OneAppointmentSelectedCancelButton");
        this.setTitle(resources.getString("alert.one.appointment.title"));
        String appointmentTime = AgendaDateTimeUtilities.formatRange(appointment.getStartTemporal(), appointment.getEndTemporal());
        this.setHeaderText(appointment.getSummary() + System.lineSeparator() + appointmentTime);
        this.setContentText(resources.getString("alert.one.appointment.content"));
        this.getDialogPane().setOnKeyPressed(event -> ((Button)this.getDialogPane().lookupButton(deleteButtonType)).fire());
    }
}

