/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control;

import java.time.LocalDateTime;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.LocalDateTimePickerSkin;

public class LocalDateTimePicker
extends Control {
    private final ObjectProperty<LocalDateTime> localDateTimeObjectProperty = new SimpleObjectProperty((Object)this, "localDateTime");
    private final ObjectProperty<LocalDateTime> displayedLocalDateTimeObjectProperty = new SimpleObjectProperty((Object)this, "displayedLocalDateTime", (Object)LocalDateTime.now());
    private volatile ObjectProperty<Locale> localeObjectProperty = new SimpleObjectProperty((Object)this, "locale", (Object)Locale.getDefault());
    private volatile BooleanProperty allowNullProperty = new SimpleBooleanProperty((Object)this, "allowNull", true);
    private final ObservableList<LocalDateTime> highlightedLocalDateTimes = FXCollections.observableArrayList();
    private final ObservableList<LocalDateTime> disabledLocalDateTimes = FXCollections.observableArrayList();
    private final ObjectProperty<Callback<LocalDateTimeRange, Void>> localDateTimeRangeCallbackObjectProperty = new SimpleObjectProperty((Object)this, "localDateTimeRangeCallback", null);
    private final ObjectProperty<Callback<LocalDateTime, Boolean>> valueValidationCallbackObjectProperty = new SimpleObjectProperty((Object)this, "valueValidationCallback", null);

    public LocalDateTimePicker() {
        this.construct();
    }

    public LocalDateTimePicker(LocalDateTime localDateTime) {
        this.construct();
        this.setLocalDateTime(localDateTime);
    }

    private void construct() {
    }

    public Skin createDefaultSkin() {
        return new LocalDateTimePickerSkin(this);
    }

    public ObjectProperty<LocalDateTime> localDateTimeProperty() {
        return this.localDateTimeObjectProperty;
    }

    public LocalDateTime getLocalDateTime() {
        return (LocalDateTime)this.localDateTimeObjectProperty.getValue();
    }

    public void setLocalDateTime(LocalDateTime value) {
        this.localDateTimeObjectProperty.setValue((Object)value);
    }

    public LocalDateTimePicker withLocalDateTime(LocalDateTime value) {
        this.setLocalDateTime(value);
        return this;
    }

    public ObjectProperty<LocalDateTime> displayedLocalDateTimeProperty() {
        return this.displayedLocalDateTimeObjectProperty;
    }

    public LocalDateTime getDisplayedLocalDateTime() {
        return (LocalDateTime)this.displayedLocalDateTimeObjectProperty.getValue();
    }

    public void setDisplayedLocalDateTime(LocalDateTime value) {
        this.displayedLocalDateTimeObjectProperty.setValue((Object)value);
    }

    public LocalDateTimePicker withDisplayedLocalDateTime(LocalDateTime value) {
        this.setDisplayedLocalDateTime(value);
        return this;
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.localeObjectProperty;
    }

    public Locale getLocale() {
        return (Locale)this.localeObjectProperty.getValue();
    }

    public void setLocale(Locale value) {
        this.localeObjectProperty.setValue((Object)value);
    }

    public LocalDateTimePicker withLocale(Locale value) {
        this.setLocale(value);
        return this;
    }

    public BooleanProperty allowNullProperty() {
        return this.allowNullProperty;
    }

    public boolean getAllowNull() {
        return this.allowNullProperty.get();
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNullProperty.set(allowNull);
    }

    public LocalDateTimePicker withAllowNull(boolean value) {
        this.setAllowNull(value);
        return this;
    }

    public ObservableList<LocalDateTime> highlightedLocalDateTimes() {
        return this.highlightedLocalDateTimes;
    }

    public ObservableList<LocalDateTime> disabledLocalDateTimes() {
        return this.disabledLocalDateTimes;
    }

    public ObjectProperty<Callback<LocalDateTimeRange, Void>> LocalDateTimeRangeCallbackProperty() {
        return this.localDateTimeRangeCallbackObjectProperty;
    }

    public Callback<LocalDateTimeRange, Void> getLocalDateTimeRangeCallback() {
        return (Callback)this.localDateTimeRangeCallbackObjectProperty.getValue();
    }

    public void setLocalDateTimeRangeCallback(Callback<LocalDateTimeRange, Void> value) {
        this.localDateTimeRangeCallbackObjectProperty.setValue(value);
    }

    public LocalDateTimePicker withLocalDateTimeRangeCallback(Callback<LocalDateTimeRange, Void> value) {
        this.setLocalDateTimeRangeCallback(value);
        return this;
    }

    public ObjectProperty<Callback<LocalDateTime, Boolean>> valueValidationCallbackProperty() {
        return this.valueValidationCallbackObjectProperty;
    }

    public Callback<LocalDateTime, Boolean> getValueValidationCallback() {
        return (Callback)this.valueValidationCallbackObjectProperty.getValue();
    }

    public void setValueValidationCallback(Callback<LocalDateTime, Boolean> value) {
        this.valueValidationCallbackObjectProperty.setValue(value);
    }

    public LocalDateTimePicker withValueValidationCallback(Callback<LocalDateTime, Boolean> value) {
        this.setValueValidationCallback(value);
        return this;
    }

    public static class LocalDateTimeRange {
        final LocalDateTime start;
        final LocalDateTime end;

        public LocalDateTimeRange(LocalDateTime start, LocalDateTime end) {
            this.start = start;
            this.end = end;
        }

        public LocalDateTime getStartLocalDateTime() {
            return this.start;
        }

        public LocalDateTime getEndLocalDateTime() {
            return this.end;
        }
    }
}

