/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control.agenda.icalendar;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.Control;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.util.Pair;
import jfxtras.icalendarfx.VCalendar;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.components.VComponent;
import jfxtras.icalendarfx.components.VDisplayable;
import jfxtras.icalendarfx.properties.VPropertyElement;
import jfxtras.icalendarfx.properties.component.relationship.Organizer;
import jfxtras.icalendarfx.utilities.Callback;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;
import jfxtras.internal.scene.control.skin.agenda.AgendaSkin;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.AgendaDateTimeUtilities;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.DeleteChoiceDialog;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.EditChoiceDialog;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.EditWithRecurrencesChoiceDialog;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.NewAppointmentDialog;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.OneAppointmentSelectedAlert;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.Settings;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.popup.EditDisplayableScene;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.popup.SimpleEditSceneFactory;
import jfxtras.scene.control.agenda.Agenda;
import jfxtras.scene.control.agenda.icalendar.editors.ChangeDialogOption;
import jfxtras.scene.control.agenda.icalendar.editors.deleters.SimpleDeleterFactory;
import jfxtras.scene.control.agenda.icalendar.editors.revisors.Reviser;
import jfxtras.scene.control.agenda.icalendar.editors.revisors.SimpleRevisorFactory;
import jfxtras.scene.control.agenda.icalendar.factories.DefaultRecurrenceFactory;
import jfxtras.scene.control.agenda.icalendar.factories.DefaultVComponentFactory;
import jfxtras.scene.control.agenda.icalendar.factories.RecurrenceFactory;
import jfxtras.scene.control.agenda.icalendar.factories.VComponentFactory;
import jfxtras.util.NodeUtil;

public class ICalendarAgenda
extends Agenda {
    public static final String ICALENDAR_STYLE_SHEET = ICalendarAgenda.class.getResource(ICalendarAgenda.class.getSimpleName() + ".css").toExternalForm();
    public static final String MY_VERSION = "1.0";
    public static final String DEFAULT_PRODUCT_IDENTIFIER = "-//JFxtras//iCalendarAgenda 1.0//EN";
    public static final String DEFAULT_ORGANIZER = "mailto:default_organizer@example.org";
    private ObjectProperty<Organizer> organizer = new SimpleObjectProperty((Object)this, VPropertyElement.ORGANIZER.toString(), (Object)Organizer.parse("mailto:default_organizer@example.org"));
    private static Integer nextKey = 0;
    private Callback<Void, String> uidGeneratorCallback = Void2 -> {
        String dateTime = DateTimeUtilities.LOCAL_DATE_TIME_FORMATTER.format(LocalDateTime.now());
        String domain = "jfxtras.org";
        Integer n = nextKey;
        Integer n2 = nextKey = Integer.valueOf(nextKey + 1);
        return dateTime + "-" + n + domain;
    };
    private final VCalendar vCalendar;
    private VComponentFactory<Agenda.Appointment> vComponentFactory;
    private RecurrenceFactory<Agenda.Appointment> recurrenceFactory;
    private Consumer<VCalendar> calendarConsumer = v -> {};
    private ObservableList<String> categories;
    private final Map<Integer, Temporal> appointmentStartOriginalMap = new HashMap<Integer, Temporal>();
    private final Map<Integer, VDisplayable<?>> appointmentVComponentMap = new HashMap();
    private final Map<Integer, List<Agenda.Appointment>> vComponentAppointmentMap = new HashMap<Integer, List<Agenda.Appointment>>();
    private final Map<Agenda.Appointment, Boolean> newAppointmentMap = new HashMap<Agenda.Appointment, Boolean>();
    private Alert lastOneAppointmentSelectedAlert;
    private javafx.util.Callback<Agenda.Appointment, Void> selectedOneAppointmentCallback = appointment -> {
        OneAppointmentSelectedAlert alert = new OneAppointmentSelectedAlert((Agenda.Appointment)appointment, Settings.resources);
        alert.initOwner(this.getScene().getWindow());
        Pane bodyPane = (Pane)((AgendaSkin)this.getSkin()).getNodeForPopup((Agenda.Appointment)appointment);
        double x = NodeUtil.screenX((Node)bodyPane) + bodyPane.getWidth() / 2.0;
        alert.setX(x);
        double y = NodeUtil.screenY((Node)bodyPane) + bodyPane.getHeight() / 2.0;
        alert.setY(y);
        if (this.lastOneAppointmentSelectedAlert != null) {
            this.lastOneAppointmentSelectedAlert.close();
        }
        this.lastOneAppointmentSelectedAlert = alert;
        alert.resultProperty().addListener((obs, oldValue, newValue) -> {
            if (newValue != null) {
                this.lastOneAppointmentSelectedAlert = null;
                String buttonText = newValue.getText();
                if (buttonText.equals(Settings.resources.getString("edit"))) {
                    this.getEditAppointmentCallback().call(appointment);
                } else if (buttonText.equals(Settings.resources.getString("delete"))) {
                    VDisplayable<?> vComponent = this.appointmentVComponentMap.get(System.identityHashCode(appointment));
                    VDisplayable vComponentCopy = null;
                    try {
                        vComponentCopy = (VDisplayable)vComponent.getClass().newInstance();
                        vComponent.copyChildrenInto(vComponentCopy);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        e.printStackTrace();
                    }
                    List<VCalendar> cancelMessage = SimpleDeleterFactory.newDeleter(vComponentCopy, DeleteChoiceDialog.DELETE_DIALOG_CALLBACK, appointment.getStartTemporal()).delete();
                    this.getVCalendar().processITIPMessage(cancelMessage);
                    this.calendarConsumer.accept(this.getVCalendar());
                    this.refresh();
                }
            }
        });
        alert.show();
        return null;
    };
    private javafx.util.Callback<Agenda.Appointment, ButtonBar.ButtonData> newAppointmentDrawnCallback = appointment -> {
        NewAppointmentDialog newAppointmentDialog = new NewAppointmentDialog((Agenda.Appointment)appointment, this.appointmentGroups(), Settings.resources);
        Pane bodyPane = (Pane)((AgendaSkin)this.getSkin()).getNodeForPopup((Agenda.Appointment)appointment);
        double x = NodeUtil.screenX((Node)bodyPane) + bodyPane.getPrefWidth() / 2.0;
        newAppointmentDialog.setX(x);
        double y = NodeUtil.screenY((Node)bodyPane);
        newAppointmentDialog.setY(y);
        newAppointmentDialog.getDialogPane().getStylesheets().add((Object)this.getUserAgentStylesheet());
        Optional result = newAppointmentDialog.showAndWait();
        ButtonBar.ButtonData button = result.isPresent() ? (ButtonBar.ButtonData)result.get() : ButtonBar.ButtonData.CANCEL_CLOSE;
        return button;
    };
    private ListChangeListener<Agenda.Appointment> appointmentsListChangeListener;

    public ObjectProperty<Organizer> organizerProperty() {
        return this.organizer;
    }

    public Organizer getOrganizer() {
        return (Organizer)this.organizer.get();
    }

    public void setOrganizer(Organizer organizer) {
        this.organizer.set((Object)organizer);
        if (this.vComponentFactory instanceof DefaultVComponentFactory) {
            this.vComponentFactory = new DefaultVComponentFactory(this.getOrganizer(), this.getUidGeneratorCallback());
        }
    }

    public void setOrganizer(String organizer) {
        this.setOrganizer(Organizer.parse(organizer));
    }

    public ICalendarAgenda withOrganizer(Organizer organizer) {
        this.setOrganizer(organizer);
        return this;
    }

    public ICalendarAgenda withOrganizer(String organizer) {
        this.setOrganizer(organizer);
        return this;
    }

    public Callback<Void, String> getUidGeneratorCallback() {
        return this.uidGeneratorCallback;
    }

    public void setUidGeneratorCallback(Callback<Void, String> uidCallback) {
        this.uidGeneratorCallback = uidCallback;
        if (this.vComponentFactory instanceof DefaultVComponentFactory) {
            this.vComponentFactory = new DefaultVComponentFactory(this.getOrganizer(), this.getUidGeneratorCallback());
        }
    }

    public ICalendarAgenda withUidGeneratorCallback(Callback<Void, String> uidCallback) {
        this.setUidGeneratorCallback(uidCallback);
        return this;
    }

    public VCalendar getVCalendar() {
        return this.vCalendar;
    }

    public VComponentFactory<Agenda.Appointment> getVComponentFactory() {
        return this.vComponentFactory;
    }

    public void setVComponentFactory(VComponentFactory<Agenda.Appointment> vComponentFactory) {
        this.vComponentFactory = vComponentFactory;
    }

    public RecurrenceFactory<Agenda.Appointment> getRecurrenceFactory() {
        return this.recurrenceFactory;
    }

    public void setRecurrenceFactory(RecurrenceFactory<Agenda.Appointment> recurrenceFactory) {
        this.recurrenceFactory = recurrenceFactory;
    }

    public void setVCalendarUpdatedConsumer(Consumer<VCalendar> calendarConsumer) {
        this.calendarConsumer = calendarConsumer;
    }

    public Consumer<VCalendar> getVCalendarUpdatedConsumer() {
        return this.calendarConsumer;
    }

    public ObservableList<String> getCategories() {
        return this.categories;
    }

    public void setCategories(ObservableList<String> categories) {
        this.categories = categories;
    }

    public void setSelectedOneAppointmentCallback(javafx.util.Callback<Agenda.Appointment, Void> c) {
        this.selectedOneAppointmentCallback = c;
    }

    public javafx.util.Callback<Agenda.Appointment, Void> getSelectedOneAppointmentCallback() {
        return this.selectedOneAppointmentCallback;
    }

    public javafx.util.Callback<Agenda.Appointment, ButtonBar.ButtonData> getNewAppointmentDrawnCallback() {
        return this.newAppointmentDrawnCallback;
    }

    public void setNewAppointmentDrawnCallback(javafx.util.Callback<Agenda.Appointment, ButtonBar.ButtonData> c) {
        this.newAppointmentDrawnCallback = c;
    }

    public ICalendarAgenda() {
        this(new VCalendar());
    }

    public ICalendarAgenda(VCalendar vCalendar) {
        this.vCalendar = vCalendar;
        this.recurrenceFactory = new DefaultRecurrenceFactory((Collection<Agenda.AppointmentGroup>)this.appointmentGroups());
        this.vComponentFactory = new DefaultVComponentFactory(this.getOrganizer(), this.getUidGeneratorCallback());
        Locale myLocale = Locale.getDefault();
        ResourceBundle resources = ResourceBundle.getBundle("jfxtras.ICalendarAgenda", myLocale);
        Settings.setup(resources);
        this.setNewAppointmentCallback((javafx.util.Callback<Agenda.LocalDateTimeRange, Agenda.Appointment>)((javafx.util.Callback)dateTimeRange -> {
            ZonedDateTime s = dateTimeRange.getStartLocalDateTime().atZone(ZoneId.systemDefault());
            ZonedDateTime e = dateTimeRange.getEndLocalDateTime().atZone(ZoneId.systemDefault());
            return (Agenda.Appointment)((Agenda.AppointmentImplTemporal)new Agenda.AppointmentImplTemporal().withStartTemporal(s).withEndTemporal(e).withSummary(resources.getString("new"))).withAppointmentGroup((Agenda.AppointmentGroup)this.appointmentGroups().get(0));
        }));
        javafx.util.Callback appointmentChangedCallback = appointment -> {
            VDisplayable<?> vComponent = this.appointmentVComponentMap.get(System.identityHashCode(appointment));
            Object[] params = this.revisorParamGenerator(vComponent, (Agenda.Appointment)appointment);
            List<VCalendar> iTIPMessage = SimpleRevisorFactory.newReviser(vComponent, params).revise();
            this.getVCalendar().processITIPMessage(iTIPMessage);
            this.calendarConsumer.accept(this.getVCalendar());
            this.appointmentStartOriginalMap.put(System.identityHashCode(appointment), appointment.getStartTemporal());
            Platform.runLater(() -> this.refresh());
            return null;
        };
        this.setAppointmentChangedCallback((javafx.util.Callback<Agenda.Appointment, Void>)appointmentChangedCallback);
        javafx.util.Callback editAppointmentCallback = appointment -> {
            VDisplayable<?> vComponent = this.appointmentVComponentMap.get(System.identityHashCode(appointment));
            if (vComponent == null) {
                vComponent = this.getVComponentFactory().createVComponent((Agenda.Appointment)appointment);
            }
            Stage popupStage = new Stage();
            String appointmentTime = AgendaDateTimeUtilities.formatRange(appointment.getStartTemporal(), appointment.getEndTemporal());
            popupStage.setTitle((String)vComponent.getSummary().getValue() + ":" + appointmentTime);
            Object[] params = new Object[]{this.getVCalendar(), appointment.getStartTemporal(), appointment.getEndTemporal(), this.getCategories()};
            EditDisplayableScene popupScene = SimpleEditSceneFactory.newScene(vComponent, params);
            popupScene.getStylesheets().addAll((Object[])new String[]{this.getUserAgentStylesheet(), ICALENDAR_STYLE_SHEET});
            popupStage.setScene((Scene)popupScene);
            Pane bodyPane = (Pane)((AgendaSkin)this.getSkin()).getNodeForPopup((Agenda.Appointment)appointment);
            double prefHeightControl = ((Control)popupStage.getScene().getRoot()).getPrefHeight();
            double prefWidthControl = ((Control)popupStage.getScene().getRoot()).getPrefWidth();
            double xLeft = NodeUtil.screenX((Node)bodyPane) - prefWidthControl - 5.0;
            double xRight = NodeUtil.screenX((Node)bodyPane) + bodyPane.getWidth() + 5.0;
            double x = xLeft > 0.0 ? xLeft : xRight;
            double y = NodeUtil.screenY((Node)bodyPane) - prefHeightControl / 2.0;
            popupStage.setX(x);
            popupStage.setY(y);
            popupStage.show();
            popupScene.getEditDisplayableTabPane().iTIPMessagesProperty().addListener((obs, oldValue, newValue) -> {
                newValue.forEach(message -> this.getVCalendar().processITIPMessage((VCalendar)message));
                this.calendarConsumer.accept(this.getVCalendar());
                popupStage.hide();
                this.refresh();
            });
            return null;
        };
        this.setEditAppointmentCallback((javafx.util.Callback<Agenda.Appointment, Void>)editAppointmentCallback);
        this.categories = FXCollections.observableArrayList((Collection)this.appointmentGroups().stream().map(a -> a.getDescription()).collect(Collectors.toList()));
        this.getCategories().addListener(change -> {
            while (change.next()) {
                if (!change.wasAdded()) continue;
                change.getAddedSubList().forEach(c -> {
                    int index = change.getList().indexOf(c);
                    ((Agenda.AppointmentGroup)this.appointmentGroups().get(index)).setDescription((String)c);
                });
            }
        });
        this.appointmentsListChangeListener = change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    boolean isOneAppointmentAdded;
                    boolean bl = isOneAppointmentAdded = change.getAddedSubList().size() == 1;
                    if (isOneAppointmentAdded) {
                        Agenda.Appointment appointment2 = (Agenda.Appointment)change.getAddedSubList().get(0);
                        ButtonBar.ButtonData button = (ButtonBar.ButtonData)this.newAppointmentDrawnCallback.call(change.getAddedSubList().get(0));
                        switch (button) {
                            case CANCEL_CLOSE: {
                                this.appointments().remove((Object)appointment2);
                                ((AgendaSkin)this.getSkin()).setupAppointments();
                                break;
                            }
                            case OK_DONE: {
                                VDisplayable<?> newVComponent = this.getVComponentFactory().createVComponent(appointment2);
                                VCalendar message = Reviser.emptyPublishiTIPMessage();
                                message.addChild(newVComponent);
                                this.getVCalendar().processITIPMessage(message);
                                this.calendarConsumer.accept(this.getVCalendar());
                                List<VChild> calendarChildren = vCalendar.childrenUnmodifiable();
                                VDisplayable v = (VDisplayable)calendarChildren.get(calendarChildren.size() - 1);
                                this.vComponentAppointmentMap.put(System.identityHashCode(v), new ArrayList<Agenda.Appointment>(Arrays.asList(appointment2)));
                                this.appointmentVComponentMap.put(System.identityHashCode(appointment2), v);
                                this.appointmentStartOriginalMap.put(System.identityHashCode(appointment2), appointment2.getStartTemporal());
                                Platform.runLater(() -> ((AgendaSkin)this.getSkin()).setupAppointments());
                                break;
                            }
                            case OTHER: {
                                editAppointmentCallback.call((Object)appointment2);
                                break;
                            }
                            default: {
                                throw new RuntimeException("unknown button type:" + button);
                            }
                        }
                        continue;
                    }
                    throw new RuntimeException("Adding multiple appointments at once is not supported (" + change.getAddedSubList().size() + ")");
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(appointment -> {
                    VDisplayable<?> vComponent = this.appointmentVComponentMap.remove(System.identityHashCode(appointment));
                    List<Agenda.Appointment> mappedAppointments = this.vComponentAppointmentMap.get(System.identityHashCode(vComponent));
                    mappedAppointments.remove(appointment);
                    VDisplayable vComponentCopy = null;
                    try {
                        vComponentCopy = (VDisplayable)vComponent.getClass().newInstance();
                        vComponent.copyChildrenInto(vComponentCopy);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        e.printStackTrace();
                    }
                    List<VCalendar> cancelMessage = SimpleDeleterFactory.newDeleter(vComponentCopy, (javafx.util.Callback<Map<ChangeDialogOption, Pair<Temporal, Temporal>>, ChangeDialogOption>)((javafx.util.Callback)choices -> ChangeDialogOption.ONE), appointment.getStartTemporal()).delete();
                    this.getVCalendar().processITIPMessage(cancelMessage);
                    this.calendarConsumer.accept(this.getVCalendar());
                });
            }
        };
        this.appointments().addListener(this.appointmentsListChangeListener);
        this.sceneProperty().addListener((obs, oldValue, newValue) -> {
            if (newValue != null) {
                this.getScene().setOnKeyPressed(event -> {
                    if (event.getCode().equals((Object)KeyCode.DELETE) && !this.selectedAppointments().isEmpty()) {
                        this.appointments().removeAll(this.selectedAppointments());
                    }
                });
            }
        });
        ListChangeListener selectOneAppointmentListener = change -> {
            while (change.next()) {
                if (!change.wasAdded() || this.selectedAppointments().size() != 1) continue;
                Agenda.Appointment appointment = (Agenda.Appointment)this.selectedAppointments().get(0);
                this.selectedOneAppointmentCallback.call((Object)appointment);
            }
        };
        this.selectedAppointments().addListener(selectOneAppointmentListener);
        this.setLocalDateTimeRangeCallback((javafx.util.Callback<Agenda.LocalDateTimeRange, Void>)((javafx.util.Callback)dateTimeRange -> {
            this.getRecurrenceFactory().setStartRange(dateTimeRange.getStartLocalDateTime());
            this.getRecurrenceFactory().setEndRange(dateTimeRange.getEndLocalDateTime());
            if (dateTimeRange != null) {
                this.updateAppointments();
            }
            return null;
        }));
    }

    private Object[] revisorParamGenerator(VDisplayable<?> vComponent, Agenda.Appointment appointment) {
        Temporal endRecurrence;
        Temporal startRecurrence;
        boolean isChangedToWholeDay;
        if (vComponent == null) {
            System.out.println("ERROR: no component found - popup can'b be displayed");
            return null;
        }
        VComponent vComponentCopy = null;
        try {
            vComponentCopy = (VComponent)vComponent.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        vComponent.copyChildrenInto(vComponentCopy);
        vComponentCopy.setParent(vComponent.getParent());
        Temporal startOriginalRecurrence = this.appointmentStartOriginalMap.get(System.identityHashCode(appointment));
        boolean wasDateType = DateTimeUtilities.DateTimeType.of(startOriginalRecurrence).equals((Object)DateTimeUtilities.DateTimeType.DATE);
        boolean isNotDateType = !DateTimeUtilities.DateTimeType.of(appointment.getStartTemporal()).equals((Object)DateTimeUtilities.DateTimeType.DATE);
        boolean isChangedToTimeBased = wasDateType && isNotDateType;
        boolean bl = isChangedToWholeDay = appointment.isWholeDay() != false && isNotDateType;
        if (isChangedToTimeBased) {
            startRecurrence = DateTimeUtilities.DateTimeType.DATE_WITH_LOCAL_TIME_AND_TIME_ZONE.from(appointment.getStartTemporal(), ZoneId.systemDefault());
            endRecurrence = DateTimeUtilities.DateTimeType.DATE_WITH_LOCAL_TIME_AND_TIME_ZONE.from(appointment.getEndTemporal(), ZoneId.systemDefault());
        } else if (isChangedToWholeDay) {
            startRecurrence = LocalDate.from(appointment.getStartTemporal());
            LocalDate endInstanceTemp = LocalDate.from(appointment.getEndTemporal());
            endRecurrence = ((Object)endInstanceTemp).equals(startRecurrence) ? endInstanceTemp.plus(1L, ChronoUnit.DAYS) : endInstanceTemp;
        } else {
            startRecurrence = appointment.getStartTemporal();
            endRecurrence = appointment.getEndTemporal();
        }
        javafx.util.Callback<Map<ChangeDialogOption, Pair<Temporal, Temporal>>, ChangeDialogOption> editDialogCallback = vComponent.recurrenceChildren().isEmpty() ? EditChoiceDialog.EDIT_DIALOG_CALLBACK : EditWithRecurrencesChoiceDialog.EDIT_DIALOG_CALLBACK;
        return new Object[]{editDialogCallback, endRecurrence, startOriginalRecurrence, startRecurrence, vComponentCopy, vComponent};
    }

    private Collection<Agenda.Appointment> makeAppointments(VDisplayable<?> v) {
        List<Agenda.Appointment> myAppointments = this.getRecurrenceFactory().makeRecurrences(v);
        myAppointments.forEach(a -> {
            this.appointmentVComponentMap.put(System.identityHashCode(a), v);
            this.appointmentStartOriginalMap.put(System.identityHashCode(a), a.getStartTemporal());
        });
        this.vComponentAppointmentMap.put(System.identityHashCode(v), myAppointments);
        return myAppointments;
    }

    public void updateAppointments() {
        ArrayList newAppointments = new ArrayList();
        this.appointments().removeListener(this.appointmentsListChangeListener);
        this.appointments().clear();
        this.vComponentAppointmentMap.clear();
        this.appointmentStartOriginalMap.clear();
        this.appointmentVComponentMap.clear();
        if (this.getVCalendar().getVEvents() != null) {
            this.getVCalendar().getVEvents().stream().forEach(v -> newAppointments.addAll(this.makeAppointments((VDisplayable<?>)v)));
        }
        if (this.getVCalendar().getVTodos() != null) {
            this.getVCalendar().getVTodos().stream().forEach(v -> newAppointments.addAll(this.makeAppointments((VDisplayable<?>)v)));
        }
        if (this.getVCalendar().getVJournals() != null) {
            this.getVCalendar().getVJournals().stream().forEach(v -> newAppointments.addAll(this.makeAppointments((VDisplayable<?>)v)));
        }
        this.appointments().addAll(newAppointments);
        this.appointments().addListener(this.appointmentsListChangeListener);
    }
}

