/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control.agenda.icalendar.editors;

import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javafx.util.Pair;
import jfxtras.icalendarfx.components.VDisplayable;
import jfxtras.icalendarfx.properties.VPropertyElement;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;

public enum ChangeDialogOption {
    ONE,
    ALL,
    ALL_IGNORE_RECURRENCES,
    THIS_AND_FUTURE,
    THIS_AND_FUTURE_IGNORE_RECURRENCES,
    CANCEL;


    public static <U extends VDisplayable<U>> Map<ChangeDialogOption, Pair<Temporal, Temporal>> makeDialogChoices(U vComponentOriginal, U vComponentEdited, Temporal startRecurrence, Collection<VPropertyElement> changedProperties) {
        boolean isFirstOrLastChanged;
        LinkedHashMap<ChangeDialogOption, Pair<Temporal, Temporal>> choices = new LinkedHashMap<ChangeDialogOption, Pair<Temporal, Temporal>>();
        if (!changedProperties.contains((Object)VPropertyElement.RECURRENCE_RULE)) {
            choices.put(ONE, new Pair((Object)startRecurrence, (Object)startRecurrence));
        }
        Temporal lastRecurrence = vComponentEdited.lastRecurrence();
        Stream<Temporal> s = vComponentEdited.streamRecurrences();
        Temporal firstRecurrence = s.findFirst().get();
        boolean isLastRecurrence = lastRecurrence == null ? false : startRecurrence.equals(lastRecurrence);
        boolean isAfterLastRecurrence = lastRecurrence == null ? false : DateTimeUtilities.isAfter(startRecurrence, lastRecurrence);
        boolean isFirstRecurrence = startRecurrence.equals(firstRecurrence);
        boolean isDTStartChanged = !vComponentEdited.getDateTimeStart().equals(vComponentOriginal.getDateTimeStart());
        boolean bl = isFirstOrLastChanged = !isLastRecurrence && !isFirstRecurrence;
        if (!isAfterLastRecurrence && (isFirstOrLastChanged || isDTStartChanged)) {
            Temporal start = startRecurrence == null ? (Temporal)vComponentEdited.getDateTimeStart().getValue() : startRecurrence;
            Period dateTimeStartShift = Period.between(LocalDate.from((TemporalAccessor)vComponentEdited.getDateTimeStart().getValue()), LocalDate.from((TemporalAccessor)vComponentOriginal.getDateTimeStart().getValue()));
            start = start.plus(dateTimeStartShift);
            choices.put(THIS_AND_FUTURE, (Pair<Temporal, Temporal>)new Pair((Object)start, (Object)lastRecurrence));
        }
        choices.put(ALL, new Pair(vComponentEdited.getDateTimeStart().getValue(), (Object)lastRecurrence));
        return choices;
    }

    public static <U extends VDisplayable<U>> Map<ChangeDialogOption, Pair<Temporal, Temporal>> makeDialogChoices(VDisplayable<?> vComponent, Temporal startOriginalRecurrence) {
        Temporal lastRecurrence;
        LinkedHashMap<ChangeDialogOption, Pair<Temporal, Temporal>> choices = new LinkedHashMap<ChangeDialogOption, Pair<Temporal, Temporal>>();
        long rdates = vComponent.getRecurrenceDates() != null ? vComponent.getRecurrenceDates().stream().flatMap(r -> ((Set)r.getValue()).stream()).count() : 0L;
        if (vComponent.getRecurrenceRule() != null || rdates > 1L) {
            boolean isLastRecurrence;
            choices.put(ONE, new Pair((Object)startOriginalRecurrence, (Object)startOriginalRecurrence));
            lastRecurrence = vComponent.lastRecurrence();
            boolean bl = isLastRecurrence = lastRecurrence == null ? false : startOriginalRecurrence.equals(lastRecurrence);
            if (!isLastRecurrence) {
                Temporal start = startOriginalRecurrence == null ? (Temporal)vComponent.getDateTimeStart().getValue() : startOriginalRecurrence;
                Period dateTimeStartShift = Period.between(LocalDate.from((TemporalAccessor)vComponent.getDateTimeStart().getValue()), LocalDate.from((TemporalAccessor)vComponent.getDateTimeStart().getValue()));
                start = start.plus(dateTimeStartShift);
                choices.put(THIS_AND_FUTURE, (Pair<Temporal, Temporal>)new Pair((Object)start, (Object)lastRecurrence));
            }
        } else {
            lastRecurrence = (Temporal)vComponent.getDateTimeStart().getValue();
        }
        choices.put(ALL, new Pair(vComponent.getDateTimeStart().getValue(), (Object)lastRecurrence));
        return choices;
    }
}

