/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control.agenda.icalendar.editors.revisors;

import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.util.Callback;
import javafx.util.Pair;
import jfxtras.icalendarfx.VCalendar;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.VParentBase;
import jfxtras.icalendarfx.components.VComponentBase;
import jfxtras.icalendarfx.components.VDisplayable;
import jfxtras.icalendarfx.components.VPersonal;
import jfxtras.icalendarfx.components.VPrimary;
import jfxtras.icalendarfx.properties.VPropertyElement;
import jfxtras.icalendarfx.properties.component.recurrence.RecurrenceRule;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RecurrenceRuleValue;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx.ByDay;
import jfxtras.icalendarfx.properties.component.relationship.RecurrenceId;
import jfxtras.icalendarfx.properties.component.time.DateTimeStart;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;
import jfxtras.scene.control.agenda.icalendar.editors.ChangeDialogOption;
import jfxtras.scene.control.agenda.icalendar.editors.revisors.Reviser;

public abstract class ReviserDisplayable<T, U extends VDisplayable<U>>
implements Reviser {
    private U vComponentEditedCopy;
    private U vComponentOriginal;
    private Temporal startOriginalRecurrence;
    private Temporal startRecurrence;
    private Callback<Map<ChangeDialogOption, Pair<Temporal, Temporal>>, ChangeDialogOption> dialogCallback;

    public ReviserDisplayable(U vComponent) {
        this.setVComponentCopyEdited(vComponent);
    }

    public U getVComponentCopyEdited() {
        return this.vComponentEditedCopy;
    }

    public void setVComponentCopyEdited(U vComponentEdited) {
        this.vComponentEditedCopy = vComponentEdited;
    }

    public T withVComponentCopyEdited(U vComponentEdited) {
        this.setVComponentCopyEdited(vComponentEdited);
        return (T)this;
    }

    public U getVComponentOriginal() {
        return this.vComponentOriginal;
    }

    public void setVComponentOriginal(U vComponentOriginal) {
        this.vComponentOriginal = vComponentOriginal;
    }

    public T withVComponentOriginal(U vComponentOriginal) {
        this.setVComponentOriginal(vComponentOriginal);
        return (T)this;
    }

    public Temporal getStartOriginalRecurrence() {
        return this.startOriginalRecurrence;
    }

    public void setStartOriginalRecurrence(Temporal startOriginalRecurrence) {
        this.startOriginalRecurrence = startOriginalRecurrence;
    }

    public T withStartOriginalRecurrence(Temporal startOriginalRecurrence) {
        this.setStartOriginalRecurrence(startOriginalRecurrence);
        return (T)this;
    }

    public Temporal getStartRecurrence() {
        return this.startRecurrence;
    }

    public void setStartRecurrence(Temporal startRecurrence) {
        this.startRecurrence = startRecurrence;
    }

    public T withStartRecurrence(Temporal startRecurrence) {
        this.setStartRecurrence(startRecurrence);
        return (T)this;
    }

    public Callback<Map<ChangeDialogOption, Pair<Temporal, Temporal>>, ChangeDialogOption> getDialogCallback() {
        return this.dialogCallback;
    }

    public void setDialogCallback(Callback<Map<ChangeDialogOption, Pair<Temporal, Temporal>>, ChangeDialogOption> dialogCallback) {
        this.dialogCallback = dialogCallback;
    }

    public T withDialogCallback(Callback<Map<ChangeDialogOption, Pair<Temporal, Temporal>>, ChangeDialogOption> dialogCallback) {
        this.setDialogCallback(dialogCallback);
        return (T)this;
    }

    boolean isValid() {
        if (this.getVComponentCopyEdited() == null) {
            System.out.println("vComponentEdited must not be null");
            return false;
        }
        if (this.getVComponentOriginal() == null) {
            System.out.println("vComponentOriginal must not be null");
            return false;
        }
        if (this.getStartOriginalRecurrence() == null) {
            System.out.println("startOriginalRecurrence must not be null");
            return false;
        }
        if (this.getStartRecurrence() == null) {
            System.out.println("startRecurrence must not be null");
            return false;
        }
        if (this.getDialogCallback() == null) {
            System.out.println("dialogCallback must not be null");
            return false;
        }
        return true;
    }

    @Override
    public List<VCalendar> revise() {
        if (!this.isValid()) {
            throw new RuntimeException("Invalid parameters for component revision:");
        }
        U vComponentEditedCopy = this.getVComponentCopyEdited();
        U vComponentOriginal = this.getVComponentOriginal();
        Temporal startRecurrence = this.getStartRecurrence();
        Temporal startOriginalRecurrence = this.getStartOriginalRecurrence();
        if (!vComponentOriginal.isValid()) {
            throw new RuntimeException("Can't revise. Original component is invalid:" + System.lineSeparator() + ((VDisplayable)vComponentEditedCopy).errors().stream().collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator() + vComponentEditedCopy);
        }
        ArrayList<VCalendar> itipMessages = new ArrayList<VCalendar>();
        this.validateStartRecurrenceAndDTStart(vComponentEditedCopy, this.getStartRecurrence());
        RRuleStatus rruleType = RRuleStatus.getRRuleType(((VDisplayable)vComponentOriginal).getRecurrenceRule(), ((VDisplayable)vComponentEditedCopy).getRecurrenceRule());
        boolean incrementSequence = true;
        block0 : switch (rruleType) {
            case HAD_REPEAT_BECOMING_INDIVIDUAL: {
                this.becomeNonRecurring(vComponentEditedCopy);
            }
            case WITH_NEW_REPEAT: 
            case INDIVIDUAL: {
                VCalendar message;
                if (((VComponentBase)vComponentEditedCopy).getParent() == null) {
                    message = Reviser.emptyPublishiTIPMessage();
                    incrementSequence = false;
                } else {
                    message = Reviser.emptyRequestiTIPMessage();
                }
                this.adjustStartAndEnd(vComponentEditedCopy, vComponentOriginal);
                ((VPersonal)vComponentEditedCopy).setDateTimeStamp(ZonedDateTime.now().withZoneSameInstant(ZoneId.of("Z")));
                message.addChild((VChild)vComponentEditedCopy);
                itipMessages.add(message);
                break;
            }
            case WITH_EXISTING_REPEAT: {
                ChangeDialogOption changeResponse;
                Collection<VPropertyElement> changedProperties = this.findChangedProperties(vComponentEditedCopy, vComponentOriginal);
                boolean provideDialog = changedProperties.stream().map(p -> this.dialogRequiredProperties().contains(p)).anyMatch(b -> b == true);
                if (changedProperties.size() <= 0) break;
                if (provideDialog) {
                    Map<ChangeDialogOption, Pair<Temporal, Temporal>> choices = ChangeDialogOption.makeDialogChoices(vComponentOriginal, vComponentEditedCopy, startOriginalRecurrence, changedProperties);
                    changeResponse = (ChangeDialogOption)((Object)this.dialogCallback.call(choices));
                } else {
                    changeResponse = ChangeDialogOption.ALL;
                }
                switch (changeResponse) {
                    case ALL: {
                        this.adjustDateTime(vComponentEditedCopy);
                        VCalendar requestMessage = Reviser.emptyRequestiTIPMessage();
                        requestMessage.addChild((VChild)vComponentEditedCopy);
                        itipMessages.add(requestMessage);
                        break block0;
                    }
                    case ALL_IGNORE_RECURRENCES: {
                        this.adjustDateTime(vComponentEditedCopy);
                        VCalendar requestMessage = Reviser.emptyRequestiTIPMessage();
                        requestMessage.addChild((VChild)vComponentEditedCopy);
                        itipMessages.add(requestMessage);
                        VCalendar publishMessage = Reviser.emptyPublishiTIPMessage();
                        List<VDisplayable<?>> children = this.adjustRecurrenceChildren(startRecurrence, startOriginalRecurrence);
                        children.forEach(c -> publishMessage.addChild((VChild)c));
                        itipMessages.add(publishMessage);
                        break block0;
                    }
                    case CANCEL: {
                        break block0;
                    }
                    case THIS_AND_FUTURE: {
                        U thisAndFutureVComponent = this.editThisAndFuture(vComponentEditedCopy, vComponentOriginal);
                        VCalendar requestMessage = Reviser.emptyRequestiTIPMessage();
                        requestMessage.addChild((VChild)thisAndFutureVComponent);
                        itipMessages.add(requestMessage);
                        VCalendar publishMessage = Reviser.emptyPublishiTIPMessage();
                        publishMessage.addChild((VChild)vComponentEditedCopy);
                        ((VDisplayable)thisAndFutureVComponent).incrementSequence();
                        incrementSequence = false;
                        itipMessages.add(publishMessage);
                        break block0;
                    }
                    case THIS_AND_FUTURE_IGNORE_RECURRENCES: {
                        U thisAndFutureVComponent = this.editThisAndFuture(vComponentEditedCopy, vComponentOriginal);
                        VCalendar requestMessage = Reviser.emptyRequestiTIPMessage();
                        requestMessage.addChild((VChild)thisAndFutureVComponent);
                        itipMessages.add(requestMessage);
                        VCalendar publishMessage = Reviser.emptyPublishiTIPMessage();
                        publishMessage.addChild((VChild)vComponentEditedCopy);
                        ((VDisplayable)thisAndFutureVComponent).incrementSequence();
                        incrementSequence = false;
                        itipMessages.add(publishMessage);
                        String uid = (String)((VPersonal)vComponentEditedCopy).getUniqueIdentifier().getValue();
                        List<VDisplayable> children = this.adjustRecurrenceChildren(startRecurrence, startOriginalRecurrence).stream().filter(c -> DateTimeUtilities.TEMPORAL_COMPARATOR2.compare((Temporal)c.getDateTimeStart().getValue(), startOriginalRecurrence) >= 0).peek(c -> {
                            c.setUniqueIdentifier(uid);
                            c.setDateTimeStamp(ZonedDateTime.now().withZoneSameInstant(ZoneId.of("Z")));
                        }).collect(Collectors.toList());
                        children.forEach(c -> publishMessage.addChild((VChild)c));
                        break block0;
                    }
                    case ONE: {
                        this.editOne(vComponentEditedCopy);
                        VCalendar message = Reviser.emptyPublishiTIPMessage();
                        message.addChild((VChild)vComponentEditedCopy);
                        itipMessages.add(message);
                        break block0;
                    }
                }
                throw new RuntimeException("Unsupprted response:" + (Object)((Object)changeResponse));
            }
        }
        if (incrementSequence) {
            ((VDisplayable)vComponentEditedCopy).incrementSequence();
        }
        return itipMessages;
    }

    private List<VDisplayable<?>> adjustRecurrenceChildren(Temporal startRecurrence, Temporal startOriginalRecurrence) {
        return ((VDisplayable)this.getVComponentOriginal()).recurrenceChildren().stream().map(v -> {
            Period dayShift = Period.between(LocalDate.from(startOriginalRecurrence), LocalDate.from((TemporalAccessor)v.getRecurrenceId().getValue()));
            Temporal newRecurreneId = startRecurrence.plus(dayShift);
            try {
                VDisplayable vCopy = (VDisplayable)v.getClass().newInstance();
                v.copyChildrenInto(vCopy);
                vCopy.setRecurrenceId(new RecurrenceId(newRecurreneId));
                return vCopy;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.toList());
    }

    void validateStartRecurrenceAndDTStart(U vComponentEditedCopy, Temporal startRecurrence) {
        Temporal firstTemporal;
        if (((VDisplayable)vComponentEditedCopy).getRecurrenceRule() != null && !(firstTemporal = ((RecurrenceRuleValue)((VDisplayable)vComponentEditedCopy).getRecurrenceRule().getValue()).streamRecurrences((Temporal)((VPrimary)vComponentEditedCopy).getDateTimeStart().getValue()).findFirst().get()).equals(((VPrimary)vComponentEditedCopy).getDateTimeStart().getValue())) {
            ((VPrimary)vComponentEditedCopy).setDateTimeStart(firstTemporal);
        }
    }

    void becomeNonRecurring(U vComponentEditedCopy) {
        vComponentEditedCopy.setRecurrenceRule((RecurrenceRuleValue)null);
        ((VDisplayable)vComponentEditedCopy).setRecurrenceDates(null);
        ((VDisplayable)vComponentEditedCopy).setExceptionDates(null);
    }

    void adjustDateTime(U vComponentEditedCopy) {
        DayOfWeek replacemenDayOfWeekt;
        DayOfWeek originalDayOfWeek;
        ByDay byDay;
        TemporalAmount shiftAmount = DateTimeUtilities.temporalAmountBetween(this.getStartOriginalRecurrence(), this.getStartRecurrence());
        TemporalAmount amountToStart = DateTimeUtilities.temporalAmountBetween((Temporal)((VPrimary)vComponentEditedCopy).getDateTimeStart().getValue(), this.getStartRecurrence());
        Temporal newStart = this.getStartRecurrence().minus(amountToStart).plus(shiftAmount);
        if (((VDisplayable)vComponentEditedCopy).getRecurrenceRule() != null && (byDay = (ByDay)((RecurrenceRuleValue)((VDisplayable)vComponentEditedCopy).getRecurrenceRule().getValue()).lookupByRule(ByDay.class)) != null && (originalDayOfWeek = DayOfWeek.from((TemporalAccessor)((VPrimary)vComponentEditedCopy).getDateTimeStart().getValue())) != (replacemenDayOfWeekt = DayOfWeek.from(newStart))) {
            byDay.replaceDayOfWeek(originalDayOfWeek, replacemenDayOfWeekt);
        }
        ((VPrimary)vComponentEditedCopy).setDateTimeStart(new DateTimeStart(newStart));
        ((VPersonal)vComponentEditedCopy).setDateTimeStamp(ZonedDateTime.now().withZoneSameInstant(ZoneId.of("Z")));
    }

    Collection<VPropertyElement> findChangedProperties(U vComponentEditedCopy, U vComponentOriginalCopy) {
        Map<String, VChild> editedMap = ((VParentBase)vComponentEditedCopy).childrenUnmodifiable().stream().collect(Collectors.toMap(v -> v.name(), v -> v));
        Map<String, VChild> originalMap = ((VParentBase)vComponentOriginalCopy).childrenUnmodifiable().stream().collect(Collectors.toMap(v -> v.name(), v -> v));
        List c1 = editedMap.entrySet().stream().filter(e -> {
            VChild original;
            String key = (String)e.getKey();
            VChild edited = (VChild)e.getValue();
            return !Objects.equals(edited, original = (VChild)originalMap.get(key));
        }).map(e -> (VChild)e.getValue()).map(v -> VPropertyElement.fromClass(v.getClass())).collect(Collectors.toList());
        List c2 = originalMap.entrySet().stream().filter(e -> {
            String key = (String)e.getKey();
            VChild original = (VChild)e.getValue();
            VChild edited = (VChild)editedMap.get(key);
            return !Objects.equals(edited, original);
        }).map(e -> (VChild)e.getValue()).map(v -> VPropertyElement.fromClass(v.getClass())).collect(Collectors.toList());
        HashSet<VPropertyElement> changedChildern = new HashSet<VPropertyElement>();
        changedChildern.addAll(c1);
        changedChildern.addAll(c2);
        if (!this.startOriginalRecurrence.equals(this.startRecurrence)) {
            changedChildern.add(VPropertyElement.DATE_TIME_START);
        }
        return changedChildern;
    }

    public List<VPropertyElement> dialogRequiredProperties() {
        return new ArrayList<VPropertyElement>(Arrays.asList(VPropertyElement.ATTACHMENT, VPropertyElement.ATTENDEE, VPropertyElement.CATEGORIES, VPropertyElement.COMMENT, VPropertyElement.CONTACT, VPropertyElement.DATE_TIME_START, VPropertyElement.RECURRENCE_RULE, VPropertyElement.STATUS, VPropertyElement.SUMMARY, VPropertyElement.UNIFORM_RESOURCE_LOCATOR));
    }

    void editOne(U vComponentEditedCopy) {
        ((VDisplayable)vComponentEditedCopy).setRecurrenceRule((RecurrenceRule)null);
        ((VPrimary)vComponentEditedCopy).setDateTimeStart(new DateTimeStart(this.getStartRecurrence()));
        ((VDisplayable)vComponentEditedCopy).setRecurrenceId(this.startOriginalRecurrence);
        ((VPersonal)vComponentEditedCopy).setDateTimeStamp(ZonedDateTime.now().withZoneSameInstant(ZoneId.of("Z")));
    }

    U editThisAndFuture(U vComponentEditedCopy, U vComponentOriginal) {
        Iterator recurrenceDateIterator;
        int result;
        Temporal t;
        Iterator exceptionDateIterator;
        Temporal untilNew;
        VDisplayable thisAndFutureVComponent = null;
        try {
            thisAndFutureVComponent = (VDisplayable)this.getVComponentOriginal().getClass().newInstance();
            ((VParentBase)this.getVComponentOriginal()).copyChildrenInto(thisAndFutureVComponent);
        }
        catch (IllegalAccessException | InstantiationException e2) {
            e2.printStackTrace();
        }
        if (((RecurrenceRuleValue)thisAndFutureVComponent.getRecurrenceRule().getValue()).getCount() != null) {
            ((RecurrenceRuleValue)thisAndFutureVComponent.getRecurrenceRule().getValue()).setCount(null);
        }
        if (((VPrimary)vComponentEditedCopy).isWholeDay()) {
            untilNew = vComponentEditedCopy.previousStreamValue(this.getStartOriginalRecurrence());
        } else {
            Temporal previousRecurrence = vComponentEditedCopy.previousStreamValue(this.getStartOriginalRecurrence());
            if (this.getStartOriginalRecurrence() instanceof LocalDateTime) {
                untilNew = LocalDateTime.from(previousRecurrence).atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneId.of("Z"));
            } else if (this.getStartOriginalRecurrence() instanceof ZonedDateTime) {
                untilNew = ((ZonedDateTime)previousRecurrence).withZoneSameInstant(ZoneId.of("Z"));
            } else {
                throw new DateTimeException("Unsupported Temporal type:" + previousRecurrence.getClass());
            }
        }
        ((RecurrenceRuleValue)thisAndFutureVComponent.getRecurrenceRule().getValue()).setUntil(untilNew);
        this.adjustStartAndEnd(vComponentEditedCopy, thisAndFutureVComponent);
        String relatedUID = thisAndFutureVComponent.getRelatedTo() == null ? (String)thisAndFutureVComponent.getUniqueIdentifier().getValue() : (String)thisAndFutureVComponent.getRelatedTo().get(0).getValue();
        ((VDisplayable)vComponentEditedCopy).withRelatedTo(relatedUID);
        ((VPersonal)vComponentEditedCopy).setDateTimeStamp(ZonedDateTime.now().withZoneSameInstant(ZoneId.of("Z")));
        if (((VDisplayable)vComponentEditedCopy).getExceptionDates() != null) {
            exceptionDateIterator = ((VDisplayable)vComponentEditedCopy).getExceptionDates().stream().flatMap(e -> ((Set)e.getValue()).stream()).iterator();
            while (exceptionDateIterator.hasNext()) {
                t = (Temporal)exceptionDateIterator.next();
                result = DateTimeUtilities.TEMPORAL_COMPARATOR.compare(t, this.getStartRecurrence());
                if (result >= 0) continue;
                exceptionDateIterator.remove();
            }
        }
        if (thisAndFutureVComponent.getExceptionDates() != null) {
            exceptionDateIterator = thisAndFutureVComponent.getExceptionDates().stream().flatMap(e -> ((Set)e.getValue()).stream()).iterator();
            while (exceptionDateIterator.hasNext()) {
                t = (Temporal)exceptionDateIterator.next();
                result = DateTimeUtilities.TEMPORAL_COMPARATOR.compare(t, this.getStartRecurrence());
                if (result <= 0) continue;
                exceptionDateIterator.remove();
            }
        }
        if (((VDisplayable)vComponentEditedCopy).getRecurrenceDates() != null) {
            recurrenceDateIterator = ((VDisplayable)vComponentEditedCopy).getRecurrenceDates().stream().flatMap(e -> ((Set)e.getValue()).stream()).iterator();
            while (recurrenceDateIterator.hasNext()) {
                t = (Temporal)recurrenceDateIterator.next();
                result = DateTimeUtilities.TEMPORAL_COMPARATOR.compare(t, this.getStartRecurrence());
                if (result >= 0) continue;
                recurrenceDateIterator.remove();
            }
        }
        if (thisAndFutureVComponent.getRecurrenceDates() != null) {
            recurrenceDateIterator = thisAndFutureVComponent.getRecurrenceDates().stream().flatMap(e -> ((Set)e.getValue()).stream()).iterator();
            while (recurrenceDateIterator.hasNext()) {
                t = (Temporal)recurrenceDateIterator.next();
                result = DateTimeUtilities.TEMPORAL_COMPARATOR.compare(t, this.getStartRecurrence());
                if (result <= 0) continue;
                recurrenceDateIterator.remove();
            }
        }
        ((VPersonal)vComponentEditedCopy).setUniqueIdentifier();
        if (((RecurrenceRuleValue)((VDisplayable)vComponentEditedCopy).getRecurrenceRule().getValue()).getCount() != null) {
            int countInOrginal = (int)thisAndFutureVComponent.streamRecurrences().count();
            int countInNew = (Integer)((RecurrenceRuleValue)((VDisplayable)vComponentEditedCopy).getRecurrenceRule().getValue()).getCount().getValue() - countInOrginal;
            ((RecurrenceRuleValue)((VDisplayable)vComponentEditedCopy).getRecurrenceRule().getValue()).setCount(countInNew);
        }
        if (!thisAndFutureVComponent.isValid()) {
            throw new RuntimeException("Invalid component:" + System.lineSeparator() + thisAndFutureVComponent.errors().stream().collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator() + thisAndFutureVComponent.toString());
        }
        return (U)thisAndFutureVComponent;
    }

    @Deprecated
    private void thisAndFutureIgnoreRecurrences(List<U> revisedVComponents, U vComponentEditedCopy) {
        List<VDisplayable<?>> recurrenceChildren = ((VDisplayable)this.getVComponentCopyEdited()).recurrenceChildren();
        if (!recurrenceChildren.isEmpty()) {
            recurrenceChildren.stream().forEach(c -> {
                boolean isAfterStartRecurrence;
                Temporal t = (Temporal)c.getRecurrenceId().getValue();
                boolean bl = isAfterStartRecurrence = DateTimeUtilities.TEMPORAL_COMPARATOR2.compare(t, this.getStartRecurrence()) > 0;
                if (isAfterStartRecurrence) {
                    String uniqueIdentifier = (String)vComponentEditedCopy.getUniqueIdentifier().getValue();
                    c.setUniqueIdentifier(uniqueIdentifier);
                    revisedVComponents.add(c);
                }
            });
        }
    }

    void adjustStartAndEnd(U vComponentEditedCopy, U vComponentOriginalCopy) {
    }

    static enum RRuleStatus {
        INDIVIDUAL,
        WITH_EXISTING_REPEAT,
        WITH_NEW_REPEAT,
        HAD_REPEAT_BECOMING_INDIVIDUAL;


        public static RRuleStatus getRRuleType(RecurrenceRule rruleEdited, RecurrenceRule rruleOriginal) {
            if (rruleOriginal == null) {
                if (rruleEdited == null) {
                    return INDIVIDUAL;
                }
                return HAD_REPEAT_BECOMING_INDIVIDUAL;
            }
            if (rruleEdited == null) {
                return WITH_NEW_REPEAT;
            }
            return WITH_EXISTING_REPEAT;
        }
    }
}

