/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control.agenda.icalendar.editors.revisors;

import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jfxtras.icalendarfx.components.VEvent;
import jfxtras.icalendarfx.properties.VPropertyElement;
import jfxtras.icalendarfx.properties.component.time.DateTimeEnd;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;
import jfxtras.scene.control.agenda.icalendar.editors.revisors.ReviserLocatable;

public class ReviserVEvent
extends ReviserLocatable<ReviserVEvent, VEvent> {
    public ReviserVEvent(VEvent component) {
        super(component);
    }

    @Override
    public void adjustDateTime(VEvent vComponentEditedCopy) {
        super.adjustDateTime(vComponentEditedCopy);
        this.adjustDateTimeEndOrDuration(vComponentEditedCopy);
    }

    private void adjustDateTimeEndOrDuration(VEvent vComponentEditedCopy) {
        TemporalAmount duration = DateTimeUtilities.temporalAmountBetween(this.getStartRecurrence(), this.getEndRecurrence());
        if (vComponentEditedCopy.getDuration() != null) {
            vComponentEditedCopy.setDuration(duration);
        } else if (vComponentEditedCopy.getDateTimeEnd() != null) {
            Temporal dtend = ((Temporal)vComponentEditedCopy.getDateTimeStart().getValue()).plus(duration);
            vComponentEditedCopy.setDateTimeEnd(new DateTimeEnd(dtend));
        } else {
            throw new RuntimeException("Either DTEND or DURATION must be set");
        }
    }

    @Override
    Collection<VPropertyElement> findChangedProperties(VEvent vComponentEditedCopy, VEvent vComponentOriginalCopy) {
        Collection<VPropertyElement> changedProperties = super.findChangedProperties(vComponentEditedCopy, vComponentOriginalCopy);
        TemporalAmount durationNew = DateTimeUtilities.temporalAmountBetween(this.getStartRecurrence(), this.getEndRecurrence());
        TemporalAmount durationOriginal = ((VEvent)this.getVComponentCopyEdited()).getActualDuration();
        if (!durationOriginal.equals(durationNew)) {
            if (((VEvent)this.getVComponentCopyEdited()).getDateTimeEnd() != null) {
                changedProperties.add(VPropertyElement.DATE_TIME_END);
            } else if (((VEvent)this.getVComponentCopyEdited()).getDuration() == null) {
                changedProperties.add(VPropertyElement.DURATION);
            }
        }
        return changedProperties;
    }

    @Override
    public List<VPropertyElement> dialogRequiredProperties() {
        List<VPropertyElement> list = super.dialogRequiredProperties();
        list.addAll(Arrays.asList(VPropertyElement.DESCRIPTION, VPropertyElement.DURATION, VPropertyElement.GEOGRAPHIC_POSITION, VPropertyElement.LOCATION, VPropertyElement.PRIORITY, VPropertyElement.RESOURCES));
        return list;
    }

    @Override
    void editOne(VEvent vComponentEditedCopy) {
        super.editOne(vComponentEditedCopy);
        this.adjustDateTimeEndOrDuration(vComponentEditedCopy);
    }
}

