/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.layout;

import javafx.scene.Node;
import javafx.scene.layout.Region;

class GenericLayoutConstraints {
    static final double UNKNOWN = 10.0;

    GenericLayoutConstraints() {
    }

    public static void overrideMaxWidth(Node node, C c) {
        if (node == null) {
            return;
        }
        if (node instanceof Region) {
            Region lRegion = (Region)node;
            lRegion.setMaxWidth(c.maxWidth >= 0.0 ? c.maxWidth : Double.MAX_VALUE);
        }
    }

    public static void overrideMaxHeight(Node node, C c) {
        if (node == null) {
            return;
        }
        if (node instanceof Region) {
            Region lRegion = (Region)node;
            lRegion.setMaxHeight(c.maxHeight >= 0.0 ? c.maxHeight : Double.MAX_VALUE);
        }
    }

    public static class C<T> {
        double minWidth = -1.0;
        double minWidthReset = 10.0;
        double prefWidth = -1.0;
        double prefWidthReset = 10.0;
        double maxWidth = -1.0;
        double maxWidthReset = 10.0;
        double minHeight = -1.0;
        double minHeightReset = 10.0;
        double prefHeight = -1.0;
        double prefHeightReset = 10.0;
        double maxHeight = -1.0;
        double maxHeightReset = 10.0;

        public T minWidth(double value) {
            this.minWidth = value;
            return (T)this;
        }

        public T prefWidth(double value) {
            this.prefWidth = value;
            return (T)this;
        }

        public T maxWidth(double value) {
            this.maxWidth = value;
            return (T)this;
        }

        public T minHeight(double value) {
            this.minHeight = value;
            return (T)this;
        }

        public T prefHeight(double value) {
            this.prefHeight = value;
            return (T)this;
        }

        public T maxHeight(double value) {
            this.maxHeight = value;
            return (T)this;
        }

        protected void rememberResetValues(Node node) {
            if (node instanceof Region) {
                Region lRegion = (Region)node;
                if (this.minWidthReset == 10.0) {
                    this.minWidthReset = lRegion.getMinWidth();
                }
                if (this.prefWidthReset == 10.0) {
                    this.prefWidthReset = lRegion.getPrefWidth();
                }
                if (this.maxWidthReset == 10.0) {
                    this.maxWidthReset = lRegion.getMaxWidth();
                }
                if (this.minHeightReset == 10.0) {
                    this.minHeightReset = lRegion.getMinHeight();
                }
                if (this.prefHeightReset == 10.0) {
                    this.prefHeightReset = lRegion.getPrefHeight();
                }
                if (this.maxHeightReset == 10.0) {
                    this.maxHeightReset = lRegion.getMaxHeight();
                }
            }
        }

        protected void apply(Node node) {
            if (node instanceof Region) {
                Region lRegion = (Region)node;
                this.rememberResetValues((Node)lRegion);
                lRegion.setMinWidth(this.minWidth >= 0.0 ? this.minWidth : this.minWidthReset);
                lRegion.setPrefWidth(this.prefWidth >= 0.0 ? this.prefWidth : this.prefWidthReset);
                lRegion.setMaxWidth(this.maxWidth >= 0.0 ? this.maxWidth : this.maxWidthReset);
                lRegion.setMinHeight(this.minHeight >= 0.0 ? this.minHeight : this.minHeightReset);
                lRegion.setPrefHeight(this.prefHeight >= 0.0 ? this.prefHeight : this.prefHeightReset);
                lRegion.setMaxHeight(this.maxHeight >= 0.0 ? this.maxHeight : this.maxHeightReset);
            }
        }
    }
}

