/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.util;

import com.sun.javafx.collections.ImmutableObservableList;
import java.util.ArrayList;
import java.util.Collections;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableNumberValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Pane;

public class NodeUtil {
    private NodeUtil() {
        throw new AssertionError();
    }

    public static double xInParent(Node node, Node parent) {
        double lX = 0.0;
        while (node != parent) {
            double lXDelta = node.getBoundsInParent().getMinX();
            lX += lXDelta;
            node = node.getParent();
        }
        return lX;
    }

    public static double yInParent(Node node, Node parent) {
        double lY = 0.0;
        while (node != parent) {
            double lYDelta = node.getBoundsInParent().getMinY();
            lY += lYDelta;
            node = node.getParent();
        }
        return lY;
    }

    public static double screenX(Node node) {
        return NodeUtil.sceneX(node) + node.getScene().getWindow().getX();
    }

    public static double screenY(Node node) {
        return NodeUtil.sceneY(node) + node.getScene().getWindow().getY();
    }

    public static double sceneX(Node node) {
        return node.localToScene(node.getBoundsInLocal()).getMinX() + node.getScene().getX();
    }

    public static double sceneY(Node node) {
        return node.localToScene(node.getBoundsInLocal()).getMinY() + node.getScene().getY();
    }

    public static void removeFromParent(Node n) {
        if (n.getParent() instanceof Group) {
            ((Group)n.getParent()).getChildren().remove((Object)n);
        } else if (n.getParent() instanceof Pane) {
            ((Pane)n.getParent()).getChildren().remove((Object)n);
        } else {
            throw new IllegalArgumentException("Unsupported parent: " + n.getParent());
        }
    }

    public static void addToParent(Parent p, Node n) {
        if (p instanceof Group) {
            ((Group)p).getChildren().add((Object)n);
        } else if (p instanceof Pane) {
            ((Pane)p).getChildren().add((Object)n);
        } else {
            throw new IllegalArgumentException("Unsupported parent: " + p);
        }
    }

    public static Node getNode(Parent p, double sceneX, double sceneY, Class<?> nodeClass) {
        ArrayList rightOrder = new ArrayList();
        rightOrder.addAll(p.getChildrenUnmodifiable());
        Collections.reverse(rightOrder);
        for (Node n : rightOrder) {
            boolean contains = n.contains(n.sceneToLocal(sceneX, sceneY));
            if (!contains) continue;
            if (nodeClass.isAssignableFrom(n.getClass())) {
                return n;
            }
            if (!(n instanceof Parent)) continue;
            return NodeUtil.getNode((Parent)n, sceneX, sceneY, nodeClass);
        }
        return null;
    }

    public static double snapXY(double position) {
        return (double)((int)position) + 0.5;
    }

    public static DoubleBinding snapXY(final ObservableNumberValue position) {
        return new DoubleBinding(){
            {
                super.bind(new Observable[]{position});
            }

            public void dispose() {
                super.unbind(new Observable[]{position});
            }

            protected double computeValue() {
                return NodeUtil.snapXY(position.doubleValue());
            }

            public ObservableList<?> getDependencies() {
                return FXCollections.singletonObservableList((Object)position);
            }
        };
    }

    public static double snapWH(double position, double offset) {
        return NodeUtil.snapXY(position + offset) - NodeUtil.snapXY(position);
    }

    public static DoubleBinding snapWH(final ObservableNumberValue position, final ObservableNumberValue offset, final Observable ... dependencies) {
        return new DoubleBinding(){
            {
                super.bind(dependencies);
            }

            public void dispose() {
                super.unbind(dependencies);
            }

            protected double computeValue() {
                return NodeUtil.snapWH(position.doubleValue(), offset.doubleValue());
            }

            public ObservableList<?> getDependencies() {
                return dependencies.length == 1 ? FXCollections.singletonObservableList((Object)dependencies[0]) : new ImmutableObservableList((Object[])dependencies);
            }
        };
    }

    public static void addStyleClass(Node node, String styleclass) {
        if (!node.getStyleClass().contains((Object)styleclass)) {
            node.getStyleClass().add((Object)styleclass);
        }
    }

    public static void removeStyleClass(Node node, String styleclass) {
        node.getStyleClass().remove((Object)styleclass);
    }

    public static String deriveCssFile(Node n) {
        Class<?> c = n.getClass();
        return c.getResource("/" + c.getPackage().getName().replaceAll("\\.", "/") + "/" + c.getSimpleName() + ".css").toExternalForm();
    }

    public static boolean isEffectivelyVisible(Node n) {
        while (n != null) {
            if (!n.isVisible()) {
                return false;
            }
            n = n.getParent();
        }
        return true;
    }
}

