/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.util;

import com.sun.javafx.tk.Toolkit;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;

public class PlatformUtil {
    public static void runAndWait(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
            return;
        }
        try {
            FutureTask<Object> future = new FutureTask<Object>(runnable, null);
            Platform.runLater(future);
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static <V> V runAndWait(Callable<V> callable) {
        if (Platform.isFxApplicationThread()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            FutureTask<V> future = new FutureTask<V>(callable);
            Platform.runLater(future);
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void waitForPaintPulse() {
        PlatformUtil.runAndWait(() -> Toolkit.getToolkit().firePulse());
    }
}

