/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.jnosql.diana.api.NonUniqueResultException;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentQuery;

public interface DocumentCollectionManagerAsync
extends AutoCloseable {
    public void insert(DocumentEntity var1);

    public void insert(DocumentEntity var1, Duration var2);

    default public void insert(Iterable<DocumentEntity> entities) {
        Objects.requireNonNull(entities, "entities is required");
        StreamSupport.stream(entities.spliterator(), false).forEach(this::insert);
    }

    default public void insert(Iterable<DocumentEntity> entities, Duration ttl) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(ttl, "ttl is required");
        StreamSupport.stream(entities.spliterator(), false).forEach(d -> this.insert((DocumentEntity)d, ttl));
    }

    public void insert(DocumentEntity var1, Consumer<DocumentEntity> var2);

    public void insert(DocumentEntity var1, Duration var2, Consumer<DocumentEntity> var3);

    public void update(DocumentEntity var1);

    default public void update(Iterable<DocumentEntity> entities) {
        Objects.requireNonNull(entities, "entities is required");
        StreamSupport.stream(entities.spliterator(), false).forEach(this::update);
    }

    public void update(DocumentEntity var1, Consumer<DocumentEntity> var2);

    public void delete(DocumentDeleteQuery var1);

    public void delete(DocumentDeleteQuery var1, Consumer<Void> var2);

    public void select(DocumentQuery var1, Consumer<List<DocumentEntity>> var2);

    default public void singleResult(DocumentQuery query, Consumer<Optional<DocumentEntity>> callBack) {
        this.select(query, entities -> {
            if (entities.isEmpty()) {
                callBack.accept(Optional.empty());
                return;
            }
            if (entities.size() == 1) {
                callBack.accept(Optional.of(entities.get(0)));
                return;
            }
            throw new NonUniqueResultException("The select returns more than one entity, select: " + query);
        });
    }

    @Override
    public void close();
}

