/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document.query;

import java.util.Arrays;
import java.util.Objects;
import org.jnosql.diana.api.document.Document;
import org.jnosql.diana.api.document.DocumentCondition;

abstract class BaseQueryBuilder {
    protected String name;
    protected boolean negate;
    protected boolean and;
    protected DocumentCondition condition;

    BaseQueryBuilder() {
    }

    protected <T> void eqImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.eq(Document.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected void gtImpl(Number value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.gt(Document.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected void likeImpl(String value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.like(Document.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected void ltImpl(Number value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.lt(Document.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected void lteImpl(Number value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.lte(Document.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected void gteImpl(Number value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.gte(Document.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected void betweenImpl(Number valueA, Number valueB) {
        Objects.requireNonNull(valueA, "valueA is required");
        Objects.requireNonNull(valueB, "valueB is required");
        DocumentCondition newCondition = DocumentCondition.between(Document.of(this.name, Arrays.asList(valueA, valueB)));
        this.appendCondition(newCondition);
    }

    protected <T> void inImpl(Iterable<T> values) {
        Objects.requireNonNull(values, "values is required");
        DocumentCondition newCondition = DocumentCondition.in(Document.of(this.name, values));
        this.appendCondition(newCondition);
    }

    protected void appendCondition(DocumentCondition newCondition) {
        if (this.negate) {
            newCondition = newCondition.negate();
        }
        this.condition = Objects.nonNull(this.condition) ? (this.and ? this.condition.and(newCondition) : this.condition.or(newCondition)) : newCondition;
        this.negate = false;
        this.name = null;
    }
}

