/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document.query;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.jnosql.diana.api.NonUniqueResultException;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsync;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentPreparedStatementAsync;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.api.document.query.Params;
import org.jnosql.query.QueryException;

final class DefaultDocumentPreparedStatementAsync
implements DocumentPreparedStatementAsync {
    private final DocumentEntity entity;
    private final DocumentQuery documentQuery;
    private final DocumentDeleteQuery documentDeleteQuery;
    private final PreparedStatementType type;
    private final Params params;
    private final String query;
    private final List<String> paramsLeft;
    private final Duration duration;
    private final DocumentCollectionManagerAsync manager;

    private DefaultDocumentPreparedStatementAsync(DocumentEntity entity, DocumentQuery documentQuery, DocumentDeleteQuery documentDeleteQuery, PreparedStatementType type, Params params, String query, List<String> paramsLeft, Duration duration, DocumentCollectionManagerAsync manager) {
        this.entity = entity;
        this.documentQuery = documentQuery;
        this.documentDeleteQuery = documentDeleteQuery;
        this.type = type;
        this.params = params;
        this.query = query;
        this.paramsLeft = paramsLeft;
        this.manager = manager;
        this.duration = duration;
    }

    @Override
    public DocumentPreparedStatementAsync bind(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        this.paramsLeft.remove(name);
        this.params.bind(name, value);
        return this;
    }

    @Override
    public void getResultList(Consumer<List<DocumentEntity>> callBack) {
        Objects.requireNonNull(callBack, "callBack is required");
        if (!this.paramsLeft.isEmpty()) {
            throw new QueryException("Check all the parameters before execute the query, params left: " + this.paramsLeft);
        }
        switch (this.type) {
            case SELECT: {
                this.manager.select(this.documentQuery, callBack);
                return;
            }
            case DELETE: {
                this.manager.delete(this.documentDeleteQuery, c -> callBack.accept(Collections.emptyList()));
                return;
            }
            case UPDATE: {
                this.manager.update(this.entity, c -> callBack.accept(Collections.singletonList(c)));
                return;
            }
            case INSERT: {
                if (Objects.isNull(this.duration)) {
                    this.manager.insert(this.entity, c -> callBack.accept(Collections.singletonList(c)));
                } else {
                    this.manager.insert(this.entity, this.duration, c -> callBack.accept(Collections.singletonList(c)));
                }
                return;
            }
        }
        throw new UnsupportedOperationException("there is not support to operation type: " + (Object)((Object)this.type));
    }

    @Override
    public void getSingleResult(Consumer<Optional<DocumentEntity>> callBack) {
        Objects.requireNonNull(callBack, "callBack is required");
        this.getResultList(entities -> {
            if (entities.isEmpty()) {
                callBack.accept(Optional.empty());
                return;
            }
            if (entities.size() == 1) {
                callBack.accept(Optional.of(entities.get(0)));
                return;
            }
            throw new NonUniqueResultException("The select returns more than one entity, select: " + this.query);
        });
    }

    public String toString() {
        return this.query;
    }

    static DefaultDocumentPreparedStatementAsync select(DocumentQuery documentQuery, Params params, String query, DocumentCollectionManagerAsync manager) {
        return new DefaultDocumentPreparedStatementAsync(null, documentQuery, null, PreparedStatementType.SELECT, params, query, params.getParametersNames(), null, manager);
    }

    static DefaultDocumentPreparedStatementAsync delete(DocumentDeleteQuery documentDeleteQuery, Params params, String query, DocumentCollectionManagerAsync manager) {
        return new DefaultDocumentPreparedStatementAsync(null, null, documentDeleteQuery, PreparedStatementType.DELETE, params, query, params.getParametersNames(), null, manager);
    }

    static DefaultDocumentPreparedStatementAsync insert(DocumentEntity entity, Params params, String query, Duration duration, DocumentCollectionManagerAsync manager) {
        return new DefaultDocumentPreparedStatementAsync(entity, null, null, PreparedStatementType.INSERT, params, query, params.getParametersNames(), duration, manager);
    }

    static DefaultDocumentPreparedStatementAsync update(DocumentEntity entity, Params params, String query, DocumentCollectionManagerAsync manager) {
        return new DefaultDocumentPreparedStatementAsync(entity, null, null, PreparedStatementType.UPDATE, params, query, params.getParametersNames(), null, manager);
    }

    static enum PreparedStatementType {
        SELECT,
        DELETE,
        UPDATE,
        INSERT;

    }
}

