/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document.query;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jnosql.diana.api.document.DocumentCollectionManager;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsync;
import org.jnosql.diana.api.document.DocumentCondition;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentObserverParser;
import org.jnosql.diana.api.document.DocumentPreparedStatement;
import org.jnosql.diana.api.document.DocumentPreparedStatementAsync;
import org.jnosql.diana.api.document.query.Conditions;
import org.jnosql.diana.api.document.query.DefaultDocumentPreparedStatement;
import org.jnosql.diana.api.document.query.DefaultDocumentPreparedStatementAsync;
import org.jnosql.diana.api.document.query.Params;
import org.jnosql.query.QueryException;
import org.jnosql.query.UpdateQuery;
import org.jnosql.query.UpdateQuerySupplier;

final class UpdateQueryParser {
    private final UpdateQuerySupplier supplier = UpdateQuerySupplier.getSupplier();

    UpdateQueryParser() {
    }

    List<DocumentEntity> query(String query, DocumentCollectionManager collectionManager, DocumentObserverParser observer) {
        UpdateQuery updateQuery = (UpdateQuery)this.supplier.apply((Object)query);
        Params params = new Params();
        DocumentEntity entity = this.getEntity(params, updateQuery, observer);
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return Collections.singletonList(collectionManager.update(entity));
    }

    void queryAsync(String query, DocumentCollectionManagerAsync collectionManager, Consumer<List<DocumentEntity>> callBack, DocumentObserverParser observer) {
        UpdateQuery updateQuery = (UpdateQuery)this.supplier.apply((Object)query);
        Params params = new Params();
        DocumentEntity entity = this.getEntity(params, updateQuery, observer);
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        collectionManager.update(entity, c -> callBack.accept(Collections.singletonList(c)));
    }

    DocumentPreparedStatement prepare(String query, DocumentCollectionManager collectionManager, DocumentObserverParser observer) {
        Params params = new Params();
        UpdateQuery updateQuery = (UpdateQuery)this.supplier.apply((Object)query);
        DocumentEntity entity = this.getEntity(params, updateQuery, observer);
        return DefaultDocumentPreparedStatement.update(entity, params, query, collectionManager);
    }

    DocumentPreparedStatementAsync prepareAsync(String query, DocumentCollectionManagerAsync collectionManager, DocumentObserverParser observer) {
        Params params = new Params();
        UpdateQuery updateQuery = (UpdateQuery)this.supplier.apply((Object)query);
        DocumentEntity entity = this.getEntity(params, updateQuery, observer);
        return DefaultDocumentPreparedStatementAsync.update(entity, params, query, collectionManager);
    }

    private DocumentEntity getEntity(Params params, UpdateQuery updateQuery, DocumentObserverParser observer) {
        String collection = observer.fireEntity(updateQuery.getEntity());
        DocumentEntity entity = DocumentEntity.of(collection);
        updateQuery.getConditions().stream().map(c -> Conditions.getCondition(c, params, observer, collection)).map(DocumentCondition::getDocument).forEach(entity::add);
        return entity;
    }
}

