/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.ravendb.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.ravendb.client.documents.queries.Query;
import net.ravendb.client.documents.session.IDocumentQuery;
import net.ravendb.client.documents.session.IDocumentSession;
import org.jnosql.diana.api.Sort;
import org.jnosql.diana.api.TypeReference;
import org.jnosql.diana.api.TypeSupplier;
import org.jnosql.diana.api.document.Document;
import org.jnosql.diana.api.document.DocumentCondition;
import org.jnosql.diana.api.document.DocumentQuery;

class DocumentQueryConversor {
    private DocumentQueryConversor() {
    }

    public static QueryResult createQuery(IDocumentSession session, DocumentQuery query) {
        ArrayList<String> ids = new ArrayList<String>();
        IDocumentQuery ravenQuery = session.query(HashMap.class, Query.collection((String)query.getDocumentCollection()));
        query.getCondition().ifPresent(c -> DocumentQueryConversor.feedQuery((IDocumentQuery<HashMap>)ravenQuery, c, ids));
        if (!ids.isEmpty() && query.getCondition().isPresent()) {
            return new QueryResult(ids, null);
        }
        return DocumentQueryConversor.appendRavenQuery(query, ids, (IDocumentQuery<HashMap>)ravenQuery);
    }

    private static QueryResult appendRavenQuery(DocumentQuery query, List<String> ids, IDocumentQuery<HashMap> ravenQuery) {
        Consumer<Sort> sortConsumer = s -> {
            switch (s.getType()) {
                case DESC: {
                    ravenQuery.orderByDescending(s.getName());
                    return;
                }
            }
            ravenQuery.orderBy(s.getName());
        };
        query.getSorts().forEach(sortConsumer);
        if (query.getSkip() > 0L) {
            ravenQuery.skip((int)query.getSkip());
        }
        if (query.getLimit() > 0L) {
            ravenQuery.take((int)query.getLimit());
        }
        return new QueryResult(ids, ravenQuery);
    }

    private static void feedQuery(IDocumentQuery<HashMap> ravenQuery, DocumentCondition condition, List<String> ids) {
        Document document = condition.getDocument();
        Object value = document.get();
        String name = document.getName();
        if ("_id".equals(name)) {
            ids.add(value.toString());
            return;
        }
        switch (condition.getCondition()) {
            case EQUALS: {
                ravenQuery.whereEquals(name, value);
                return;
            }
            case GREATER_THAN: {
                ravenQuery.whereGreaterThan(name, value);
                return;
            }
            case GREATER_EQUALS_THAN: {
                ravenQuery.whereGreaterThanOrEqual(name, value);
                return;
            }
            case LESSER_THAN: {
                ravenQuery.whereLessThan(name, value);
                return;
            }
            case LESSER_EQUALS_THAN: {
                ravenQuery.whereLessThanOrEqual(name, value);
                return;
            }
            case IN: {
                ravenQuery.whereIn(name, (Collection)document.get((TypeSupplier)new TypeReference<List<Object>>(){}));
                return;
            }
            case NOT: {
                ravenQuery.negateNext();
                DocumentQueryConversor.feedQuery(ravenQuery, (DocumentCondition)document.get(DocumentCondition.class), ids);
                return;
            }
            case LIKE: {
                throw new UnsupportedOperationException("Raven does not support LIKE Operator");
            }
            case AND: {
                ((List)condition.getDocument().getValue().get((TypeSupplier)new TypeReference<List<DocumentCondition>>(){})).forEach(c -> DocumentQueryConversor.feedQuery((IDocumentQuery<HashMap>)((IDocumentQuery)ravenQuery.andAlso()), c, ids));
                return;
            }
            case OR: {
                ((List)condition.getDocument().getValue().get((TypeSupplier)new TypeReference<List<DocumentCondition>>(){})).forEach(c -> DocumentQueryConversor.feedQuery((IDocumentQuery<HashMap>)((IDocumentQuery)ravenQuery.orElse()), c, ids));
                return;
            }
        }
        throw new UnsupportedOperationException("The condition " + condition.getCondition() + " is not supported from ravendb diana driver");
    }

    static class QueryResult {
        private final List<String> ids;
        private final IDocumentQuery<HashMap> ravenQuery;

        private QueryResult(List<String> ids, IDocumentQuery<HashMap> ravenQuery) {
            this.ids = ids;
            this.ravenQuery = ravenQuery;
        }

        public List<String> getIds() {
            return this.ids;
        }

        public Optional<IDocumentQuery<HashMap>> getRavenQuery() {
            return Optional.ofNullable(this.ravenQuery);
        }
    }
}

