/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.ravendb.document;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.document.Document;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.driver.ValueUtil;
import org.jnosql.diana.ravendb.document.RavenDBEntry;

final class EntityConverter {
    static final String ID_FIELD = "_id";

    private EntityConverter() {
    }

    public static String getId(Map entity) {
        Map metadata = (Map)entity.remove("@metadata");
        return (String)metadata.get("@id");
    }

    static DocumentEntity getEntity(Map map) {
        HashMap<String, Object> entity = new HashMap<String, Object>(map);
        Map metadata = (Map)entity.remove("@metadata");
        String id = metadata.get("@id").toString();
        String collection = metadata.get("@collection").toString();
        return new RavenDBEntry(id, collection, entity).toEntity();
    }

    static Map<String, Object> getMap(DocumentEntity entity) {
        HashMap<String, Object> entityMap = new HashMap<String, Object>();
        entity.getDocuments().stream().filter(d -> !ID_FIELD.equals(d.getName())).forEach(EntityConverter.feedJSON(entityMap));
        return entityMap;
    }

    private static Consumer<Document> feedJSON(Map<String, Object> map) {
        return d -> {
            Object value = ValueUtil.convert((Value)d.getValue());
            if (value instanceof Document) {
                Document subDocument = (Document)Document.class.cast(value);
                map.put(d.getName(), Collections.singletonMap(subDocument.getName(), subDocument.get()));
            } else if (EntityConverter.isSudDocument(value)) {
                Map<String, Object> subDocument = EntityConverter.getMap(value);
                map.put(d.getName(), subDocument);
            } else if (EntityConverter.isSudDocumentList(value)) {
                map.put(d.getName(), StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).map(EntityConverter::getMap).collect(Collectors.toList()));
            } else {
                map.put(d.getName(), value);
            }
        };
    }

    private static Map<String, Object> getMap(Object value) {
        HashMap<String, Object> subDocument = new HashMap<String, Object>();
        StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).forEach(EntityConverter.feedJSON(subDocument));
        return subDocument;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSudDocument(Object value) {
        if (!(value instanceof Iterable)) return false;
        if (!StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).allMatch(Document.class::isInstance)) return false;
        return true;
    }

    private static boolean isSudDocumentList(Object value) {
        return value instanceof Iterable && StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).allMatch(d -> d instanceof Iterable && EntityConverter.isSudDocument(d));
    }
}

