/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.ravendb.document;

import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.ravendb.client.documents.DocumentStore;
import net.ravendb.client.documents.queries.Query;
import net.ravendb.client.documents.session.IDocumentQuery;
import net.ravendb.client.documents.session.IDocumentSession;
import net.ravendb.client.documents.session.IEnumerableQuery;
import net.ravendb.client.documents.session.IMetadataDictionary;
import net.ravendb.client.exceptions.RavenException;
import org.jnosql.diana.api.document.Document;
import org.jnosql.diana.api.document.DocumentCollectionManager;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.ravendb.document.DocumentQueryConversor;
import org.jnosql.diana.ravendb.document.EntityConverter;
import org.jnosql.diana.ravendb.document.RavenDeleteQuery;

public class RavenDBDocumentCollectionManager
implements DocumentCollectionManager {
    private final DocumentStore store;

    RavenDBDocumentCollectionManager(DocumentStore store) {
        this.store = store;
        this.store.initialize();
    }

    public DocumentEntity insert(DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        try (IDocumentSession session = this.store.openSession();){
            this.insert(entity, null, session);
        }
        return entity;
    }

    public DocumentEntity insert(DocumentEntity entity, Duration ttl) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(ttl, "ttl is required");
        LocalDateTime time = LocalDateTime.now(Clock.systemUTC()).plus(ttl);
        try (IDocumentSession session = this.store.openSession();){
            this.insert(entity, time, session);
        }
        return entity;
    }

    public DocumentEntity update(DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        try (IDocumentSession session = this.store.openSession();){
            Document id = (Document)entity.find("_id").orElseThrow(() -> new RavenException("Id is required to Raven Update operation"));
            HashMap map = (HashMap)session.load(HashMap.class, (String)id.get(String.class));
            map.putAll(EntityConverter.getMap(entity));
            session.saveChanges();
        }
        return entity;
    }

    public void delete(DocumentDeleteQuery query) {
        Objects.requireNonNull(query, "query is required");
        try (IDocumentSession session = this.store.openSession();){
            List<Map> entities = this.getQueryMaps(new RavenDeleteQuery(query), session);
            entities.stream().map(EntityConverter::getId).forEach(arg_0 -> ((IDocumentSession)session).delete(arg_0));
            session.saveChanges();
        }
    }

    public List<DocumentEntity> select(DocumentQuery query) {
        Objects.requireNonNull(query, "query is required");
        try (IDocumentSession session = this.store.openSession();){
            List<Map> entities = this.getQueryMaps(query, session);
            List<DocumentEntity> list = entities.stream().filter(Objects::nonNull).map(EntityConverter::getEntity).collect(Collectors.toList());
            return list;
        }
    }

    public long count(String documentCollection) {
        Objects.requireNonNull(documentCollection, "documentCollection is required");
        try (IDocumentSession session = this.store.openSession();){
            IDocumentQuery ravenQuery = session.query(HashMap.class, Query.collection((String)documentCollection));
            long l = ravenQuery.count();
            return l;
        }
    }

    public void close() {
        this.store.close();
    }

    private void insert(DocumentEntity entity, LocalDateTime time, IDocumentSession session) {
        String collection = entity.getName();
        Map<String, Object> entityMap = EntityConverter.getMap(entity);
        String id = entity.find("_id").map(d -> (String)d.get(String.class)).orElse(collection + '/');
        session.store(entityMap, id);
        IMetadataDictionary metadata = session.advanced().getMetadataFor(entityMap);
        metadata.put((Object)"@collection", (Object)collection);
        if (Objects.nonNull(time)) {
            metadata.put((Object)"@expires", (Object)time.toString());
        }
        session.saveChanges();
        entity.add("_id", (Object)session.advanced().getDocumentId(entityMap));
    }

    private List<Map> getQueryMaps(DocumentQuery query, IDocumentSession session) {
        ArrayList<Map> entities = new ArrayList<Map>();
        DocumentQueryConversor.QueryResult queryResult = DocumentQueryConversor.createQuery(session, query);
        queryResult.getIds().stream().map(i -> (HashMap)session.load(HashMap.class, i)).forEach(entities::add);
        queryResult.getRavenQuery().map(IEnumerableQuery::toList).ifPresent(entities::addAll);
        return entities;
    }
}

