/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.ravendb.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jnosql.diana.api.Settings;
import org.jnosql.diana.api.document.DocumentConfiguration;
import org.jnosql.diana.driver.ConfigurationReader;
import org.jnosql.diana.ravendb.document.RavenDBDocumentCollectionManagerFactory;

public class RavenDBDocumentConfiguration
implements DocumentConfiguration<RavenDBDocumentCollectionManagerFactory> {
    private static final String FILE_CONFIGURATION = "diana-ravendb.properties";
    private List<String> hosts = new ArrayList<String>();

    public RavenDBDocumentCollectionManagerFactory get() {
        Map configuration = ConfigurationReader.from((String)FILE_CONFIGURATION);
        return this.get(configuration);
    }

    public RavenDBDocumentCollectionManagerFactory get(Settings settings) {
        Objects.requireNonNull(settings, "configurations is required");
        HashMap<String, String> configurations = new HashMap<String, String>();
        settings.forEach((key, value) -> configurations.put((String)key, value.toString()));
        return this.get(configurations);
    }

    private RavenDBDocumentCollectionManagerFactory get(Map<String, String> configurations) throws NullPointerException {
        Objects.requireNonNull(configurations, "configurations is required");
        String[] servers = (String[])configurations.keySet().stream().filter(s -> s.startsWith("ravendb-server-host-")).map(configurations::get).toArray(String[]::new);
        return new RavenDBDocumentCollectionManagerFactory(servers);
    }
}

