/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.ravendb.document;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jnosql.diana.api.document.Document;
import org.jnosql.diana.api.document.DocumentEntity;

final class RavenDBEntry {
    private final String id;
    private final Map<String, Object> map;
    private final String collection;
    private static final Function<Map.Entry<?, ?>, Document> ENTRY_DOCUMENT = entry -> Document.of((String)entry.getKey().toString(), entry.getValue());

    RavenDBEntry(String id, String collection, Map<String, Object> map) {
        this.id = id;
        this.collection = collection;
        this.map = map;
    }

    boolean isEmpty() {
        return Objects.isNull(this.id) || Objects.isNull(this.collection) || Objects.isNull(this.map);
    }

    boolean isNotEmpty() {
        return !this.isEmpty();
    }

    DocumentEntity toEntity() {
        Document id = Document.of((String)"_id", (Object)this.id);
        List documents = this.map.keySet().stream().map(k -> this.toDocument((String)k, this.map)).collect(Collectors.toList());
        DocumentEntity entity = DocumentEntity.of((String)this.collection, documents);
        entity.remove("_id");
        entity.add(id);
        return entity;
    }

    private Document toDocument(String key, Map<String, Object> properties) {
        Object value = properties.get(key);
        if (Map.class.isInstance(value)) {
            Map map = (Map)Map.class.cast(value);
            return Document.of((String)key, map.keySet().stream().map(k -> this.toDocument(k.toString(), map)).collect(Collectors.toList()));
        }
        if (this.isADocumentIterable(value)) {
            ArrayList documents = new ArrayList();
            for (Object object : (Iterable)Iterable.class.cast(value)) {
                Map map = (Map)Map.class.cast(object);
                documents.add(map.entrySet().stream().map(ENTRY_DOCUMENT).collect(Collectors.toList()));
            }
            return Document.of((String)key, documents);
        }
        return Document.of((String)key, (Object)value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isADocumentIterable(Object value) {
        if (!Iterable.class.isInstance(value)) return false;
        if (!StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).allMatch(Map.class::isInstance)) return false;
        return true;
    }
}

