/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import java.io.File;
import org.apache.commons.lang3.Validate;
import org.jodconverter.office.AbstractOfficeManager;
import org.jodconverter.office.ConnectRetryable;
import org.jodconverter.office.ExternalOfficeManagerConfig;
import org.jodconverter.office.InstalledOfficeManagerHolder;
import org.jodconverter.office.LocalOfficeUtils;
import org.jodconverter.office.OfficeConnection;
import org.jodconverter.office.OfficeConnectionProtocol;
import org.jodconverter.office.OfficeContext;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManager;
import org.jodconverter.office.OfficeManagerConfig;
import org.jodconverter.office.OfficeUrl;
import org.jodconverter.task.OfficeTask;

class ExternalOfficeManager
extends AbstractOfficeManager {
    public static final int DEFAULT_PORT_NUMBER = 2002;
    public static final String DEFAULT_PIPE_NAME = "office";
    public static final long DEFAULT_CONNECT_TIMEOUT = 120000L;
    public static final long DEFAULT_RETRY_INTERVAL = 250L;
    public static final long MAX_RETRY_INTERVAL = 10000L;
    private final OfficeConnection connection;

    public static Builder builder() {
        return new Builder();
    }

    public static ExternalOfficeManager make() {
        return ExternalOfficeManager.builder().build();
    }

    public static ExternalOfficeManager install() {
        return ((Builder)ExternalOfficeManager.builder().install()).build();
    }

    private ExternalOfficeManager(OfficeUrl officeUrl, ExternalOfficeManagerConfig config) {
        super((OfficeManagerConfig)config);
        this.connection = new OfficeConnection(officeUrl);
    }

    private void connect() throws OfficeException {
        try {
            ExternalOfficeManagerConfig mconfig = (ExternalOfficeManagerConfig)this.config;
            new ConnectRetryable(this.connection).execute(mconfig.getRetryInterval(), mconfig.getConnectTimeout());
        }
        catch (Exception ex) {
            throw new OfficeException("Could not establish connection to external office process", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OfficeTask task) throws OfficeException {
        OfficeConnection officeConnection = this.connection;
        synchronized (officeConnection) {
            if (!this.isRunning()) {
                this.connect();
            }
            task.execute((OfficeContext)this.connection);
        }
    }

    public boolean isRunning() {
        return this.connection.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws OfficeException {
        if (((ExternalOfficeManagerConfig)this.config).isConnectOnStart()) {
            OfficeConnection officeConnection = this.connection;
            synchronized (officeConnection) {
                this.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        OfficeConnection officeConnection = this.connection;
        synchronized (officeConnection) {
            if (this.isRunning()) {
                this.connection.disconnect();
            }
        }
    }

    public static final class Builder
    extends AbstractOfficeManager.AbstractOfficeManagerBuilder<Builder> {
        private OfficeConnectionProtocol connectionProtocol = OfficeConnectionProtocol.SOCKET;
        private int portNumber = 2002;
        private String pipeName = "office";
        private boolean connectOnStart = true;
        private long connectTimeout = 120000L;
        private long retryInterval = 250L;

        private Builder() {
        }

        public ExternalOfficeManager build() {
            if (this.workingDir == null) {
                this.workingDir = new File(System.getProperty("java.io.tmpdir"));
            }
            LocalOfficeUtils.validateOfficeWorkingDirectory(this.workingDir);
            ExternalOfficeManager manager = new ExternalOfficeManager(this.connectionProtocol == OfficeConnectionProtocol.SOCKET ? new OfficeUrl(this.portNumber) : (this.pipeName != null ? new OfficeUrl(this.pipeName) : new OfficeUrl(2002)), new ExternalOfficeManagerConfig(this.workingDir, this.connectOnStart, this.connectTimeout, this.retryInterval));
            if (this.install) {
                InstalledOfficeManagerHolder.setInstance((OfficeManager)manager);
            }
            return manager;
        }

        public Builder connectionProtocol(OfficeConnectionProtocol connectionProtocol) {
            Validate.notNull((Object)((Object)connectionProtocol), (String)"The protocol must not be null", (Object[])new Object[0]);
            this.connectionProtocol = connectionProtocol;
            return this;
        }

        public Builder pipeName(String pipeName) {
            Validate.notBlank((CharSequence)pipeName, (String)"The pipe name must not be blank", (Object[])new Object[0]);
            this.pipeName = pipeName;
            return this;
        }

        public Builder portNumber(int portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        public Builder connectOnStart(boolean connectOnStart) {
            this.connectOnStart = connectOnStart;
            return this;
        }

        public Builder connectTimeout(long connectTimeout) {
            Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)connectTimeout, (String)String.format("The connectTimeout %s must be greater than or equal to 0", connectTimeout));
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder retryInterval(long retryInterval) {
            Validate.inclusiveBetween((long)0L, (long)10000L, (long)retryInterval, (String)String.format("The retryInterval %s must be in the inclusive range of %s to %s", retryInterval, 0, 10000L));
            this.retryInterval = retryInterval;
            return this;
        }
    }
}

