/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OfficeDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfficeDescriptor.class);
    private String product = "???";
    private String version = "???";
    private boolean useLongOptionNameGnuStyle;

    private OfficeDescriptor() {
    }

    public static OfficeDescriptor fromHelpOutput(List<String> lines) {
        OfficeDescriptor desc = new OfficeDescriptor();
        LOGGER.debug("Building {} from help output lines", (Object)OfficeDescriptor.class.getName());
        String productLine = null;
        for (String line : lines) {
            if (line.contains("--help")) {
                desc.useLongOptionNameGnuStyle = true;
                continue;
            }
            String lowerLine = line.trim().toLowerCase();
            if (!lowerLine.startsWith("openoffice") && !lowerLine.startsWith("libreoffice")) continue;
            productLine = line.trim();
        }
        if (productLine != null) {
            String[] parts = productLine.split(" ");
            if (parts.length > 0) {
                desc.product = parts[0];
            }
            if (parts.length > 1) {
                desc.version = parts[1];
            }
        }
        LOGGER.info("soffice info (from help output): {}", (Object)desc.toString());
        return desc;
    }

    public static OfficeDescriptor fromExecutablePath(String path) {
        OfficeDescriptor desc = new OfficeDescriptor();
        if (path.toLowerCase().contains("openoffice")) {
            desc.product = "OpenOffice";
            desc.useLongOptionNameGnuStyle = false;
        }
        if (path.toLowerCase().contains("libreoffice")) {
            desc.product = "LibreOffice";
            desc.useLongOptionNameGnuStyle = true;
        }
        LOGGER.info("soffice info (from exec path): {}", (Object)desc.toString());
        return desc;
    }

    public String getProduct() {
        return this.product;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean useLongOptionNameGnuStyle() {
        return this.useLongOptionNameGnuStyle;
    }

    public String toString() {
        return String.format("Product: %s - Version: %s - useLongOptionNameGnuStyle: %s", this.getProduct(), this.getVersion(), this.useLongOptionNameGnuStyle());
    }
}

