/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XHierarchicalPropertySet;
import com.sun.star.beans.XHierarchicalPropertySetInfo;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XChangesBatch;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jodconverter.office.AbstractOfficeManagerPoolEntry;
import org.jodconverter.office.OfficeConnectionEvent;
import org.jodconverter.office.OfficeConnectionEventListener;
import org.jodconverter.office.OfficeContext;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManagerPoolEntryConfig;
import org.jodconverter.office.OfficeProcessManager;
import org.jodconverter.office.OfficeProcessManagerPoolEntryConfig;
import org.jodconverter.office.OfficeUrl;
import org.jodconverter.office.utils.Lo;
import org.jodconverter.task.OfficeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OfficeProcessManagerPoolEntry
extends AbstractOfficeManagerPoolEntry {
    private static final String PROPPATH_USE_OPENGL = "VCL/UseOpenGL";
    private static final Logger LOGGER = LoggerFactory.getLogger(OfficeProcessManagerPoolEntry.class);
    private final OfficeProcessManager officeProcessManager;
    private final AtomicInteger taskCount = new AtomicInteger(0);
    private final AtomicBoolean disconnectExpected = new AtomicBoolean(false);
    private final OfficeConnectionEventListener connectionEventListener = new OfficeConnectionEventListener(){

        @Override
        public void connected(OfficeConnectionEvent event) {
            OfficeProcessManagerPoolEntry.this.taskCount.set(0);
            OfficeProcessManagerPoolEntry.this.taskExecutor.setAvailable(true);
        }

        @Override
        public void disconnected(OfficeConnectionEvent event) {
            OfficeProcessManagerPoolEntry.this.taskExecutor.setAvailable(false);
            if (!OfficeProcessManagerPoolEntry.this.disconnectExpected.compareAndSet(true, false)) {
                LOGGER.warn("Connection lost unexpectedly; attempting restart");
                if (OfficeProcessManagerPoolEntry.this.currentFuture != null) {
                    OfficeProcessManagerPoolEntry.this.currentFuture.cancel(true);
                }
                OfficeProcessManagerPoolEntry.this.officeProcessManager.restartDueToLostConnection();
            }
        }
    };

    public OfficeProcessManagerPoolEntry(OfficeUrl officeUrl) {
        this(officeUrl, new OfficeProcessManagerPoolEntryConfig());
    }

    public OfficeProcessManagerPoolEntry(OfficeUrl officeUrl, OfficeProcessManagerPoolEntryConfig config) {
        super((OfficeManagerPoolEntryConfig)config);
        this.officeProcessManager = new OfficeProcessManager(officeUrl, config);
        this.officeProcessManager.getConnection().addConnectionEventListener(this.connectionEventListener);
    }

    public void doExecute(OfficeTask task) throws OfficeException {
        OfficeProcessManagerPoolEntryConfig entryConfig = (OfficeProcessManagerPoolEntryConfig)this.config;
        int count = this.taskCount.getAndIncrement();
        if (entryConfig.getMaxTasksPerProcess() > 0 && count == entryConfig.getMaxTasksPerProcess()) {
            LOGGER.info("Reached limit of {} maximum tasks per process; restarting...", (Object)entryConfig.getMaxTasksPerProcess());
            this.restart();
            this.taskCount.getAndIncrement();
        }
        task.execute((OfficeContext)this.officeProcessManager.getConnection());
    }

    protected void handleExecuteTimeoutException(TimeoutException timeoutEx) {
        this.officeProcessManager.restartDueToTaskTimeout();
    }

    public boolean isRunning() {
        return super.isRunning() && this.officeProcessManager.getConnection().isConnected();
    }

    public void doStart() throws OfficeException {
        this.officeProcessManager.startAndWait();
        OfficeProcessManagerPoolEntryConfig entryConfig = (OfficeProcessManagerPoolEntryConfig)this.config;
        if (entryConfig.isDisableOpengl() && this.disableOpengl(this.officeProcessManager.getConnection().getComponentContext())) {
            LOGGER.info("OpenGL has been disabled and a restart is required; restarting...");
            this.restart();
        }
    }

    public void doStop() throws OfficeException {
        this.disconnectExpected.set(true);
        this.officeProcessManager.stopAndWait();
    }

    private void restart() throws OfficeException {
        this.taskExecutor.setAvailable(false);
        this.disconnectExpected.set(true);
        this.officeProcessManager.restartAndWait();
    }

    private Object createConfigurationView(XMultiServiceFactory provider, String path) throws Exception {
        PropertyValue argument = new PropertyValue();
        argument.Name = "nodepath";
        argument.Value = path;
        Object[] arguments = new Object[]{argument};
        return provider.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess", arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean disableOpengl(XComponentContext officeContext) throws OfficeException {
        try {
            Object viewRoot = this.createConfigurationView(Lo.createInstanceMCF(officeContext, XMultiServiceFactory.class, "com.sun.star.configuration.ConfigurationProvider"), "/org.openoffice.Office.Common");
            try {
                XHierarchicalPropertySet properties = Lo.qi(XHierarchicalPropertySet.class, viewRoot);
                XHierarchicalPropertySetInfo propsInfo = properties.getHierarchicalPropertySetInfo();
                if (!propsInfo.hasPropertyByHierarchicalName(PROPPATH_USE_OPENGL)) return false;
                boolean useOpengl = (Boolean)properties.getHierarchicalPropertyValue(PROPPATH_USE_OPENGL);
                LOGGER.info("Use OpenGL is set to {}", (Object)useOpengl);
                if (!useOpengl) return false;
                properties.setHierarchicalPropertyValue(PROPPATH_USE_OPENGL, (Object)false);
                XChangesBatch updateControl = Lo.qi(XChangesBatch.class, viewRoot);
                updateControl.commitChanges();
                boolean bl = true;
                return bl;
            }
            finally {
                Lo.qi(XComponent.class, viewRoot).dispose();
            }
        }
        catch (Exception ex) {
            throw new OfficeException("Unable to check if the Use OpenGL option is on.", (Throwable)ex);
        }
    }
}

