/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.util.LocalServiceFactory;
import org.jolokia.server.core.util.RequestType;
import org.jolokia.service.jmx.api.CommandHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandHandlerManager {
    private final Map<RequestType, CommandHandler> requestHandlerMap = new HashMap<RequestType, CommandHandler>();

    public CommandHandlerManager(JolokiaContext pCtx) {
        this(pCtx, null);
    }

    public CommandHandlerManager(JolokiaContext pCtx, String pRealm) {
        List handlers = LocalServiceFactory.createServices((ClassLoader)this.getClass().getClassLoader(), (String[])new String[]{"META-INF/jolokia/command-handlers"});
        for (CommandHandler handler : handlers) {
            handler.init(pCtx, pRealm);
            this.requestHandlerMap.put(handler.getType(), handler);
        }
    }

    public <R extends JolokiaRequest> CommandHandler<R> getCommandHandler(RequestType pType) {
        CommandHandler handler = this.requestHandlerMap.get(pType);
        if (handler == null) {
            throw new UnsupportedOperationException("Unsupported operation '" + pType + "'");
        }
        return handler;
    }

    public void destroy() throws JMException {
        for (CommandHandler handler : this.requestHandlerMap.values()) {
            handler.destroy();
        }
    }
}

